/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.natives.plugin;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.codehaus.mojo:native-maven-plugin:1.0-alpha-3", 0);
        this.append(sb, "", 0);
        this.append(sb, "Maven Native Plugin", 0);
        this.append(sb, "(no description available)", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 8 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "compile".equals(this.goal)) {
            this.append(sb, "native:compile", 0);
            this.append(sb, "Compile source files into native object files", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "compilerEndOptions", 2);
                this.append(sb, "Compiler options", 3);
                this.append(sb, "", 0);
                this.append(sb, "compilerExecutable", 2);
                this.append(sb, "Use this field to override provider specific compiler executable", 3);
                this.append(sb, "", 0);
                this.append(sb, "compilerMiddleOptions", 2);
                this.append(sb, "Compiler options", 3);
                this.append(sb, "", 0);
                this.append(sb, "compilerProvider (Default: generic)", 2);
                this.append(sb, "Compiler Provider Type", 3);
                this.append(sb, "", 0);
                this.append(sb, "compilerStartOptions", 2);
                this.append(sb, "Compiler options", 3);
                this.append(sb, "", 0);
                this.append(sb, "envFactoryName", 2);
                this.append(sb, "Specifies a fully qualified class name implementing the org.codehaus.mojo.natives.EnvFactory interface. The class creates a set environment variables to be used with the command line.", 3);
                this.append(sb, "", 0);
                this.append(sb, "javahOS", 2);
                this.append(sb, "Javah OS name. ${jdkIncludePath} and ${jdkIncludePath}/${javaOS} are added to system include path when this field is set", 3);
                this.append(sb, "", 0);
                this.append(sb, "jdkIncludePath (Default: ${java.home}/../include)", 2);
                this.append(sb, "JDK native include directory", 3);
                this.append(sb, "", 0);
                this.append(sb, "objectFileExtension", 2);
                this.append(sb, "Use this field to override object file extension. The default extenstions are .obj and .o on Windows and Unix respectively", 3);
                this.append(sb, "", 0);
                this.append(sb, "sources", 2);
                this.append(sb, "Array of NativeSources containing include directories and source files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "workingDirectory (Default: ${basedir})", 2);
                this.append(sb, "user directory when external tools( ie compiler/linker ) are invoked", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "compile-message".equals(this.goal)) {
            this.append(sb, "native:compile-message", 0);
            this.append(sb, "Compile Windows message files", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "envFactoryName", 2);
                this.append(sb, "Specifies a fully qualified class name implementing the org.codehaus.mojo.natives.EnvFactory interface. The class creates a set environment variables to be used with the command line.", 3);
                this.append(sb, "", 0);
                this.append(sb, "messageCompilerExecutable", 2);
                this.append(sb, "Use this field to override provider specific message compiler executable", 3);
                this.append(sb, "", 0);
                this.append(sb, "messageCompilerOptions", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "messageFiles", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "provider (Default: msvc)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "workingDirectory (Default: ${basedir})", 2);
                this.append(sb, "user directory when external tools( ie compiler/linker ) are invoked", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "native:help", 0);
            this.append(sb, "Display help information on native-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0native:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "initialize".equals(this.goal)) {
            this.append(sb, "native:initialize", 0);
            this.append(sb, "Initialize build lifecycle", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "javah".equals(this.goal)) {
            this.append(sb, "native:javah", 0);
            this.append(sb, "Generate jni include files based on a set of class names", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "classNames", 2);
                this.append(sb, "List of class names to generate native files. Default is all JNI classes available in the classpath excluding the transitive dependencies, jars with test scope and provided scope", 3);
                this.append(sb, "", 0);
                this.append(sb, "implementation (Default: default)", 2);
                this.append(sb, "Javah Provider.", 3);
                this.append(sb, "", 0);
                this.append(sb, "javahPath", 2);
                this.append(sb, "Path to javah executable, if present, it will overide the default one which bases on architecture type. See 'implementation' argument", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.build.directory}/native/javah)", 2);
                this.append(sb, "Generated native source files go here", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputFileName", 2);
                this.append(sb, "if configured will be combined with outputDirectory to pass into javah's -o option", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: false)", 2);
                this.append(sb, "Enable javah verbose mode", 3);
                this.append(sb, "", 0);
                this.append(sb, "workingDirectory (Default: ${basedir})", 2);
                this.append(sb, "user directory when external tools( ie compiler/linker ) are invoked", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "link".equals(this.goal)) {
            this.append(sb, "native:link", 0);
            this.append(sb, "Link all previously built object and dependent library files into final build artifact", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "attach (Default: true)", 2);
                this.append(sb, "Attach the linker's outputs to maven project be installed/deployed. Turn this off if you have other mean of deployment, for example using maven-assembly-plugin to deploy your own bundle", 3);
                this.append(sb, "", 0);
                this.append(sb, "classifier", 2);
                this.append(sb, "Option to install primary artifact as a classifier, useful to install/deploy debug artifacts", 3);
                this.append(sb, "", 0);
                this.append(sb, "compilerProvider (Default: generic)", 2);
                this.append(sb, "Override this property if permitted by compilerProvider", 3);
                this.append(sb, "", 0);
                this.append(sb, "envFactoryName", 2);
                this.append(sb, "Specifies a fully qualified class name implementing the org.codehaus.mojo.natives.EnvFactory interface. The class creates a set environment variables to be used with the command line.", 3);
                this.append(sb, "", 0);
                this.append(sb, "linkerEndOptions", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "linkerExecutable", 2);
                this.append(sb, "Override this property if permitted by linkerProvider", 3);
                this.append(sb, "", 0);
                this.append(sb, "linkerMiddleOptions", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "linkerProvider", 2);
                this.append(sb, "Default value is ${compilerProvider}", 3);
                this.append(sb, "", 0);
                this.append(sb, "linkerSecondaryOutputExtensions", 2);
                this.append(sb, "Comma separated extension type to be installed/deployed. Use this option to deploy library file produced by dll build on windows", 3);
                this.append(sb, "", 0);
                this.append(sb, "linkerStartOptions", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "linkingOrderLibs", 2);
                this.append(sb, "Option to reorder dependency list, each item has the format of ${groupId}:${artifactId}", 3);
                this.append(sb, "", 0);
                this.append(sb, "workingDirectory (Default: ${basedir})", 2);
                this.append(sb, "user directory when external tools( ie compiler/linker ) are invoked", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "ranlib".equals(this.goal)) {
            this.append(sb, "native:ranlib", 0);
            this.append(sb, "ranlib a Unix linker output file", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "envFactoryName", 2);
                this.append(sb, "Specifies a fully qualified class name implementing the org.codehaus.mojo.natives.EnvFactory interface. The class creates a set environment variables to be used with the command line.", 3);
                this.append(sb, "", 0);
                this.append(sb, "provider (Default: default)", 2);
                this.append(sb, "Ranlib Provider.", 3);
                this.append(sb, "", 0);
                this.append(sb, "workingDirectory (Default: ${basedir})", 2);
                this.append(sb, "user directory when external tools( ie compiler/linker ) are invoked", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "resource-compile".equals(this.goal)) {
            this.append(sb, "native:resource-compile", 0);
            this.append(sb, "Compile Windows resource files", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "envFactoryName", 2);
                this.append(sb, "Specifies a fully qualified class name implementing the org.codehaus.mojo.natives.EnvFactory interface. The class creates a set environment variables to be used with the command line.", 3);
                this.append(sb, "", 0);
                this.append(sb, "provider (Default: msvc)", 2);
                this.append(sb, "Compiler Provider Type", 3);
                this.append(sb, "", 0);
                this.append(sb, "resourceCompilerExecutable", 2);
                this.append(sb, "Use this field to override provider specific resource compiler executable", 3);
                this.append(sb, "", 0);
                this.append(sb, "resourceCompilerOptions", 2);
                this.append(sb, "Resource compiler options", 3);
                this.append(sb, "", 0);
                this.append(sb, "sources", 2);
                this.append(sb, "Array of NativeSources containing include directories and source files", 3);
                this.append(sb, "", 0);
                this.append(sb, "workingDirectory (Default: ${basedir})", 2);
                this.append(sb, "user directory when external tools( ie compiler/linker ) are invoked", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

