/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.natives.plugin;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.natives.NativeBuildException;
import org.codehaus.mojo.natives.javah.Javah;
import org.codehaus.mojo.natives.javah.JavahConfiguration;
import org.codehaus.mojo.natives.manager.JavahManager;
import org.codehaus.mojo.natives.manager.NoSuchNativeProviderException;
import org.codehaus.plexus.util.FileUtils;

public class NativeJavahMojo
extends AbstractMojo {
    private String implementation;
    private String[] classNames;
    private File javahPath;
    private MavenProject project;
    protected File workingDirectory;
    private File outputDirectory;
    private String outputFileName;
    private boolean verbose;
    private JavahManager manager;
    private JavahConfiguration config;

    public void execute() throws MojoExecutionException {
        try {
            this.config = this.createProviderConfiguration();
            this.getJavah().compile(this.config);
        }
        catch (NativeBuildException e) {
            throw new MojoExecutionException("Error running javah command", (Exception)((Object)e));
        }
        this.project.addCompileSourceRoot(this.outputDirectory.getAbsolutePath());
    }

    private Javah getJavah() throws MojoExecutionException {
        Javah javah;
        try {
            javah = this.manager.getJavah(this.implementation);
        }
        catch (NoSuchNativeProviderException pe) {
            throw new MojoExecutionException(pe.getMessage());
        }
        return javah;
    }

    private List getJavahArtifacts() {
        ArrayList<Artifact> list = new ArrayList<Artifact>();
        Set artifacts = this.project.getDependencyArtifacts();
        Iterator iter = artifacts.iterator();
        while (iter.hasNext()) {
            Artifact artifact = (Artifact)iter.next();
            if (!"jar".equals(artifact.getType()) || "provided".equals(artifact.getScope()) || "test".equals(artifact.getScope())) continue;
            list.add(artifact);
        }
        return list;
    }

    private String[] getJavahClassPath() {
        List artifacts = this.getJavahArtifacts();
        String[] classPaths = new String[artifacts.size() + 1];
        classPaths[0] = this.project.getBuild().getOutputDirectory();
        Iterator iter = artifacts.iterator();
        for (int i = 1; i < classPaths.length; ++i) {
            Artifact artifact = (Artifact)iter.next();
            classPaths[i] = artifact.getFile().getPath();
        }
        return classPaths;
    }

    private String[] getNativeClassNames() throws MojoExecutionException {
        if (this.classNames != null) {
            return this.classNames;
        }
        List artifacts = this.getJavahArtifacts();
        ArrayList<String> scannedClassNames = new ArrayList<String>();
        Iterator iter = artifacts.iterator();
        while (iter.hasNext()) {
            Artifact artifact = (Artifact)iter.next();
            this.getLog().info((CharSequence)("Parsing " + artifact.getFile() + " for native classes."));
            try {
                Enumeration<? extends ZipEntry> zipEntries = new ZipFile(artifact.getFile()).entries();
                block3: while (zipEntries.hasMoreElements()) {
                    ZipEntry zipEntry = zipEntries.nextElement();
                    if (!"class".equals(FileUtils.extension((String)zipEntry.getName()))) continue;
                    ClassParser parser = new ClassParser(artifact.getFile().getPath(), zipEntry.getName());
                    JavaClass clazz = parser.parse();
                    Method[] methods = clazz.getMethods();
                    for (int j = 0; j < methods.length; ++j) {
                        if (!methods[j].isNative()) continue;
                        scannedClassNames.add(clazz.getClassName());
                        this.getLog().info((CharSequence)("Found native class: " + clazz.getClassName()));
                        continue block3;
                    }
                }
            }
            catch (IOException ioe) {
                throw new MojoExecutionException("Error searching for native class in " + artifact.getFile(), (Exception)ioe);
            }
        }
        return scannedClassNames.toArray(new String[scannedClassNames.size()]);
    }

    private JavahConfiguration createProviderConfiguration() throws MojoExecutionException {
        JavahConfiguration config = new JavahConfiguration();
        config.setWorkingDirectory(this.workingDirectory);
        config.setVerbose(this.verbose);
        config.setOutputDirectory(this.outputDirectory);
        config.setFileName(this.outputFileName);
        config.setClassPaths(this.getJavahClassPath());
        config.setClassNames(this.getNativeClassNames());
        config.setJavahPath(this.javahPath);
        return config;
    }

    protected JavahConfiguration getJavahConfiguration() {
        return this.config;
    }

    protected MavenProject getProject() {
        return this.project;
    }
}

