/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.remotesrc;

import java.io.File;
import java.util.Map;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.tools.context.BuildAdvisor;
import org.codehaus.plexus.context.Context;

public abstract class AbstractRemoteSourceMojo
extends AbstractMojo {
    private static final String SOURCE_ARCHIVE_FILE = ":sourceArchiveFile";
    private String projectId;
    private MavenProject project;
    private MavenSession session;

    protected abstract boolean isSkip();

    protected String getProjectId() {
        return this.projectId;
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected MavenSession getSession() {
        return this.session;
    }

    protected void setSourceArchiveFile(String projectId, File sourceArchive) {
        Map context = this.getPluginContext();
        this.getLog().info((CharSequence)("[ON SET] Plugin context hashcode is: " + ((Object)context).hashCode()));
        this.getLog().info((CharSequence)("[SET] Source archive file for project: " + projectId + " is: " + sourceArchive));
        context.put(projectId + SOURCE_ARCHIVE_FILE, sourceArchive);
    }

    protected File getSourceArchiveFile(String projectId) {
        Map context = this.getPluginContext();
        this.getLog().info((CharSequence)("[ON GET] Plugin context hashcode is: " + ((Object)context).hashCode()));
        File sourceArchive = (File)context.get(projectId + SOURCE_ARCHIVE_FILE);
        this.getLog().info((CharSequence)("[GET] Source archive file for project: " + projectId + " is: " + sourceArchive));
        return sourceArchive;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if ("pom".equals(this.project.getPackaging())) {
            this.getLog().info((CharSequence)"Skipping POM project.");
            return;
        }
        if (this.isSkip()) {
            this.getLog().info(this.getSkipMessage());
            return;
        }
        if (BuildAdvisor.isProjectBuildSkipped((MavenProject)this.project, (Context)this.session.getContainer().getContext())) {
            this.getLog().info((CharSequence)"Skipping execution per pre-existing advice.");
            return;
        }
        this.doExecute();
    }

    protected abstract CharSequence getSkipMessage();

    protected abstract void doExecute() throws MojoExecutionException, MojoFailureException;
}

