/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.remotesrc;

import java.io.File;
import java.util.Vector;
import org.apache.maven.cli.ConsoleDownloadMonitor;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.shared.io.download.DownloadFailedException;
import org.apache.maven.shared.io.download.DownloadManager;
import org.apache.maven.shared.io.logging.DefaultMessageHolder;
import org.apache.maven.shared.io.logging.MessageHolder;
import org.codehaus.mojo.remotesrc.GetSourceArtifactMojo;
import org.codehaus.mojo.tools.fs.archive.ArchiveFileExtensions;
import org.codehaus.plexus.util.StringUtils;

public class SourceGetMojo
extends GetSourceArtifactMojo {
    private String url;
    private DownloadManager downloadManager;

    public void doExecute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)("Resolving source archive for project: " + this.getProjectId() + " from: {local, URL, repository}."));
        if (StringUtils.isNotEmpty((String)this.url)) {
            File local = new File(this.url);
            if (local.exists()) {
                this.getLog().info((CharSequence)("Using local archive at: " + local));
                this.setSourceArchiveFile(this.getProjectId(), local);
            } else {
                this.getLog().info((CharSequence)"Supplied archive URL is not a local file.");
            }
        } else {
            this.getLog().info((CharSequence)"Source archive URL was not specified.");
        }
        if (this.getSourceArchiveFile(this.getProjectId()) == null) {
            this.getLog().info((CharSequence)("Resolving source archive for project: " + this.getProjectId() + " from: {URL, repository}."));
            Vector<ConsoleDownloadMonitor> transferListeners = new Vector<ConsoleDownloadMonitor>();
            transferListeners.add(new ConsoleDownloadMonitor());
            try {
                File downloaded = this.downloadManager.download(this.url, transferListeners, (MessageHolder)new DefaultMessageHolder());
                String ext = ArchiveFileExtensions.getArchiveFileExtension((String)this.url);
                String basename = downloaded.getName();
                basename = basename.substring(0, basename.length() - ext.length());
                File newName = new File(downloaded.getParentFile(), basename + "." + ext);
                downloaded.renameTo(newName);
                downloaded = newName;
                this.setSourceArchiveFile(this.getProject().getId(), downloaded);
            }
            catch (DownloadFailedException e) {
                this.getLog().debug((CharSequence)("Failed to download source from: " + this.url), (Throwable)e);
            }
        }
        if (this.getSourceArchiveFile(this.getProjectId()) == null) {
            this.getLog().info((CharSequence)"Attempting to retrieve source artifact from repository.");
            super.doExecute();
        }
    }

    protected CharSequence getSkipMessage() {
        return "Skipping remote source retrieval (per configuration).";
    }
}

