/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.remotesrc;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.BUnzip2;
import org.apache.tools.ant.taskdefs.ExecTask;
import org.apache.tools.ant.taskdefs.Expand;
import org.apache.tools.ant.taskdefs.GUnzip;
import org.codehaus.mojo.remotesrc.AbstractRemoteSourceMojo;
import org.codehaus.mojo.tools.antcall.AntCallLogger;
import org.codehaus.mojo.tools.antcall.AntCaller;
import org.codehaus.mojo.tools.antcall.AntExecutionException;
import org.codehaus.mojo.tools.antcall.MojoLogAdapter;

public class SourceUnpackMojo
extends AbstractRemoteSourceMojo {
    public static final String TGZ_TYPE = "tar.gz";
    public static final String TGZ_TYPE2 = "tgz";
    public static final String TBZ_TYPE = "tar.Z";
    public static final String TBZ_TYPE2 = "tar.bz2";
    public static final String[] UNPACK_TYPES = new String[]{"tar.gz", "tgz", "tar.Z", "tar.bz2", "tar"};
    private File sourceArchive;
    private boolean skipUnpack;
    private File expandTarget;
    private String messageLevel;
    private boolean overwrite;
    private File workDir;
    static /* synthetic */ Class class$org$apache$tools$ant$taskdefs$ExecTask;

    protected void doExecute() throws MojoExecutionException {
        if (!this.overwrite && this.workDir.exists()) {
            this.getLog().info((CharSequence)"Skipping unpack step because working directory already exists. Set '-Dsource.unpack.overwrite=true to override.");
            return;
        }
        AntCaller antCaller = new AntCaller((AntCallLogger)new MojoLogAdapter(this.getLog()));
        if (this.messageLevel != null) {
            antCaller.setMessageLevel(this.messageLevel);
        }
        try {
            if (!this.expandTarget.exists()) {
                this.expandTarget.mkdirs();
            }
            this.configureExpandTarget(antCaller);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to create temporary unpacked-source file", (Exception)e);
        }
        try {
            antCaller.executeTasks(this.getProject());
        }
        catch (AntExecutionException e) {
            Throwable cause = e.getCause();
            this.getLog().error((CharSequence)"Error unpacking sources", (Throwable)e);
            if (cause != null) {
                this.getLog().error((CharSequence)"Error unpacking sources", cause);
            }
            if (cause != null && cause.getStackTrace()[0].getClassName().equals((class$org$apache$tools$ant$taskdefs$ExecTask == null ? (class$org$apache$tools$ant$taskdefs$ExecTask = SourceUnpackMojo.class$("org.apache.tools.ant.taskdefs.ExecTask")) : class$org$apache$tools$ant$taskdefs$ExecTask).getName())) {
                this.getLog().debug((CharSequence)"Error unpacking sources", cause);
                throw new MojoExecutionException("Failed to unpack sources.");
            }
            throw new MojoExecutionException("Failed to unpack sources.", (Exception)((Object)e));
        }
    }

    private void configureExpandTarget(AntCaller antCaller) throws IOException, MojoExecutionException {
        File resolvedSourceArchive = this.getSourceArchiveFile(this.getProject().getId());
        if (resolvedSourceArchive != null) {
            this.sourceArchive = resolvedSourceArchive;
        }
        if (!this.sourceArchive.exists()) {
            throw new MojoExecutionException("Source archive cannot be unpacked; it does not exist! (archive location: " + this.sourceArchive + ")");
        }
        this.getLog().info((CharSequence)("Unpacking: " + this.sourceArchive.getCanonicalPath()));
        File unpacked = this.sourceArchive;
        String path = this.sourceArchive.getCanonicalPath();
        boolean isTar = false;
        for (int i = 0; i < UNPACK_TYPES.length; ++i) {
            if (!path.endsWith(UNPACK_TYPES[i])) continue;
            isTar = true;
            unpacked = File.createTempFile(this.sourceArchive.getName(), ".unpacked");
            unpacked.deleteOnExit();
            unpacked.setLastModified(this.sourceArchive.lastModified() - 10000L);
            if (TGZ_TYPE == UNPACK_TYPES[i] || TGZ_TYPE2 == UNPACK_TYPES[i]) {
                GUnzip gunzip = new GUnzip();
                gunzip.setTaskName("gunzip");
                gunzip.setSrc(this.sourceArchive);
                gunzip.setDest(unpacked);
                antCaller.addTask((Task)gunzip);
            } else if (TBZ_TYPE == UNPACK_TYPES[i] || TBZ_TYPE2 == UNPACK_TYPES[i]) {
                BUnzip2 bunzip = new BUnzip2();
                bunzip.setTaskName("bunzip");
                bunzip.setSrc(this.sourceArchive);
                bunzip.setDest(unpacked);
                antCaller.addTask((Task)bunzip);
            } else {
                unpacked = this.sourceArchive;
            }
            this.getLog().debug((CharSequence)("unpacked= " + unpacked));
            this.getLog().debug((CharSequence)("expandTarget= " + this.expandTarget));
            ExecTask exec = new ExecTask();
            exec.setTaskName("exec..untar-ing");
            exec.setExecutable("tar");
            exec.setDir(this.expandTarget);
            exec.setFailonerror(true);
            exec.setResolveExecutable(true);
            exec.createArg().setLine("xvf ");
            exec.createArg().setLine(unpacked.getPath());
            exec.createArg().setLine(" --force-local ");
            antCaller.addTask((Task)exec);
            break;
        }
        if (!isTar) {
            Expand expander = new Expand();
            expander.setTaskName("expand");
            expander.setSrc(unpacked);
            expander.setDest(this.expandTarget);
            expander.setOverwrite(true);
            antCaller.addTask((Task)expander);
        }
    }

    protected boolean isSkip() {
        return this.skipUnpack;
    }

    protected CharSequence getSkipMessage() {
        return "Skipping source-archive unpack step (per configuration).";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

