package org.codehaus.mojo.selenium;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/**
 * Display help information on 'org.codehaus.mojo:selenium-maven-plugin' plugin. Call 'mvn selenium:help -Ddetail=true' to display all details.
 *
 * @version generated on Tue Jun 30 11:46:46 EST 2009
 * @goal help
 */
public class HelpMojo
    extends AbstractMojo
{
    /** 80-character display buffer */
    private static final int DEFAULT_WIDTH = 80;

    /** 4 indent spaces */
    private static final String DEFAULT_INDENT = repeat( " ", 2 );

    /**
     * If true, display all settable properies for each goal.
     *
     * @parameter expression="${detail}" default-value="false"
     */
    private boolean detail;

    /** {@inheritDoc} */
    public void execute()
        throws MojoExecutionException
    {
        StringBuffer sb = new StringBuffer();

        sb.append( "The 'org.codehaus.mojo:selenium-maven-plugin' plugin has 6 goals:" ).append( "\n" );
        sb.append( "\n" );

        sb.append( "selenium:stop-server" ).append( "\n" );
        for ( Iterator it = toLines( "Stop the Selenium server." ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
        if ( detail )
        {
            sb.append( "\n" );

            sb.append( repeat( " ", 2 ) );
            sb.append( "Available parameters:" ).append( "\n" );

            sb.append( "\n" );

        for ( Iterator it = toLines( "port (Default: '4444')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "The port number of the server to connect to.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "skip (Default: 'false')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Skip goal execution", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        }

        sb.append( "\n" );

        sb.append( "selenium:help" ).append( "\n" );
        for ( Iterator it = toLines( "Display help information on 'org.codehaus.mojo:selenium-maven-plugin' plugin. Call 'mvn selenium:help -Ddetail=true' to display all details." ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
        if ( detail )
        {
            sb.append( "\n" );

            sb.append( repeat( " ", 2 ) );
            sb.append( "Available parameters:" ).append( "\n" );

            sb.append( "\n" );

        for ( Iterator it = toLines( "detail (Default: 'false')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "If true, display all settable properies for each goal.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        }

        sb.append( "\n" );

        sb.append( "selenium:selenese" ).append( "\n" );
        for ( Iterator it = toLines( "Run a suite of HTML Selenese tests." ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
        if ( detail )
        {
            sb.append( "\n" );

            sb.append( repeat( " ", 2 ) );
            sb.append( "Available parameters:" ).append( "\n" );

            sb.append( "\n" );

        for ( Iterator it = toLines( "browser", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "The browser name to run; must be one of the standard valid browser names (and must start with a *), e.g. *firefox, *iexplore, *custom.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "multiWindow (Default: 'false')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "True if the application under test should run in its own window, false if the AUT will run in an embedded iframe.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "port (Default: '4444')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "The port on which we'll run the Selenium Server.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "results", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "The file to which we'll write out our test results.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "skip (Default: 'false')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Allows the tests to be skipped.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "slowResources (Default: 'false')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "A debugging tool that slows down the Selenium Server. (Selenium developers only)", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "startURL", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "The base URL on which the tests will be run, e.g. http://www.google.com. Note that only the hostname part of this URL will really be used.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "suite", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "The suite file to run.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "timeoutInSeconds (Default: '1800')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Amount of time to wait before we just kill the browser.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        }

        sb.append( "\n" );

        sb.append( "selenium:xvfb" ).append( "\n" );
        for ( Iterator it = toLines( "Starts an Xvfb instance suitable for handling X11 displays for headless systems. Use this in combonation with the start-server goal to allow browsers to be launched on headless unix systems.Optionally uses 'xauth' to setup authentication for the Xvfb instance to allow running tests using the frame buffer server when another X server is already running." ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
        if ( detail )
        {
            sb.append( "\n" );

            sb.append( repeat( " ", 2 ) );
            sb.append( "Available parameters:" ).append( "\n" );

            sb.append( "\n" );

        for ( Iterator it = toLines( "authenticationFile", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "The file where X authentication data is stored for the Xvfb session. Default is to generate a temporary file.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "background (Default: 'true')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Flag to control if we background the process or block Maven execution.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "display", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "The X11 display to use. Default value is :20.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "displayPropertiesFile (Default: '${project.build.directory}/selenium/display.properties')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "The location of the file to write the display properties which will be picked up by the start-server goal.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "logFile (Default: '${project.build.directory}/selenium/xvfb.log')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "The file that Xvfb output will be written to.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "logOutput (Default: 'true')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Enable logging mode.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "options", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "A list of additional options to pass to the Xvfb process.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "skip (Default: 'false')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Skip goal execution", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "xauthEnabled (Default: 'true')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Use 'xauth' to setup permissions for the Xvfb server. This requires 'xauth' be installed and may be required when an X server is already running.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "xauthExecutable (Default: 'xauth')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "The 'xauth' command to execute.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "xauthProtocol (Default: '.')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "The 'xauth' protocol.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "xvfbExecutable (Default: 'Xvfb')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "The 'Xvfb' command to execute.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        }

        sb.append( "\n" );

        sb.append( "selenium:start-server" ).append( "\n" );
        for ( Iterator it = toLines( "Start the Selenium server." ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
        if ( detail )
        {
            sb.append( "\n" );

            sb.append( repeat( " ", 2 ) );
            sb.append( "Available parameters:" ).append( "\n" );

            sb.append( "\n" );

        for ( Iterator it = toLines( "avoidProxy (Default: 'false')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "By default, we proxy every browser request; set this flag to make the browser use our proxy only for URLs containing '/selenium-server'", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "background (Default: 'false')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Flag to control if we background the server or block Maven execution.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "browserSessionReuse (Default: 'false')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Stops re-initialization and spawning of the browser between tests.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "browserSideLog", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Enables logging on the browser side; logging messages will be transmitted to the server. This can affect performance.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "debug (Default: 'false')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Enable the server's debug mode..", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "defaultUserExtensions (Default: 'org/codehaus/mojo/selenium/default-user-extensions.js')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "The file or resource to use for default user-extensions.js.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "defaultUserExtensionsEnabled (Default: 'true')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Enable or disable default user-extensions.js", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "displayPropertiesFile (Default: '${project.build.directory}/selenium/display.properties')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "The location of the file to read the display properties.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "ensureCleanSession (Default: 'false')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "If the browser does not have user profiles, make sure every new session has no artifacts from previous sessions. For example, enabling this option will cause all user cookies to be archived before launching IE, and restored after IE is closed.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "firefoxProfileTemplate", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Normally a fresh empty Firefox profile is created every time we launch. You can specify a directory to make us copy your profile directory instead.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "forcedBrowserMode", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Sets the browser mode (e.g. '*iexplore' for all sessions).", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "logFile (Default: '${project.build.directory}/selenium/server.log')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "The file that Selenium server logs will be written to.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "logOutput (Default: 'false')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Enable logging mode.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "nonProxyHosts", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Configure the Selenium Server to use http.nonProxyHosts.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "port (Default: '4444')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "The port number of the server to connect to.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "proxyHost", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Configure the Selenium Server to use http.proxyHost.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "proxyPort", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Configure the Selenium Server to use http.proxyPort.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "singleWindow (Default: 'false')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Puts you into a mode where the test web site executes in a frame. This mode should only be selected if the application under test does not use frames.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "skip (Default: 'false')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Allows the server startup to be skipped.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "timeout (Default: '-1')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Timeout for the server in seconds.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "trustAllSSLCertificates (Default: 'false')", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Forces the Selenium proxy to trust all SSL certificates. This doesn't work in browsers that don't use the Selenium proxy.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "trustStore", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "The location of the SSL trust-store.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "trustStorePassword", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "The password for the SSL trust-store.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "userExtensions", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Location of the user-extensions.js to load into the server. If defaultUserExtensionsEnabled is true, then this file will be appended to the defaults.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "verifyBrowser", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Attempt to verify the named browser configuration. Must be one of the standard valid browser names (and must start with a *), e.g. *firefox, *iexplore, *custom.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        for ( Iterator it = toLines( "workingDirectory", repeat( " ", 4 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }
            for ( Iterator it = toLines( "Working directory where Selenium server will be started from.", repeat( " ", 6 ), DEFAULT_WIDTH ).iterator(); it.hasNext(); )
            {
                sb.append( it.next().toString() ).append( "\n" );
            }
        }

        sb.append( "\n" );

        sb.append( "selenium:help" ).append( "\n" );
        for ( Iterator it = toLines( "Display help information on 'org.codehaus.mojo:selenium-maven-plugin' plugin. Call 'mvn selenium:help -Ddetail=true' to display all details." ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( "\n" );
        }

        if ( getLog().isInfoEnabled() )
        {
            getLog().info( sb.toString() );
        }
    }

    /**
     * <p>Repeat a String <code>n</code> times to form a new string.</p>
     *
     * @param str String to repeat
     * @param repeat number of times to repeat str
     * @return String with repeated String
     * @throws NegativeArraySizeException if <code>repeat < 0</code>
     * @throws NullPointerException if str is <code>null</code>
     */
    private static String repeat( String str, int repeat )
    {
        StringBuffer buffer = new StringBuffer( repeat * str.length() );

        for ( int i = 0; i < repeat; i++ )
        {
            buffer.append( str );
        }

        return buffer.toString();
    }

    /**
     * <p>Give a list of lines for the <code>str</code>. Each line is indented by 4 spaces
     * and has a maximum of <code>80</code> characters.</p>
     *
     * @param str String to split in lines
     * @return List of lines
     * @throws NullPointerException if str is <code>null</code>
     */
    private static List toLines( String str )
    {
        return toLines( str, DEFAULT_INDENT, DEFAULT_WIDTH );
    }

    /**
     * <p>Give a list of lines for the <code>str</code>. Each line is indented by <code>indent</code>
     * and has a maximum of <code>size</code> characters.</p>
     *
     * @param str String to split in lines
     * @param indent the string to precede each line
     * @param size the size of the character display buffer
     * @return List of lines
     * @throws IllegalArgumentException if <code>size < 0</code>
     * @throws NullPointerException if str is <code>null</code>
     */
    private static List toLines( String str, String indent, int size )
    {
        List sentences = new ArrayList();

        if ( indent == null )
        {
            indent = "";
        }

        if ( size < 0 )
        {
            throw new IllegalArgumentException( "size should be positive" );
        }

        StringBuffer tmp = new StringBuffer( indent );
        StringTokenizer tokenizer = new StringTokenizer( str, " " );
        while ( tokenizer.hasMoreTokens() )
        {
            String word = tokenizer.nextToken();

            if ( tmp.length() + word.length() + 1 < size )
            {
                tmp.append( word ).append( " " );
            }
            else
            {
                sentences.add( tmp.toString() );
                tmp = new StringBuffer( indent );
                tmp.append( word ).append( " " );
            }
        }

        if ( tmp.toString().length() > 0 )
        {
            sentences.add( tmp.toString() );
        }

        return sentences;
    }
}
