/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.sql;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.codehaus.mojo.sql.DelimiterType;
import org.codehaus.mojo.sql.Fileset;

public class SqlExecMojo
extends AbstractMojo {
    public static final String ON_ERROR_ABORT = "abort";
    public static final String ON_ERROR_CONTINUE = "continue";
    private String username;
    private String password;
    private Settings settings;
    private String settingsKey;
    private String sqlCommand = "";
    private File[] srcFiles;
    private Fileset fileset;
    private boolean skip;
    private String url;
    private String driver;
    private boolean autocommit;
    private String onError = "abort";
    private String delimiter = ";";
    private String delimiterType = "normal";
    private boolean print = false;
    private boolean showheaders = true;
    private File output = null;
    private String encoding = null;
    private boolean append = false;
    private boolean keepformat = false;
    private boolean escapeProcessing = true;
    private int successfulStatements = 0;
    private int totalStatements = 0;
    private Connection conn = null;
    private Statement statement = null;
    private Vector transactions = new Vector();

    public Transaction createTransaction() {
        Transaction t = new Transaction();
        this.transactions.addElement(t);
        return t;
    }

    public void addText(String sql) {
        this.sqlCommand = this.sqlCommand + sql;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public void setDelimiterType(DelimiterType delimiterType) {
        this.delimiterType = delimiterType.getValue();
    }

    public void setPrint(boolean print) {
        this.print = print;
    }

    public void setShowheaders(boolean showheaders) {
        this.showheaders = showheaders;
    }

    public void setOutput(File output) {
        this.output = output;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public void setKeepformat(boolean keepformat) {
        this.keepformat = keepformat;
    }

    public void setEscapeProcessing(boolean enable) {
        this.escapeProcessing = enable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skip sql execution");
            return;
        }
        this.successfulStatements = 0;
        this.totalStatements = 0;
        this.loadUserInfoFromSettings();
        this.addCommandToTransactions();
        this.addFilesToTransactions();
        this.addFileSetToTransactions();
        this.conn = this.getConnection();
        try {
            this.statement = this.conn.createStatement();
            this.statement.setEscapeProcessing(this.escapeProcessing);
            PrintStream out = System.out;
            try {
                if (this.output != null) {
                    this.getLog().debug((CharSequence)("Opening PrintStream to output file " + this.output));
                    out = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.output.getAbsolutePath(), this.append)));
                }
                Enumeration e = this.transactions.elements();
                while (e.hasMoreElements()) {
                    Transaction t = (Transaction)e.nextElement();
                    t.runTransaction(out);
                    if (this.autocommit) continue;
                    this.getLog().debug((CharSequence)"Committing transaction");
                    this.conn.commit();
                }
            }
            finally {
                if (out != null && out != System.out) {
                    out.close();
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        catch (SQLException e) {
            if (!this.autocommit && this.conn != null && ON_ERROR_ABORT.equalsIgnoreCase(this.getOnError())) {
                try {
                    this.conn.rollback();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
                if (this.conn != null) {
                    this.conn.close();
                }
            }
            catch (SQLException ex) {}
        }
        this.getLog().info((CharSequence)(this.getSuccessfulStatements() + " of " + this.getTotalStatements() + " SQL statements executed successfully"));
    }

    private void addCommandToTransactions() {
        this.createTransaction().addText(this.sqlCommand.trim());
    }

    private void addFileSetToTransactions() {
        String[] includedFiles;
        if (this.fileset != null) {
            this.fileset.scan();
            includedFiles = this.fileset.getIncludedFiles();
        } else {
            includedFiles = new String[]{};
        }
        for (int j = 0; j < includedFiles.length; ++j) {
            this.createTransaction().setSrc(new File(this.fileset.getBasedir(), includedFiles[j]));
        }
    }

    private void addFilesToTransactions() throws MojoExecutionException {
        File[] files = this.getSrcFiles();
        for (int i = 0; files != null && i < files.length; ++i) {
            if (files[i] != null && !files[i].exists()) {
                throw new MojoExecutionException(files[i].getPath() + " not found.");
            }
            this.createTransaction().setSrc(files[i]);
        }
    }

    private void loadUserInfoFromSettings() throws MojoExecutionException {
        Server server;
        if (this.settingsKey == null) {
            this.settingsKey = this.getUrl();
        }
        if ((this.getUsername() == null || this.getPassword() == null) && this.settings != null && (server = this.settings.getServer(this.settingsKey)) != null) {
            if (this.getUsername() == null) {
                this.setUsername(server.getUsername());
            }
            if (this.getPassword() == null) {
                this.setPassword(server.getPassword());
            }
        }
        if (this.getUsername() == null) {
            this.setUsername("");
        }
        if (this.getPassword() == null) {
            this.setPassword("");
        }
    }

    private Connection getConnection() throws MojoExecutionException {
        try {
            this.getLog().debug((CharSequence)("connecting to " + this.getUrl()));
            Properties info = new Properties();
            info.put("user", this.getUsername());
            info.put("password", this.getPassword());
            Driver driverInstance = null;
            try {
                Class<?> dc = Class.forName(this.getDriver());
                driverInstance = (Driver)dc.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new MojoExecutionException("Driver class not found: " + this.getDriver(), (Exception)e);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Failure loading driver: " + this.getDriver(), e);
            }
            Connection conn = driverInstance.connect(this.getUrl(), info);
            if (conn == null) {
                throw new SQLException("No suitable Driver for " + this.getUrl());
            }
            conn.setAutoCommit(this.autocommit);
            return conn;
        }
        catch (SQLException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private void runStatements(Reader reader, PrintStream out) throws SQLException, IOException {
        String line;
        StringBuffer sql = new StringBuffer();
        BufferedReader in = new BufferedReader(reader);
        while ((line = in.readLine()) != null) {
            String token;
            StringTokenizer st;
            if (!this.keepformat) {
                line = line.trim();
            }
            if (!this.keepformat && (line.startsWith("//") || line.startsWith("--") || (st = new StringTokenizer(line)).hasMoreTokens() && "REM".equalsIgnoreCase(token = st.nextToken()))) continue;
            if (!this.keepformat) {
                sql.append(" ").append(line);
            } else {
                sql.append("\n").append(line);
            }
            if (!this.keepformat && line.indexOf("--") >= 0) {
                sql.append("\n");
            }
            if ((!this.delimiterType.equals("normal") || !sql.toString().endsWith(this.delimiter)) && (!this.delimiterType.equals("row") || !line.equals(this.delimiter))) continue;
            this.execSQL(sql.substring(0, sql.length() - this.delimiter.length()), out);
            sql.replace(0, sql.length(), "");
        }
        if (!sql.equals("")) {
            this.execSQL(sql.toString(), out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execSQL(String sql, PrintStream out) throws SQLException {
        if ("".equals(sql.trim())) {
            return;
        }
        ResultSet resultSet = null;
        try {
            ++this.totalStatements;
            this.getLog().debug((CharSequence)("SQL: " + sql));
            int updateCountTotal = 0;
            boolean ret = this.statement.execute(sql);
            int updateCount = this.statement.getUpdateCount();
            resultSet = this.statement.getResultSet();
            do {
                if (!ret) {
                    if (updateCount != -1) {
                        updateCountTotal += updateCount;
                    }
                } else if (this.print) {
                    this.printResults(resultSet, out);
                }
                if (!(ret = this.statement.getMoreResults())) continue;
                updateCount = this.statement.getUpdateCount();
                resultSet = this.statement.getResultSet();
            } while (ret);
            this.getLog().debug((CharSequence)(updateCountTotal + " rows affected"));
            if (this.print) {
                StringBuffer line = new StringBuffer();
                line.append(updateCountTotal).append(" rows affected");
                out.println(line);
            }
            for (SQLWarning warning = this.conn.getWarnings(); warning != null; warning = warning.getNextWarning()) {
                this.getLog().debug((CharSequence)(warning + " sql warning"));
            }
            this.conn.clearWarnings();
            ++this.successfulStatements;
        }
        catch (SQLException e) {
            this.getLog().error((CharSequence)("Failed to execute: " + sql));
            if (!ON_ERROR_CONTINUE.equalsIgnoreCase(this.getOnError())) {
                throw e;
            }
            this.getLog().error((CharSequence)e.toString());
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
        }
    }

    private void printResults(ResultSet rs, PrintStream out) throws SQLException {
        if (rs != null) {
            this.getLog().debug((CharSequence)"Processing new result set.");
            ResultSetMetaData md = rs.getMetaData();
            int columnCount = md.getColumnCount();
            StringBuffer line = new StringBuffer();
            if (this.showheaders) {
                for (int col = 1; col < columnCount; ++col) {
                    line.append(md.getColumnName(col));
                    line.append(",");
                }
                line.append(md.getColumnName(columnCount));
                out.println(line);
                line = new StringBuffer();
            }
            while (rs.next()) {
                boolean first = true;
                for (int col = 1; col <= columnCount; ++col) {
                    String columnValue = rs.getString(col);
                    if (columnValue != null) {
                        columnValue = columnValue.trim();
                    }
                    if (first) {
                        first = false;
                    } else {
                        line.append(",");
                    }
                    line.append(columnValue);
                }
                out.println(line);
                line = new StringBuffer();
            }
        }
        out.println();
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    void setAutocommit(boolean autocommit) {
        this.autocommit = autocommit;
    }

    void setFileset(Fileset fileset) {
        this.fileset = fileset;
    }

    public File[] getSrcFiles() {
        return this.srcFiles;
    }

    public void setSrcFiles(File[] files) {
        this.srcFiles = files;
    }

    int getGoodSqls() {
        return this.getSuccessfulStatements();
    }

    public int getSuccessfulStatements() {
        return this.successfulStatements;
    }

    public int getTotalStatements() {
        return this.totalStatements;
    }

    public String getOnError() {
        return this.onError;
    }

    public void setOnError(String action) {
        if (ON_ERROR_ABORT.equalsIgnoreCase(action)) {
            this.onError = ON_ERROR_ABORT;
        } else if (ON_ERROR_CONTINUE.equalsIgnoreCase(action)) {
            this.onError = ON_ERROR_CONTINUE;
        } else {
            throw new IllegalArgumentException(action + " is not a valid value for onError, only '" + ON_ERROR_ABORT + "' or '" + ON_ERROR_CONTINUE + "'.");
        }
    }

    void setSettings(Settings settings) {
        this.settings = settings;
    }

    void setSettingsKey(String key) {
        this.settingsKey = key;
    }

    void setSkip(boolean skip) {
        this.skip = skip;
    }

    private class Transaction {
        private File tSrcFile = null;
        private String tSqlCommand = "";

        private Transaction() {
        }

        public void setSrc(File src) {
            this.tSrcFile = src;
        }

        public void addText(String sql) {
            this.tSqlCommand = this.tSqlCommand + sql;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runTransaction(PrintStream out) throws IOException, SQLException {
            if (this.tSqlCommand.length() != 0) {
                SqlExecMojo.this.getLog().info((CharSequence)"Executing commands");
                SqlExecMojo.this.runStatements(new StringReader(this.tSqlCommand), out);
            }
            if (this.tSrcFile != null) {
                SqlExecMojo.this.getLog().info((CharSequence)("Executing file: " + this.tSrcFile.getAbsolutePath()));
                InputStreamReader reader = SqlExecMojo.this.encoding == null ? new FileReader(this.tSrcFile) : new InputStreamReader((InputStream)new FileInputStream(this.tSrcFile), SqlExecMojo.this.encoding);
                try {
                    SqlExecMojo.this.runStatements(reader, out);
                }
                finally {
                    ((Reader)reader).close();
                }
            }
        }
    }
}

