/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.sqlj;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

public class SqljMojo
extends AbstractMojo {
    private File generatedSourcesDirectory;
    private String encoding;
    private boolean status;
    private File[] sqljFiles;
    private File[] sqljDirs;
    private MavenProject mavenProject;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Class<?> sqljClass;
        if (StringUtils.isEmpty((String)this.encoding)) {
            this.encoding = SystemUtils.FILE_ENCODING;
            this.getLog().warn((CharSequence)("No encoding given, falling back to system default value: " + this.encoding));
        }
        String[] arguments = new String[]{"-dir=" + this.generatedSourcesDirectory.getAbsolutePath(), "-encoding=" + this.encoding, this.status ? "-status" : "", "-compile=false", StringUtils.join(this.getSqljFiles().iterator(), (String)" ")};
        try {
            sqljClass = Class.forName("sqlj.tools.Sqlj");
        }
        catch (ClassNotFoundException e) {
            throw new MojoFailureException("Please add sqlj to the plugins classpath " + e.getMessage());
        }
        catch (Exception e) {
            throw new MojoFailureException(e.getMessage());
        }
        try {
            FileUtils.forceMkdir((File)this.generatedSourcesDirectory.getAbsoluteFile());
        }
        catch (IOException e) {
            throw new MojoFailureException(e.getMessage());
        }
        Integer returnCode = null;
        try {
            returnCode = (Integer)MethodUtils.invokeExactStaticMethod(sqljClass, (String)"statusMain", (Object[])new Object[]{arguments});
        }
        catch (Exception e) {
            throw new MojoFailureException(e.getMessage());
        }
        if (returnCode != 0) {
            throw new MojoExecutionException("Bad returncode: " + returnCode);
        }
        this.mavenProject.addCompileSourceRoot(this.generatedSourcesDirectory.getAbsolutePath());
    }

    private Set getSqljFiles() {
        HashSet<File> files = new HashSet<File>();
        String[] extensions = new String[]{"sqlj"};
        for (int i = 0; i < this.sqljDirs.length; ++i) {
            files.addAll(FileUtils.listFiles((File)this.sqljDirs[i], (String[])extensions, (boolean)true));
        }
        files.addAll(Arrays.asList(this.sqljFiles));
        return files;
    }
}

