/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.sqlj;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.sqlj.AbstractSqljMojo;
import org.codehaus.plexus.util.Scanner;
import org.sonatype.plexus.build.incremental.BuildContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="sqlj", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.COMPILE)
public class SqljMojo
extends AbstractSqljMojo {
    private static final String SQLJ_CLASS = "sqlj.tools.Sqlj";
    @Parameter(property="sqlj.encoding", defaultValue="${project.build.sourceEncoding}")
    private String encoding;
    @Parameter(property="sqlj.verbose", defaultValue="false")
    private boolean verbose;
    @Parameter(property="sqlj.sqljFiles")
    private File[] sqljFiles;
    @Parameter(property="sqlj.sqljDirectories")
    private File[] sqljDirs;
    @Component
    private MavenProject mavenProject;
    @Component
    private BuildContext buildContext;

    public void execute() throws MojoExecutionException, MojoFailureException {
        boolean translationPerformed;
        String sqljVersionInfo = this.getSqljVersionInfo();
        if (sqljVersionInfo != null) {
            this.getLog().info((CharSequence)("Using SQLJ Translator version '" + sqljVersionInfo + "'"));
        } else {
            this.getLog().info((CharSequence)"Couldn't retrieve SQLJ Translator version info");
        }
        if (!this.checkSqljDirAndFileDeclarations()) {
            String msg = "Plugin configuration contains invalid SQLJ directory or file declaration(s).";
            throw new MojoExecutionException(msg);
        }
        if (StringUtils.isEmpty((String)this.encoding)) {
            this.encoding = SystemUtils.FILE_ENCODING;
            this.getLog().warn((CharSequence)("No encoding given, falling back to system default value: " + this.encoding));
        }
        try {
            FileUtils.forceMkdir((File)this.getGeneratedResourcesDirectory().getAbsoluteFile());
            FileUtils.forceMkdir((File)this.getGeneratedSourcesDirectory().getAbsoluteFile());
        }
        catch (IOException e) {
            throw new MojoFailureException(e.getMessage());
        }
        Set<File> staleSqljFiles = this.getStaleSqljFiles();
        if (!staleSqljFiles.isEmpty()) {
            for (File file : staleSqljFiles) {
                this.buildContext.removeMessages(file);
                try {
                    this.translate(file);
                }
                catch (MojoExecutionException e) {
                    String msg = "Error translating SQLJ file";
                    this.buildContext.addMessage(file, 0, 0, "Error translating SQLJ file", 2, (Throwable)e);
                    throw e;
                }
            }
            translationPerformed = true;
            int numberOfFiles = staleSqljFiles.size();
            this.getLog().info((CharSequence)("Translated " + numberOfFiles + " SQLJ file" + (numberOfFiles > 0 ? "s." : ".")));
        } else {
            this.getLog().info((CharSequence)"No updated SQLJ files found - skipping SQLJ translation.");
            translationPerformed = false;
        }
        Resource resource = new Resource();
        resource.setDirectory(this.getGeneratedResourcesDirectory().getAbsolutePath());
        this.mavenProject.addResource(resource);
        if (translationPerformed) {
            this.buildContext.refresh(this.getGeneratedResourcesDirectory());
        }
        this.mavenProject.addCompileSourceRoot(this.getGeneratedSourcesDirectory().getAbsolutePath());
        if (translationPerformed) {
            this.buildContext.refresh(this.getGeneratedSourcesDirectory());
        }
    }

    private boolean checkSqljDirAndFileDeclarations() {
        boolean isOk = true;
        for (File sqljDir : this.sqljDirs) {
            if (!sqljDir.exists()) {
                this.getLog().error((CharSequence)("Declared SQLJ directory does not exist: " + sqljDir));
                isOk = false;
            }
            if (sqljDir.isDirectory()) continue;
            this.getLog().error((CharSequence)("Declared SQLJ directory is not a directory: " + sqljDir));
            isOk = false;
        }
        for (File sqljFile : this.sqljFiles) {
            if (!sqljFile.exists()) {
                this.getLog().error((CharSequence)("Declared SQLJ file does not exist: " + sqljFile));
                isOk = false;
            }
            if (sqljFile.isFile()) continue;
            this.getLog().error((CharSequence)("Declared SQLJ file is not a file: " + sqljFile));
            isOk = false;
        }
        return isOk;
    }

    private void translate(File file) throws MojoFailureException, MojoExecutionException {
        Class<?> sqljClass;
        try {
            sqljClass = Class.forName(SQLJ_CLASS);
        }
        catch (ClassNotFoundException e) {
            throw new MojoFailureException("Please add SQLJ Translator to the plugin's classpath: " + e.getMessage());
        }
        catch (Exception e) {
            throw new MojoFailureException(e.getMessage());
        }
        ArrayList<String> sqljArgs = new ArrayList<String>();
        sqljArgs.add("-dir=" + this.getGeneratedSourcesDirectory().getAbsolutePath());
        sqljArgs.add("-d=" + this.getGeneratedResourcesDirectory().getAbsolutePath());
        sqljArgs.add("-encoding=" + this.encoding);
        if (this.verbose || this.getLog().isDebugEnabled()) {
            sqljArgs.add("-status");
        }
        sqljArgs.add("-compile=false");
        sqljArgs.add(file.getAbsolutePath());
        Integer returnCode = null;
        try {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Performing SQLJ translation on " + file));
            }
            Object[] methodArgs = new Object[]{sqljArgs.toArray(new String[0])};
            returnCode = (Integer)MethodUtils.invokeExactStaticMethod(sqljClass, (String)"statusMain", (Object[])methodArgs);
        }
        catch (Exception e) {
            throw new MojoFailureException(e.getMessage());
        }
        if (returnCode != 0) {
            throw new MojoExecutionException("Can't translate file (return code: " + returnCode + ")");
        }
    }

    private Set<File> getStaleSqljFiles() throws MojoExecutionException {
        Object[] modifiedFiles;
        Scanner modifiedScanner;
        HashSet<File> staleFiles = new HashSet<File>();
        String[] sqljIncludes = new String[]{"**/*.sqlj"};
        for (File sqljDir : this.sqljDirs) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Checking for updated SQLJ files in directory: " + sqljDir));
            }
            modifiedScanner = this.buildContext.newScanner(sqljDir);
            modifiedScanner.setIncludes(sqljIncludes);
            modifiedScanner.setExcludes(null);
            modifiedScanner.scan();
            for (String string : modifiedFiles = modifiedScanner.getIncludedFiles()) {
                File file = new File(sqljDir, string);
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("Updated SQLJ file found: " + file));
                }
                if (staleFiles.add(file)) continue;
                this.getLog().warn((CharSequence)("Duplicated declaration of SQLJ source detected in plugin configuration: " + file));
            }
        }
        for (File sqljFile : this.sqljFiles) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Checking if SQLJ file has been updated: " + sqljFile));
            }
            modifiedScanner = this.buildContext.newScanner(sqljFile.getParentFile());
            modifiedScanner.setIncludes(new String[]{sqljFile.getName()});
            modifiedScanner.setExcludes(null);
            modifiedScanner.scan();
            modifiedFiles = modifiedScanner.getIncludedFiles();
            if (modifiedFiles.length == 1) {
                String path = modifiedFiles[0];
                File file = new File(sqljFile.getParentFile(), path);
                if (file.compareTo(sqljFile) == 0) {
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug((CharSequence)("Updated SQLJ file found: " + sqljFile));
                    }
                    if (staleFiles.add(file)) continue;
                    this.getLog().warn((CharSequence)("Duplicated declaration of SQLJ source detected in plugin configuration: " + file));
                    continue;
                }
                this.getLog().error((CharSequence)"Unexpected SQLJ file returned; aborting...");
                throw new MojoExecutionException("Unexpected SQLJ file returned when examining " + sqljFile + ": " + file);
            }
            if (modifiedFiles.length <= 1) continue;
            this.getLog().error((CharSequence)"Unexpected list of SQLJ files returned; aborting...");
            throw new MojoExecutionException("Unexpected list of SQLJ files returned when examining " + sqljFile + ": " + Arrays.toString(modifiedFiles));
        }
        return staleFiles;
    }

    private String getSqljVersionInfo() {
        String version;
        try {
            Class<?> sqljClass = Class.forName(SQLJ_CLASS);
            version = (String)MethodUtils.invokeExactStaticMethod(sqljClass, (String)"getVersion", null);
        }
        catch (Exception e) {
            version = null;
        }
        return version;
    }
}

