/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.unix.maven;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.unix.FileAttributes;
import org.codehaus.mojo.unix.core.AssemblyOperation;
import org.codehaus.mojo.unix.core.CopyDirectoryOperation;
import org.codehaus.mojo.unix.maven.AssemblyOp;
import org.codehaus.mojo.unix.maven.MojoFileAttributes;
import org.codehaus.mojo.unix.util.RelativePath;

public abstract class AbstractFileSetOp
extends AssemblyOp {
    private RelativePath to = RelativePath.BASE;
    private List<String> includes = Collections.emptyList();
    private List<String> excludes = Collections.emptyList();
    private String pattern;
    private String replacement;
    private MojoFileAttributes fileAttributes = new MojoFileAttributes();
    private MojoFileAttributes directoryAttributes = new MojoFileAttributes();

    public AbstractFileSetOp(String operationType) {
        super(operationType);
    }

    public void setTo(String to) {
        this.to = RelativePath.relativePath((String)to);
    }

    public void setIncludes(String[] includes) {
        this.includes = Arrays.asList(includes);
    }

    public void setExcludes(String[] excludes) {
        this.excludes = Arrays.asList(excludes);
    }

    public void setPattern(String pattern) {
        this.pattern = AbstractFileSetOp.nullifEmpty(pattern);
    }

    public void setReplacement(String replacement) {
        this.replacement = AbstractFileSetOp.nullifEmpty(replacement);
    }

    public void setFileAttributes(MojoFileAttributes fileAttributes) {
        this.fileAttributes = fileAttributes;
    }

    public void setDirectoryAttributes(MojoFileAttributes directoryAttributes) {
        this.directoryAttributes = directoryAttributes;
    }

    protected AssemblyOperation createOperationInternal(FileObject archive, FileAttributes defaultFileAttributes, FileAttributes defaultDirectoryAttributes) throws MojoFailureException, FileSystemException {
        if (this.pattern != null && this.replacement == null) {
            throw new MojoFailureException("A replacement expression has to be set if a pattern is given.");
        }
        return new CopyDirectoryOperation(archive, this.to, this.includes, this.excludes, this.pattern, this.replacement, defaultFileAttributes.useAsDefaultsFor(this.fileAttributes.create()), defaultDirectoryAttributes.useAsDefaultsFor(this.directoryAttributes.create()));
    }
}

