/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.unix.maven;

import fj.data.Option;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.License;
import org.apache.maven.project.MavenProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenProjectWrapper {
    public final String groupId;
    public final String artifactId;
    public final String version;
    public final Artifact artifact;
    public final Option<String> name;
    public final Option<String> description;
    public final File basedir;
    public final File buildDirectory;
    public final Set<Artifact> artifacts;
    public final List<License> licenses;
    public final Map<String, Artifact> artifactConflictIdMap;

    public MavenProjectWrapper(String groupId, String artifactId, String version, Artifact artifact, String name, String description, File basedir, File buildDirectory, Set<Artifact> artifacts, List<License> licenses, Map<String, Artifact> artifactConflictIdMap) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.artifact = artifact;
        this.name = Option.fromNull((Object)name);
        this.description = Option.fromNull((Object)description);
        this.basedir = basedir;
        this.buildDirectory = buildDirectory;
        this.artifacts = artifacts;
        this.licenses = licenses;
        this.artifactConflictIdMap = artifactConflictIdMap;
    }

    public Set<Artifact> getArtifacts() {
        return this.artifacts;
    }

    public static MavenProjectWrapper mavenProjectWrapper(MavenProject project) {
        HashMap<String, Artifact> artifactConflictIdMap = new HashMap<String, Artifact>();
        for (Artifact artifact : project.getArtifacts()) {
            artifactConflictIdMap.put(artifact.getDependencyConflictId(), artifact);
        }
        return new MavenProjectWrapper(project.getGroupId(), project.getArtifactId(), project.getVersion(), project.getArtifact(), project.getName(), project.getDescription(), project.getBasedir(), new File(project.getBuild().getDirectory()), project.getArtifacts(), project.getLicenses(), artifactConflictIdMap);
    }
}

