/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.unix.maven;

import fj.F;
import fj.F2;
import fj.Function;
import fj.P;
import fj.P3;
import fj.data.List;
import fj.data.Option;
import fj.data.Set;
import fj.pre.Ord;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.VFS;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.transform.SnapshotTransformation;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.mojo.unix.FileAttributes;
import org.codehaus.mojo.unix.FileCollector;
import org.codehaus.mojo.unix.MissingSettingException;
import org.codehaus.mojo.unix.PackageParameters;
import org.codehaus.mojo.unix.PackageVersion;
import org.codehaus.mojo.unix.UnixPackage;
import org.codehaus.mojo.unix.core.AssemblyOperation;
import org.codehaus.mojo.unix.java.StringF;
import org.codehaus.mojo.unix.maven.AssemblyOp;
import org.codehaus.mojo.unix.maven.Defaults;
import org.codehaus.mojo.unix.maven.MavenProjectWrapper;
import org.codehaus.mojo.unix.maven.Package;
import org.codehaus.mojo.unix.maven.PackagingFormat;
import org.codehaus.mojo.unix.maven.PackagingMojoParameters;
import org.codehaus.mojo.unix.maven.UnknownArtifactException;
import org.codehaus.mojo.unix.util.ScriptUtil;
import org.codehaus.mojo.unix.util.line.AbstractLineStreamWriter;
import org.codehaus.mojo.unix.util.line.LineStreamWriter;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MojoHelper {
    public static final String ATTACHED_NO_ARTIFACTS_CONFIGURED = "When running in attached mode at least one package has to be configured.";
    public static final String DUPLICATE_CLASSIFIER = "Duplicate package classifier: '%s'.";
    public static final String DUPLICATE_UNCLASSIFIED = "There can only be one package without an classifier.";
    static F<String, String> dashString = new F<String, String>(){

        public String f(String s) {
            return "-" + s;
        }
    };

    public static Execution create(Map formats, String formatType, SnapshotTransformation snapshotTransformation, MavenProjectWrapper project, boolean debug, boolean attachedMode, F<UnixPackage, UnixPackage> validateMojoSettingsAndApplyFormatSpecificSettingsToPackage, PackagingMojoParameters mojoParameters, final Log log) throws MojoFailureException, MojoExecutionException {
        FileObject buildDirectory;
        PackagingFormat format = (PackagingFormat)formats.get(formatType);
        if (format == null) {
            throw new MojoFailureException("INTERNAL ERROR: could not find format for type '" + formatType + "'.");
        }
        String timestamp = snapshotTransformation.getDeploymentTimestamp();
        try {
            FileSystemManager fileSystemManager = VFS.getManager();
            buildDirectory = fileSystemManager.resolveFile(project.buildDirectory.getAbsolutePath());
        }
        catch (FileSystemException e) {
            throw new MojoExecutionException("Error while initializing Commons VFS", (Exception)((Object)e));
        }
        PackageVersion version = PackageVersion.packageVersion((String)project.version, (String)timestamp, (boolean)project.artifact.isSnapshot(), mojoParameters.revision);
        List packages = List.nil();
        for (Package pakke : MojoHelper.validatePackages(mojoParameters.packages, attachedMode)) {
            try {
                String name = "unix/root-" + formatType + (String)pakke.classifier.map(dashString).orSome((Object)"");
                FileObject packageRoot = buildDirectory.resolveFile(name);
                packageRoot.createFolder();
                PackageParameters parameters = MojoHelper.calculatePackageParameters(project, version, mojoParameters, pakke);
                UnixPackage unixPackage = format.start().parameters(parameters).setVersion(version).workingDirectory(packageRoot).debug(debug).basedir(project.basedir);
                unixPackage = (UnixPackage)validateMojoSettingsAndApplyFormatSpecificSettingsToPackage.f((Object)unixPackage);
                List<AssemblyOperation> assemblyOperations = MojoHelper.createAssemblyOperations(project, mojoParameters, pakke, unixPackage, buildDirectory);
                if (debug) {
                    log.info((CharSequence)("Showing assembly operations for package: " + parameters.id));
                    for (AssemblyOperation operation : assemblyOperations) {
                        operation.streamTo((LineStreamWriter)new AbstractLineStreamWriter(){

                            protected void onLine(String line) {
                                log.info((CharSequence)line);
                            }
                        });
                    }
                }
                packages = packages.cons((Object)P.p((Object)unixPackage, (Object)pakke, assemblyOperations));
            }
            catch (UnknownArtifactException e) {
                TreeMap<String, Artifact> map = new TreeMap<String, Artifact>(e.artifactMap);
                log.warn((CharSequence)("Could not find artifact:" + e.artifact));
                log.warn((CharSequence)"Available artifacts:");
                for (Object o : map.keySet()) {
                    log.warn((CharSequence)o.toString());
                }
                throw new MojoFailureException("Unable to find artifact: '" + e.artifact + "'. See log for available artifacts.");
            }
            catch (MissingSettingException e) {
                String msg = "Missing required setting '" + e.getSetting() + "'";
                if (!pakke.classifier.isNone()) {
                    msg = msg + ", for '" + (String)pakke.classifier.some() + "'";
                }
                msg = msg + ", format '" + formatType + "'.";
                throw new MojoFailureException(msg);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error creating package '" + pakke.classifier + "', format '" + formatType + "'.", (Exception)e);
            }
        }
        return new Execution((List<P3<UnixPackage, Package, List<AssemblyOperation>>>)packages, project, formatType, attachedMode);
    }

    public static PackageParameters calculatePackageParameters(MavenProjectWrapper project, PackageVersion version, PackagingMojoParameters mojoParameters, Package pakke) {
        String defaultId = project.artifactId;
        if (pakke.classifier.isSome()) {
            defaultId = defaultId + "-" + (String)pakke.classifier.some();
        }
        return PackageParameters.packageParameters((String)project.groupId, (String)project.artifactId, (PackageVersion)version, (String)((String)pakke.id.orSome((Object)defaultId.toLowerCase()))).name(pakke.name.orElse(mojoParameters.name).orElse(project.name)).description(pakke.description.orElse(mojoParameters.description).orElse(project.description)).contact(mojoParameters.contact).contactEmail(mojoParameters.contactEmail).license(MojoHelper.getLicense(project)).architecture(mojoParameters.architecture);
    }

    public static List<AssemblyOperation> createAssemblyOperations(MavenProjectWrapper project, PackagingMojoParameters mojoParameters, Package pakke, UnixPackage unixPackage, FileObject basedir) throws IOException, MojoFailureException, UnknownArtifactException {
        Defaults defaults = (Defaults)mojoParameters.defaults.orSome((Object)new Defaults());
        List operations = List.nil();
        FileAttributes defaultFileAttributes = defaults.getFileAttributes();
        FileAttributes defaultDirectoryAttributes = defaults.getDirectoryAttributes();
        unixPackage.beforeAssembly(defaultDirectoryAttributes);
        List assemblyOps = mojoParameters.assembly.append(pakke.assembly);
        for (AssemblyOp assemblyOp : assemblyOps) {
            assemblyOp.setArtifactMap(project.artifactConflictIdMap);
            AssemblyOperation operation = assemblyOp.createOperation(basedir, defaultFileAttributes, defaultDirectoryAttributes);
            operations = operations.cons((Object)operation);
        }
        return operations.reverse();
    }

    public static List<Package> validatePackages(List<Package> packages, boolean attachedMode) throws MojoFailureException {
        if (packages.isEmpty()) {
            packages = List.single((Object)new Package());
        }
        Set names = Set.empty((Ord)Ord.stringOrd);
        List outPackages = List.nil();
        Option defaultPackage = Option.none();
        for (Package pakke : packages) {
            if (pakke.classifier.exists(Function.curry((F2)StringF.equals, (Object)"default"))) {
                pakke.classifier = Option.none();
            }
            if (pakke.classifier.isNone()) {
                if (defaultPackage.isSome()) {
                    throw new MojoFailureException(DUPLICATE_UNCLASSIFIED);
                }
                defaultPackage = Option.some((Object)pakke);
                continue;
            }
            if (names.member(pakke.classifier.some())) {
                throw new MojoFailureException(String.format(DUPLICATE_CLASSIFIER, pakke.classifier));
            }
            names = names.insert(pakke.classifier.some());
            outPackages = outPackages.cons((Object)pakke);
        }
        if (attachedMode) {
            outPackages = defaultPackage.toList().append(outPackages);
            if (outPackages.isEmpty()) {
                throw new MojoFailureException(ATTACHED_NO_ARTIFACTS_CONFIGURED);
            }
            return outPackages;
        }
        if (defaultPackage.isNone()) {
            throw new MojoFailureException("When running in 'primary artifact mode' either one package has to have 'default' as classifier or there has to be one without any classifier.");
        }
        return defaultPackage.toList().append(outPackages);
    }

    protected static String defaultValue(String value, String defaultValue) {
        return StringUtils.isNotEmpty((String)value) ? value : defaultValue;
    }

    private static Option<String> getLicense(MavenProjectWrapper project) {
        if (project.licenses.size() == 0) {
            return Option.none();
        }
        return Option.some((Object)project.licenses.get(0).getName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Execution {
        private final List<P3<UnixPackage, Package, List<AssemblyOperation>>> packages;
        private final MavenProjectWrapper project;
        private final String formatType;
        private final boolean attachedMode;

        public Execution(List<P3<UnixPackage, Package, List<AssemblyOperation>>> packages, MavenProjectWrapper project, String formatType, boolean attachedMode) {
            this.packages = packages;
            this.project = project;
            this.formatType = formatType;
            this.attachedMode = attachedMode;
        }

        public void execute(String artifactType, MavenProject mavenProject, MavenProjectHelper mavenProjectHelper, ScriptUtil.Strategy strategy) throws MojoExecutionException, MojoFailureException {
            for (P3 p : this.packages) {
                UnixPackage unixPackage = (UnixPackage)p._1();
                Package pakke = (Package)p._2();
                try {
                    for (AssemblyOperation assemblyOperation : (List)p._3()) {
                        assemblyOperation.perform((FileCollector)unixPackage);
                    }
                    String name = this.project.artifactId + (String)pakke.classifier.map(dashString).orSome((Object)"") + "-" + unixPackage.getVersion().getMavenVersion() + "." + unixPackage.getPackageFileExtension();
                    File packageFile = new File(this.project.buildDirectory, name);
                    unixPackage.packageToFile(packageFile, strategy);
                    this.attach(pakke.classifier, artifactType, packageFile, mavenProject, mavenProjectHelper, this.attachedMode);
                }
                catch (MojoExecutionException e) {
                    throw e;
                }
                catch (MojoFailureException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new MojoExecutionException("Unable to create package.", e);
                }
            }
        }

        private void attach(Option<String> classifier, String artifactType, File packageFile, MavenProject project, MavenProjectHelper mavenProjectHelper, boolean attachedMode) {
            if (attachedMode) {
                if (classifier.isSome()) {
                    mavenProjectHelper.attachArtifact(project, artifactType, (String)classifier.some(), packageFile);
                } else {
                    mavenProjectHelper.attachArtifact(project, artifactType, null, packageFile);
                }
            } else if (classifier.isNone()) {
                project.getArtifact().setFile(packageFile);
            } else {
                mavenProjectHelper.attachArtifact(project, this.formatType, (String)classifier.some(), packageFile);
            }
        }
    }
}

