/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.unix.maven;

import fj.data.Option;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.unix.FileAttributes;
import org.codehaus.mojo.unix.core.AssemblyOperation;
import org.codehaus.mojo.unix.core.SetAttributesOperation;
import org.codehaus.mojo.unix.maven.AssemblyOp;
import org.codehaus.mojo.unix.maven.MojoFileAttributes;
import org.codehaus.mojo.unix.util.RelativePath;

public class SetAttributes
extends AssemblyOp {
    private RelativePath basedir = RelativePath.BASE;
    private List<String> includes = Collections.emptyList();
    private List<String> excludes = Collections.emptyList();
    private Option<MojoFileAttributes> fileAttributes = Option.none();
    private Option<MojoFileAttributes> directoryAttributes = Option.none();

    public SetAttributes() {
        super("set-attributes");
    }

    public void setBasedir(String basedir) {
        this.basedir = RelativePath.relativePath((String)basedir);
    }

    public void setIncludes(String[] includes) {
        this.includes = Arrays.asList(includes);
    }

    public void setExcludes(String[] excludes) {
        this.excludes = Arrays.asList(excludes);
    }

    public void setFileAttributes(MojoFileAttributes fileAttributes) {
        this.fileAttributes = Option.fromNull((Object)fileAttributes);
    }

    public void setDirectoryAttributes(MojoFileAttributes directoryAttributes) {
        this.directoryAttributes = Option.fromNull((Object)directoryAttributes);
    }

    public AssemblyOperation createOperation(FileObject basedir, FileAttributes defaultFileAttributes, FileAttributes defaultDirectoryAttributes) throws MojoFailureException, FileSystemException {
        return new SetAttributesOperation(this.basedir, this.includes, this.excludes, this.fileAttributes.map(MojoFileAttributes.create_), this.directoryAttributes.map(MojoFileAttributes.create_));
    }
}

