/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.unix.maven.dpkg;

import fj.F2;
import fj.data.Option;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.codehaus.mojo.unix.FileAttributes;
import org.codehaus.mojo.unix.FileCollector;
import org.codehaus.mojo.unix.PackageParameters;
import org.codehaus.mojo.unix.UnixFsObject;
import org.codehaus.mojo.unix.UnixPackage;
import org.codehaus.mojo.unix.core.FsFileCollector;
import org.codehaus.mojo.unix.dpkg.ControlFile;
import org.codehaus.mojo.unix.dpkg.Dpkg;
import org.codehaus.mojo.unix.util.ScriptUtil;
import org.codehaus.mojo.unix.util.UnixUtil;
import org.codehaus.mojo.unix.util.line.LineProducer;
import org.codehaus.mojo.unix.util.line.LineStreamUtil;
import org.codehaus.mojo.unix.util.vfs.VfsUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DpkgUnixPackage
extends UnixPackage {
    private static final String EOL = System.getProperty("line.separator");
    private ControlFile controlFile;
    private FileObject workingDirectory;
    private FsFileCollector fileCollector;
    private String dpkgDebPath;
    private boolean debug;
    private static final ScriptUtil scriptUtil = new ScriptUtil("preinst", "postinst", "prerm", "postrm");

    public DpkgUnixPackage() {
        super("deb");
    }

    public DpkgUnixPackage parameters(PackageParameters parameters) {
        this.controlFile = new ControlFile();
        this.controlFile.packageName = parameters.id;
        this.controlFile.description = DpkgUnixPackage.getDescription(parameters);
        if (parameters.contact.isSome()) {
            this.controlFile.maintainer = (String)parameters.contact.some();
        }
        this.controlFile.architecture = (String)parameters.architecture.orSome((Object)"all");
        this.controlFile.version = parameters.version;
        return this;
    }

    public UnixPackage workingDirectory(FileObject workingDirectory) throws FileSystemException {
        this.workingDirectory = workingDirectory;
        return this;
    }

    public UnixPackage debug(boolean debug) {
        this.debug = debug;
        return this;
    }

    public void beforeAssembly(FileAttributes defaultDirectoryAttributes) throws IOException {
        this.fileCollector = new FsFileCollector(this.workingDirectory.resolveFile("assembly"));
    }

    public FileObject getRoot() {
        return this.fileCollector.getRoot();
    }

    public FileCollector addDirectory(UnixFsObject.Directory directory) {
        this.fileCollector.addDirectory(directory);
        return this;
    }

    public FileCollector addFile(FileObject fromFile, UnixFsObject.RegularFile file) {
        this.fileCollector.addFile(fromFile, file);
        return this;
    }

    public FileCollector addSymlink(UnixFsObject.Symlink symlink) throws IOException {
        this.fileCollector.addSymlink(symlink);
        return this;
    }

    public void apply(F2<UnixFsObject, FileAttributes, FileAttributes> f) {
        this.fileCollector.apply(f);
    }

    public DpkgUnixPackage dpkgDeb(String dpkgDeb) {
        this.dpkgDebPath = dpkgDeb;
        return this;
    }

    public DpkgUnixPackage section(String secion) {
        this.controlFile.section = secion;
        return this;
    }

    public DpkgUnixPackage priority(String priority) {
        this.controlFile.priority = priority;
        return this;
    }

    public void packageToFile(File packageFile, ScriptUtil.Strategy strategy) throws Exception {
        FileObject fsRoot = this.fileCollector.getFsRoot();
        FileObject debian = fsRoot.resolveFile("DEBIAN");
        FileObject controlFilePath = debian.resolveFile("control");
        debian.createFolder();
        LineStreamUtil.toFile((LineProducer)this.controlFile, (File)VfsUtil.asFile((FileObject)controlFilePath));
        this.fileCollector.collect();
        ScriptUtil.Result result = scriptUtil.createExecution(this.controlFile.packageName, "dpkg", this.getScripts(), VfsUtil.asFile((FileObject)debian), strategy).execute();
        UnixUtil.chmodIf((Option)result.preInstall, (String)"0755");
        UnixUtil.chmodIf((Option)result.postInstall, (String)"0755");
        UnixUtil.chmodIf((Option)result.preRemove, (String)"0755");
        UnixUtil.chmodIf((Option)result.postRemove, (String)"0755");
        new Dpkg().setDebug(this.debug).setPackageRoot(VfsUtil.asFile((FileObject)fsRoot)).setDebFile(packageFile).setDpkgDebPath(this.dpkgDebPath).execute();
    }

    public static DpkgUnixPackage cast(UnixPackage unixPackage) {
        return (DpkgUnixPackage)unixPackage;
    }

    public static String getDescription(PackageParameters parameters) {
        String debianDescription;
        String description = "";
        if (parameters.name.isSome()) {
            description = ((String)parameters.name.some()).trim();
        }
        if (parameters.description.isSome()) {
            description = description + EOL + ((String)parameters.description.some()).trim();
        }
        try {
            BufferedReader reader = new BufferedReader(new StringReader(description.trim()));
            debianDescription = reader.readLine();
            String line = reader.readLine();
            if (line != null) {
                debianDescription = debianDescription + EOL + " " + line.trim();
                line = reader.readLine();
            }
            while (line != null) {
                debianDescription = (line = line.trim()).equals("") ? debianDescription + EOL + "." : debianDescription + EOL + " " + line;
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Internal error", e);
        }
        return debianDescription;
    }
}

