/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.unix.maven.rpm;

import fj.F2;
import fj.P;
import fj.P2;
import java.io.File;
import java.io.IOException;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.codehaus.mojo.unix.FileAttributes;
import org.codehaus.mojo.unix.FileCollector;
import org.codehaus.mojo.unix.MissingSettingException;
import org.codehaus.mojo.unix.PackageParameters;
import org.codehaus.mojo.unix.PackageVersion;
import org.codehaus.mojo.unix.UnixFsObject;
import org.codehaus.mojo.unix.UnixPackage;
import org.codehaus.mojo.unix.core.FsFileCollector;
import org.codehaus.mojo.unix.rpm.Rpmbuild;
import org.codehaus.mojo.unix.rpm.SpecFile;
import org.codehaus.mojo.unix.util.RelativePath;
import org.codehaus.mojo.unix.util.ScriptUtil;
import org.codehaus.mojo.unix.util.line.LineProducer;
import org.codehaus.mojo.unix.util.line.LineStreamUtil;
import org.codehaus.mojo.unix.util.vfs.VfsUtil;
import org.codehaus.plexus.util.FileUtils;
import org.joda.time.LocalDateTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RpmUnixPackage
extends UnixPackage {
    private SpecFile specFile;
    private FsFileCollector fileCollector;
    private FileObject workingDirectory;
    private String rpmbuildPath;
    private boolean debug;
    private static final ScriptUtil scriptUtil = new ScriptUtil("pre", "post", "preun", "postun");

    public RpmUnixPackage() {
        super("rpm");
    }

    public RpmUnixPackage parameters(PackageParameters parameters) {
        if (parameters.license.isNone()) {
            throw new MissingSettingException("The project has to specify at a license.");
        }
        this.specFile = new SpecFile();
        this.specFile.name = parameters.id;
        this.specFile.summary = (String)parameters.name.orSome((Object)"");
        this.specFile.description = (String)parameters.description.orSome((Object)"");
        this.specFile.license = (String)parameters.license.some();
        P2<String, String> rpmVersion = RpmUnixPackage.getRpmVersion(parameters.version);
        this.specFile.version = (String)rpmVersion._1();
        this.specFile.release = (String)rpmVersion._2();
        return this;
    }

    public UnixPackage group(String group) {
        this.specFile.group = group;
        return this;
    }

    public UnixPackage workingDirectory(FileObject workingDirectory) throws FileSystemException {
        this.workingDirectory = workingDirectory;
        return this;
    }

    public UnixPackage debug(boolean debug) {
        this.specFile.dump = debug;
        this.debug = debug;
        return this;
    }

    public void beforeAssembly(FileAttributes defaultDirectoryAttributes) throws IOException {
        this.specFile.beforeAssembly(UnixFsObject.directory((RelativePath)RelativePath.BASE, (LocalDateTime)new LocalDateTime(), (FileAttributes)defaultDirectoryAttributes));
        this.fileCollector = new FsFileCollector(this.workingDirectory.resolveFile("assembly"));
    }

    public UnixPackage rpmbuildPath(String rpmbuildPath) {
        this.rpmbuildPath = rpmbuildPath;
        return this;
    }

    public FileObject getRoot() {
        return this.fileCollector.getRoot();
    }

    public FileCollector addDirectory(UnixFsObject.Directory directory) throws IOException {
        this.specFile.addDirectory(directory);
        this.fileCollector.addDirectory(directory);
        return this;
    }

    public FileCollector addFile(FileObject fromFile, UnixFsObject.RegularFile file) throws IOException {
        this.specFile.addFile(file);
        this.fileCollector.addFile(fromFile, file);
        return this;
    }

    public FileCollector addSymlink(UnixFsObject.Symlink symlink) throws IOException {
        this.specFile.addSymlink(symlink);
        this.fileCollector.addSymlink(symlink);
        return this;
    }

    public void apply(F2<UnixFsObject, FileAttributes, FileAttributes> f) {
        this.specFile.apply(f);
    }

    public void packageToFile(File packageFile, ScriptUtil.Strategy strategy) throws Exception {
        File workingDirectoryF = VfsUtil.asFile((FileObject)this.workingDirectory);
        File rpms = new File(workingDirectoryF, "RPMS");
        File specsDir = new File(workingDirectoryF, "SPECS");
        File tmp = new File(workingDirectoryF, "tmp");
        File specFilePath = new File(specsDir, this.specFile.name + ".spec");
        FileUtils.forceMkdir((File)new File(workingDirectoryF, "BUILD"));
        FileUtils.forceMkdir((File)rpms);
        FileUtils.forceMkdir((File)new File(workingDirectoryF, "SOURCES"));
        FileUtils.forceMkdir((File)specsDir);
        FileUtils.forceMkdir((File)new File(workingDirectoryF, "SRPMS"));
        FileUtils.forceMkdir((File)tmp);
        this.fileCollector.collect();
        ScriptUtil.Result result = scriptUtil.createExecution(this.specFile.name, "rpm", this.getScripts(), workingDirectoryF, strategy).execute();
        this.specFile.includePre = result.preInstall;
        this.specFile.includePost = result.postInstall;
        this.specFile.includePreun = result.preRemove;
        this.specFile.includePostun = result.postRemove;
        this.specFile.buildRoot = VfsUtil.asFile((FileObject)this.fileCollector.getFsRoot());
        LineStreamUtil.toFile((LineProducer)this.specFile, (File)specFilePath);
        new Rpmbuild().setDebug(this.debug).setBuildroot(VfsUtil.asFile((FileObject)this.fileCollector.getFsRoot())).define("_tmppath " + tmp.getAbsolutePath()).define("_topdir " + workingDirectoryF.getAbsolutePath()).define("_rpmdir " + packageFile.getParentFile().getAbsolutePath()).define("_rpmfilename " + packageFile.getName()).setSpecFile(specFilePath).setRpmbuildPath(this.rpmbuildPath).buildBinary();
    }

    public static RpmUnixPackage cast(UnixPackage unixPackage) {
        return (RpmUnixPackage)unixPackage;
    }

    public static P2<String, String> getRpmVersion(PackageVersion version) {
        String rpmVersionString = version.version;
        if (version.snapshot) {
            rpmVersionString = rpmVersionString + "_" + version.timestamp;
        }
        return P.p((Object)rpmVersionString.replace('-', '_'), (Object)version.revision.orSome((Object)"1"));
    }
}

