/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.xmlbeans;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.xmlbeans.impl.tool.SchemaCompiler;
import org.codehaus.mojo.xmlbeans.ParameterAdapter;
import org.codehaus.mojo.xmlbeans.PluginProperties;
import org.codehaus.mojo.xmlbeans.SchemaArtifact;
import org.codehaus.mojo.xmlbeans.SchemaArtifactLookup;
import org.codehaus.mojo.xmlbeans.XmlBeansException;
import org.xml.sax.EntityResolver;

public abstract class AbstractXmlBeansPlugin
extends AbstractMojo
implements PluginProperties {
    private File outputJar;
    private boolean download;
    private boolean debug;
    private String memoryInitialSize;
    private String memoryMaximumSize;
    private String compiler;
    private boolean verbose;
    private boolean quiet = true;
    private boolean noUpa;
    private boolean noPvr;
    private boolean jaxb;
    private boolean noJavac;
    private String catalogLocation;
    private String sourceSchemas;
    private List xmlConfigs;
    private String javaSource;
    private List pluginArtifacts;
    private ArtifactRepository localRepository;
    private ArtifactFactory factory;
    protected MavenProject project;
    private EntityResolver entityResolver = null;
    private static final File[] EMPTY_FILE_ARRAY = new File[0];
    private File[] xsdFiles;

    public final void execute() throws MojoExecutionException {
        if (this.hasSchemas() && this.isOutputStale()) {
            try {
                SchemaCompiler.Parameters compilerParams = ParameterAdapter.getCompilerParameters(this);
                compilerParams.getSrcDir().mkdirs();
                boolean result = SchemaCompiler.compile((SchemaCompiler.Parameters)compilerParams);
                if (!result) {
                    StringBuffer errors = new StringBuffer();
                    Iterator iterator = compilerParams.getErrorListener().iterator();
                    while (iterator.hasNext()) {
                        Object o = iterator.next();
                        errors.append("xml Error" + o);
                        errors.append("\n");
                    }
                    throw new XmlBeansException(XmlBeansException.COMPILE_ERRORS, errors.toString());
                }
                this.updateProject(this.project, compilerParams);
                this.touchStaleFile();
            }
            catch (DependencyResolutionRequiredException drre) {
                throw new XmlBeansException(XmlBeansException.CLASSPATH_DEPENDENCY, drre);
            }
            catch (IOException ioe) {
                throw new XmlBeansException(XmlBeansException.STALE_FILE_TOUCH, this.getStaleFile().getAbsolutePath(), (Throwable)ioe);
            }
        } else {
            this.getLog().info((CharSequence)"Either nothing to generate or all schema objects are up to date.");
        }
    }

    private boolean hasSchemas() throws XmlBeansException {
        return this.getXsdFiles().length > 0;
    }

    protected abstract void updateProject(MavenProject var1, SchemaCompiler.Parameters var2) throws DependencyResolutionRequiredException;

    protected abstract List getXsdJars();

    protected abstract File getGeneratedSchemaDirectory();

    private void touchStaleFile() throws IOException {
        File staleFile = this.getStaleFile();
        if (!staleFile.exists()) {
            staleFile.getParentFile().mkdirs();
            staleFile.createNewFile();
            this.getLog().debug((CharSequence)"Stale flag file created.");
        } else {
            staleFile.setLastModified(System.currentTimeMillis());
        }
    }

    private boolean isOutputStale() throws XmlBeansException {
        boolean stale;
        File[] sourceXsds = this.getXsdFiles();
        File staleFile = this.getStaleFile();
        boolean bl = stale = !staleFile.exists();
        if (!stale) {
            this.getLog().debug((CharSequence)"Stale flag file exists, comparing to xsd's.");
            long staleMod = staleFile.lastModified();
            for (int i = 0; i < sourceXsds.length; ++i) {
                if (sourceXsds[i].lastModified() <= staleMod) continue;
                this.getLog().debug((CharSequence)(sourceXsds[i].getName() + " is newer than the stale flag file."));
                stale = true;
            }
        }
        return stale;
    }

    public final void setLocalRepository(ArtifactRepository repository) {
        this.localRepository = repository;
    }

    public abstract File getBaseDir();

    public abstract File getStaleFile();

    public abstract File getDefaultXmlConfigDir();

    public abstract File getSchemaDirectory();

    public final File[] getClasspath() {
        ArrayList<File> results = new ArrayList<File>(this.project.getArtifacts().size() + this.project.getPluginArtifacts().size());
        Iterator i = this.project.getArtifacts().iterator();
        while (i.hasNext()) {
            Artifact a = (Artifact)i.next();
            if (a.getFile() == null) continue;
            results.add(a.getFile());
        }
        HashSet<Artifact> set = new HashSet<Artifact>(this.project.getDependencyArtifacts());
        if (this.pluginArtifacts != null) {
            Iterator i2 = this.pluginArtifacts.iterator();
            while (i2.hasNext()) {
                Artifact a = (Artifact)i2.next();
                if (a.getFile() == null) continue;
                results.add(a.getFile());
                a = this.factory.createArtifact(a.getGroupId(), a.getArtifactId(), a.getVersion(), "compile", a.getType());
                set.add(a);
            }
        }
        this.project.setDependencyArtifacts(set);
        return results.toArray(EMPTY_FILE_ARRAY);
    }

    public final String getCompiler() {
        return this.compiler;
    }

    public final File[] getConfigFiles() throws XmlBeansException {
        File defaultXmlConfigDir = this.getDefaultXmlConfigDir();
        this.getLog().debug((CharSequence)"Creating a list of config files.");
        try {
            if (this.xmlConfigs != null) {
                return this.getFileList(this.xmlConfigs).toArray(new File[0]);
            }
            if (defaultXmlConfigDir.exists()) {
                ArrayList<File> defaultDir = new ArrayList<File>();
                defaultDir.add(defaultXmlConfigDir);
                return this.getFileList(defaultDir).toArray(new File[0]);
            }
            return null;
        }
        catch (XmlBeansException xmlbe) {
            throw new XmlBeansException(XmlBeansException.INVALID_CONFIG_FILE, (Throwable)((Object)xmlbe));
        }
    }

    private final List getFileList(List fileList) throws XmlBeansException {
        if (fileList != null) {
            this.getLog().debug((CharSequence)"A list was given.");
            ArrayList<File> files = new ArrayList<File>();
            File nextFile = null;
            ArrayList<File> nextDir = new ArrayList<File>();
            Iterator i = fileList.iterator();
            while (i.hasNext()) {
                nextFile = (File)i.next();
                if (nextFile.exists()) {
                    if (nextFile.getName().indexOf(46) == 0) continue;
                    if (nextFile.isDirectory()) {
                        this.getLog().debug((CharSequence)"One entry was a directory. Getting its children too.");
                        File[] children = nextFile.listFiles();
                        for (int j = 0; j < children.length; ++j) {
                            nextDir.clear();
                            nextDir.add(children[j]);
                            files.addAll(this.getFileList(nextDir));
                        }
                        continue;
                    }
                    this.getLog().debug((CharSequence)("Adding file " + nextFile.getAbsolutePath()));
                    files.add(nextFile);
                    continue;
                }
                throw new XmlBeansException(XmlBeansException.MISSING_FILE, nextFile.getAbsolutePath());
            }
            return files;
        }
        this.getLog().debug((CharSequence)"No list was given. Returning.");
        return null;
    }

    public final EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public final Collection getErrorListeners() {
        ArrayList listener = new ArrayList();
        return listener;
    }

    public final List getExtensions() {
        return null;
    }

    final void setProject(MavenProject newProject) {
        this.project = newProject;
    }

    public final File[] getJavaFiles() {
        return new File[0];
    }

    public final Set getMdefNamespaces() {
        return null;
    }

    public final String getJavaSource() {
        return this.javaSource;
    }

    public final String getMemoryInitialSize() {
        return this.memoryInitialSize;
    }

    public final String getMemoryMaximumSize() {
        return this.memoryMaximumSize;
    }

    public final String getName() {
        return null;
    }

    public final File getOutputJar() {
        return this.outputJar;
    }

    public final String getRepackage() {
        return null;
    }

    public final File[] getWsdlFiles() {
        return new File[0];
    }

    public final File[] getXsdFiles() throws XmlBeansException {
        if (this.xsdFiles == null) {
            File schemaDirectory = this.getSchemaDirectory();
            List schemas = this.getArtifactSchemas();
            if (this.sourceSchemas != null) {
                StringTokenizer st = new StringTokenizer(this.sourceSchemas, ",");
                while (st.hasMoreTokens()) {
                    String schemaName = st.nextToken();
                    schemas.add(new File(schemaDirectory, schemaName));
                }
            } else {
                this.getLog().debug((CharSequence)("The schema Directory is " + schemaDirectory));
                File[] files = schemaDirectory.listFiles(new XSDFile());
                if (files != null) {
                    for (int i = 0; i < files.length; ++i) {
                        schemas.add(files[i]);
                    }
                }
            }
            this.xsdFiles = schemas.toArray(new File[0]);
        }
        return this.xsdFiles;
    }

    private List getArtifactSchemas() throws XmlBeansException {
        this.getLog().debug((CharSequence)("Artifact count: " + this.project.getDependencyArtifacts().size()));
        SchemaArtifactLookup lookup = new SchemaArtifactLookup(this.project.getDependencyArtifacts(), this.getLog());
        ArrayList artifactSchemas = new ArrayList();
        List xsdJars = this.getXsdJars();
        File prefix = this.getGeneratedSchemaDirectory();
        int count = xsdJars.size();
        Artifact nextArtifact = null;
        this.getLog().debug((CharSequence)"looking for artifact schemas.");
        for (int i = 0; i < count; ++i) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("resolving " + xsdJars.get(i) + "into a file path."));
            }
            nextArtifact = lookup.find((String)xsdJars.get(i));
            artifactSchemas.addAll(SchemaArtifact.getFilePaths(nextArtifact, this.getLog(), prefix));
        }
        return artifactSchemas;
    }

    public final boolean isDebug() {
        return this.debug;
    }

    public final boolean isDownload() {
        return this.download;
    }

    public final boolean isJaxb() {
        return this.jaxb;
    }

    public final boolean isNoJavac() {
        return this.noJavac;
    }

    public final boolean isNoPvr() {
        return this.noPvr;
    }

    public final boolean isNoUpa() {
        return this.noUpa;
    }

    public final boolean isQuiet() {
        return this.quiet;
    }

    public final boolean isVerbose() {
        return this.verbose;
    }

    public final void validate() throws XmlBeansException {
    }

    public void setPluginArtifacts(List pluginArtifacts) {
        this.pluginArtifacts = pluginArtifacts;
    }

    public abstract /* synthetic */ File getGeneratedClassesDirectory();

    public abstract /* synthetic */ File getGeneratedSourceDirectory();

    private final class XSDFile
    implements FileFilter {
        private XSDFile() {
        }

        public boolean accept(File file) {
            return file.getName().endsWith(".xsd");
        }
    }
}

