/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.xmlbeans;

import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.mojo.xmlbeans.XmlBeansException;

public class SchemaArtifactLookup {
    private Log logger;
    private Set artifacts;

    public SchemaArtifactLookup(Set projectArtifacts, Log log) {
        this.artifacts = projectArtifacts;
        this.logger = log;
    }

    public Artifact find(String string) throws XmlBeansException {
        Artifact result = null;
        ArtifactReference ref = new ArtifactReference(string);
        Artifact nextArtifact = null;
        Iterator i = this.artifacts.iterator();
        while (i.hasNext()) {
            nextArtifact = (Artifact)i.next();
            this.logger.debug((CharSequence)("Looking at " + nextArtifact.getArtifactId()));
            if (!ref.equals(nextArtifact)) continue;
            result = nextArtifact;
            this.logger.debug((CharSequence)"Found one.");
            break;
        }
        if (result == null) {
            throw new XmlBeansException(XmlBeansException.INVALID_ARTIFACT_REFERENCE, string);
        }
        return result;
    }

    private class ArtifactReference {
        String groupId;
        String artifactId;

        private ArtifactReference(String path) throws XmlBeansException {
            StringTokenizer tokens = new StringTokenizer(path, ":");
            if (tokens.countTokens() != 2) {
                throw new XmlBeansException(XmlBeansException.INVALID_ARTIFACT_REFERENCE, path);
            }
            this.groupId = tokens.nextToken();
            this.artifactId = tokens.nextToken();
        }

        public boolean equals(Object candidate) {
            boolean outcome = false;
            if (candidate instanceof Artifact) {
                Artifact artifact = (Artifact)candidate;
                outcome = this.groupId.equals(artifact.getGroupId()) && this.artifactId.equals(artifact.getArtifactId());
            }
            return outcome;
        }
    }
}

