/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.xmlbeans;

import java.util.Map;
import java.util.StringTokenizer;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.mojo.xmlbeans.XmlBeansException;

public class SchemaArtifactLookup {
    private Log logger;
    private Map artifacts;

    public SchemaArtifactLookup(Map projectArtifacts, Log log) {
        this.artifacts = projectArtifacts;
        this.logger = log;
    }

    public Artifact find(String string) throws XmlBeansException {
        Artifact result = null;
        if (!this.artifacts.containsKey(string)) {
            throw new XmlBeansException(XmlBeansException.INVALID_ARTIFACT_REFERENCE, string);
        }
        result = (Artifact)this.artifacts.get(string);
        return result;
    }

    private class ArtifactReference {
        String groupId;
        String artifactId;

        private ArtifactReference(String path) throws XmlBeansException {
            StringTokenizer tokens = new StringTokenizer(path, ":");
            if (tokens.countTokens() != 2) {
                throw new XmlBeansException(XmlBeansException.INVALID_ARTIFACT_REFERENCE, path);
            }
            this.groupId = tokens.nextToken();
            this.artifactId = tokens.nextToken();
        }

        public boolean equals(Object candidate) {
            boolean outcome = false;
            if (candidate instanceof Artifact) {
                Artifact artifact = (Artifact)candidate;
                outcome = this.groupId.equals(artifact.getGroupId()) && this.artifactId.equals(artifact.getArtifactId());
            }
            return outcome;
        }
    }
}

