/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.redback.authentication.users;

import java.util.HashMap;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.redback.authentication.AuthenticationDataSource;
import org.codehaus.plexus.redback.authentication.AuthenticationException;
import org.codehaus.plexus.redback.authentication.AuthenticationResult;
import org.codehaus.plexus.redback.authentication.Authenticator;
import org.codehaus.plexus.redback.authentication.PasswordBasedAuthenticationDataSource;
import org.codehaus.plexus.redback.policy.AccountLockedException;
import org.codehaus.plexus.redback.policy.MustChangePasswordException;
import org.codehaus.plexus.redback.policy.PasswordEncoder;
import org.codehaus.plexus.redback.policy.UserSecurityPolicy;
import org.codehaus.plexus.redback.users.User;
import org.codehaus.plexus.redback.users.UserManager;
import org.codehaus.plexus.redback.users.UserNotFoundException;

public class UserManagerAuthenticator
extends AbstractLogEnabled
implements Authenticator {
    private UserManager userManager;
    private UserSecurityPolicy securityPolicy;

    public String getId() {
        return "UserManagerAuthenticator";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthenticationResult authenticate(AuthenticationDataSource ds) throws AuthenticationException, AccountLockedException {
        boolean authenticationSuccess = false;
        String username = null;
        UserNotFoundException resultException = null;
        PasswordBasedAuthenticationDataSource source = (PasswordBasedAuthenticationDataSource)ds;
        HashMap<String, String> authnResultExceptionsMap = new HashMap<String, String>();
        try {
            this.getLogger().debug("Authenticate: " + source);
            User user = this.userManager.findUser(source.getPrincipal());
            username = user.getUsername();
            if (user.isLocked() && !user.isPasswordChangeRequired()) {
                throw new AccountLockedException("Account " + source.getPrincipal() + " is locked.", user);
            }
            PasswordEncoder encoder = this.securityPolicy.getPasswordEncoder();
            this.getLogger().debug("PasswordEncoder: " + encoder.getClass().getName());
            boolean isPasswordValid = encoder.isPasswordValid(user.getEncodedPassword(), source.getPassword());
            if (isPasswordValid) {
                this.getLogger().debug("User " + source.getPrincipal() + " provided a valid password");
                try {
                    this.securityPolicy.extensionPasswordExpiration(user);
                }
                catch (MustChangePasswordException e) {
                    user.setPasswordChangeRequired(true);
                }
                authenticationSuccess = true;
                user.setCountFailedLoginAttempts(0);
                this.userManager.updateUser(user);
                return new AuthenticationResult(true, (Object)source.getPrincipal(), null);
            }
            this.getLogger().warn("Password is Invalid for user " + source.getPrincipal() + ".");
            authnResultExceptionsMap.put("1", "Password is Invalid for user " + source.getPrincipal() + ".");
            try {
                this.securityPolicy.extensionExcessiveLoginAttempts(user);
            }
            finally {
                this.userManager.updateUser(user);
            }
            return new AuthenticationResult(false, (Object)source.getPrincipal(), null, authnResultExceptionsMap);
        }
        catch (UserNotFoundException e) {
            this.getLogger().warn("Login for user " + source.getPrincipal() + " failed. user not found.");
            resultException = e;
            authnResultExceptionsMap.put("1", "Login for user \" + source.getPrincipal() + \" failed. user not found.");
            return new AuthenticationResult(authenticationSuccess, (Object)username, (Exception)((Object)resultException), authnResultExceptionsMap);
        }
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public boolean supportsDataSource(AuthenticationDataSource source) {
        return source instanceof PasswordBasedAuthenticationDataSource;
    }
}

