/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.redback.configuration;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.evaluator.DefaultExpressionEvaluator;
import org.codehaus.plexus.evaluator.EvaluatorException;
import org.codehaus.plexus.evaluator.ExpressionSource;
import org.codehaus.plexus.evaluator.sources.SystemPropertyExpressionSource;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.codehaus.plexus.registry.Registry;
import org.codehaus.plexus.registry.RegistryException;

public class UserConfiguration
extends AbstractLogEnabled
implements Contextualizable,
Initializable {
    public static final String ROLE = UserConfiguration.class.getName();
    private static final String DEFAULT_CONFIG_RESOURCE = "org/codehaus/plexus/redback/config-defaults.properties";
    private List configs;
    private Registry lookupRegistry;
    private static final String PREFIX = "org.codehaus.plexus.redback";
    private Registry registry;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws InitializationException {
        try {
            this.performLegacyInitialization();
            try {
                this.registry.addConfigurationFromResource(DEFAULT_CONFIG_RESOURCE, PREFIX);
            }
            catch (RegistryException e) {
                ClassLoader prevCl = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
                    this.registry.addConfigurationFromResource(DEFAULT_CONFIG_RESOURCE, PREFIX);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(prevCl);
                }
            }
        }
        catch (RegistryException e) {
            throw new InitializationException(e.getMessage(), (Throwable)e);
        }
        this.lookupRegistry = this.registry.getSubset(PREFIX);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug(this.lookupRegistry.dump());
        }
    }

    private void performLegacyInitialization() throws InitializationException, RegistryException {
        DefaultExpressionEvaluator evaluator = new DefaultExpressionEvaluator();
        evaluator.addExpressionSource((ExpressionSource)new SystemPropertyExpressionSource());
        if (this.configs == null) {
            this.configs = new ArrayList();
        }
        if (!this.configs.isEmpty()) {
            this.getLogger().warn("DEPRECATED: the <configs> elements is deprecated. Please configure the Plexus registry instead");
        }
        Iterator it = this.configs.iterator();
        while (it.hasNext()) {
            String configName = (String)it.next();
            try {
                configName = evaluator.expand(configName);
            }
            catch (EvaluatorException e) {
                this.getLogger().warn("Unable to resolve configuration name: " + e.getMessage(), (Throwable)e);
            }
            this.getLogger().info("Attempting to find configuration [" + configName + "] (resolved to [" + configName + "])");
            this.registry.addConfigurationFromFile(new File(configName), PREFIX);
        }
    }

    public String getString(String key) {
        return this.lookupRegistry.getString(key);
    }

    public int getInt(String key) {
        return this.lookupRegistry.getInt(key);
    }

    public boolean getBoolean(String key) {
        return this.lookupRegistry.getBoolean(key);
    }

    public int getInt(String key, int defaultValue) {
        return this.lookupRegistry.getInt(key, defaultValue);
    }

    public String getString(String key, String defaultValue) {
        return this.lookupRegistry.getString(key, defaultValue);
    }

    public void contextualize(Context context) throws ContextException {
        PlexusContainer container = (PlexusContainer)context.get((Object)"plexus");
        try {
            this.registry = (Registry)container.lookup(Registry.class.getName(), "commons-configuration");
        }
        catch (ComponentLookupException e) {
            throw new ContextException(e.getMessage(), (Throwable)e);
        }
    }
}

