/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.redback.rbac.jdo.io.stax;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.jdo.spi.PersistenceCapable;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.codehaus.plexus.redback.rbac.Operation;
import org.codehaus.plexus.redback.rbac.Resource;
import org.codehaus.plexus.redback.rbac.jdo.JdoOperation;
import org.codehaus.plexus.redback.rbac.jdo.JdoPermission;
import org.codehaus.plexus.redback.rbac.jdo.JdoResource;
import org.codehaus.plexus.redback.rbac.jdo.JdoRole;
import org.codehaus.plexus.redback.rbac.jdo.JdoUserAssignment;
import org.codehaus.plexus.redback.rbac.jdo.RbacDatabase;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class RbacJdoModelStaxReader {
    private Map jdoPermissionReferences;
    private Map jdoPermissionInstances;
    private Map jdoOperationReferences;
    private Map jdoResourceReferences;
    private Map jdoOperationInstances;
    private Map jdoResourceInstances;

    public Xpp3Dom buildDom(XMLStreamReader xmlStreamReader) throws XMLStreamException {
        ArrayList<Xpp3Dom> elements = new ArrayList<Xpp3Dom>();
        ArrayList<StringBuffer> values = new ArrayList<StringBuffer>();
        int eventType = xmlStreamReader.getEventType();
        while (xmlStreamReader.hasNext()) {
            if (eventType == 1) {
                String rawName = xmlStreamReader.getLocalName();
                Xpp3Dom childConfiguration = new Xpp3Dom(rawName);
                int depth = elements.size();
                if (depth > 0) {
                    Xpp3Dom parent = (Xpp3Dom)elements.get(depth - 1);
                    parent.addChild(childConfiguration);
                }
                elements.add(childConfiguration);
                if (xmlStreamReader.isEndElement()) {
                    values.add(null);
                } else {
                    values.add(new StringBuffer());
                }
                int attributesSize = xmlStreamReader.getAttributeCount();
                for (int i = 0; i < attributesSize; ++i) {
                    String name = xmlStreamReader.getAttributeLocalName(i);
                    String value = xmlStreamReader.getAttributeValue(i);
                    childConfiguration.setAttribute(name, value);
                }
            } else if (eventType == 4) {
                int depth = values.size() - 1;
                StringBuffer valueBuffer = (StringBuffer)values.get(depth);
                String text = xmlStreamReader.getText();
                text = text.trim();
                valueBuffer.append(text);
            } else if (eventType == 2) {
                int depth = elements.size() - 1;
                Xpp3Dom finishedConfiguration = (Xpp3Dom)elements.remove(depth);
                Object accumulatedValue = values.remove(depth);
                if (finishedConfiguration.getChildCount() == 0) {
                    if (accumulatedValue == null) {
                        finishedConfiguration.setValue(null);
                    } else {
                        finishedConfiguration.setValue(accumulatedValue.toString());
                    }
                }
                if (depth == 0) {
                    return finishedConfiguration;
                }
            }
            eventType = xmlStreamReader.next();
        }
        throw new IllegalStateException("End of document found before returning to 0 depth");
    }

    public boolean getBooleanValue(String s, String attribute, XMLStreamReader xmlStreamReader) throws XMLStreamException {
        if (s != null) {
            return Boolean.valueOf(s);
        }
        return false;
    }

    public char getCharacterValue(String s, String attribute, XMLStreamReader xmlStreamReader) throws XMLStreamException {
        if (s != null) {
            return s.charAt(0);
        }
        return '\u0000';
    }

    public Date getDateValue(String s, String attribute, String dateFormat, XMLStreamReader xmlStreamReader) throws XMLStreamException {
        if (s != null) {
            if (dateFormat == null) {
                return new Date(Long.valueOf(s));
            }
            SimpleDateFormat dateParser = new SimpleDateFormat(dateFormat, Locale.US);
            try {
                return dateParser.parse(s);
            }
            catch (ParseException e) {
                throw new XMLStreamException(e.getMessage());
            }
        }
        return null;
    }

    public double getDoubleValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict) throws XMLStreamException {
        block3: {
            if (s != null) {
                try {
                    return Double.valueOf(s);
                }
                catch (NumberFormatException e) {
                    if (!strict) break block3;
                    throw new XMLStreamException("Unable to parse element '" + attribute + "', must be a floating point number but was '" + s + "'", xmlStreamReader.getLocation());
                }
            }
        }
        return 0.0;
    }

    public float getFloatValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict) throws XMLStreamException {
        block3: {
            if (s != null) {
                try {
                    return Float.valueOf(s).floatValue();
                }
                catch (NumberFormatException e) {
                    if (!strict) break block3;
                    throw new XMLStreamException("Unable to parse element '" + attribute + "', must be a floating point number but was '" + s + "'", xmlStreamReader.getLocation());
                }
            }
        }
        return 0.0f;
    }

    public int getIntegerValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict) throws XMLStreamException {
        block3: {
            if (s != null) {
                try {
                    return Integer.valueOf(s);
                }
                catch (NumberFormatException e) {
                    if (!strict) break block3;
                    throw new XMLStreamException("Unable to parse element '" + attribute + "', must be an integer but was '" + s + "'", xmlStreamReader.getLocation());
                }
            }
        }
        return 0;
    }

    public long getLongValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict) throws XMLStreamException {
        block3: {
            if (s != null) {
                try {
                    return Long.valueOf(s);
                }
                catch (NumberFormatException e) {
                    if (!strict) break block3;
                    throw new XMLStreamException("Unable to parse element '" + attribute + "', must be a long integer but was '" + s + "'", xmlStreamReader.getLocation());
                }
            }
        }
        return 0L;
    }

    public String getRequiredAttributeValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict) throws XMLStreamException {
        if (s == null && strict) {
            throw new XMLStreamException("Missing required value for attribute '" + attribute + "'", xmlStreamReader.getLocation());
        }
        return s;
    }

    public short getShortValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict) throws XMLStreamException {
        block3: {
            if (s != null) {
                try {
                    return Short.valueOf(s);
                }
                catch (NumberFormatException e) {
                    if (!strict) break block3;
                    throw new XMLStreamException("Unable to parse element '" + attribute + "', must be a short integer but was '" + s + "'", xmlStreamReader.getLocation());
                }
            }
        }
        return 0;
    }

    public String getTrimmedValue(String s) {
        if (s != null) {
            s = s.trim();
        }
        return s;
    }

    private JdoOperation parseJdoOperation(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding) throws IOException, XMLStreamException {
        String v;
        JdoOperation jdoOperation = new JdoOperation();
        jdoOperation.setModelEncoding(encoding);
        HashSet<String> parsed = new HashSet<String>();
        if (this.jdoOperationInstances == null) {
            this.jdoOperationInstances = new HashMap();
        }
        if ((v = xmlStreamReader.getAttributeValue(null, "modello.id")) != null) {
            this.jdoOperationInstances.put(v, jdoOperation);
        }
        while (xmlStreamReader.nextTag() == 1) {
            if (xmlStreamReader.getLocalName().equals("name")) {
                if (parsed.contains("name")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("name");
                jdoOperation.setName(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("description")) {
                if (parsed.contains("description")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("description");
                jdoOperation.setDescription(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("permanent")) {
                if (parsed.contains("permanent")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("permanent");
                jdoOperation.setPermanent(this.getBooleanValue(this.getTrimmedValue(xmlStreamReader.getElementText()), "permanent", xmlStreamReader));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("resourceRequired")) {
                if (parsed.contains("resourceRequired")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("resourceRequired");
                jdoOperation.setResourceRequired(this.getBooleanValue(this.getTrimmedValue(xmlStreamReader.getElementText()), "resourceRequired", xmlStreamReader));
                continue;
            }
            if (!strict) continue;
            throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
        }
        this.jdoOperationInstances.put(jdoOperation.getName(), jdoOperation);
        return jdoOperation;
    }

    private JdoPermission parseJdoPermission(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding) throws IOException, XMLStreamException {
        String v;
        JdoPermission jdoPermission = new JdoPermission();
        jdoPermission.setModelEncoding(encoding);
        HashSet<String> parsed = new HashSet<String>();
        if (this.jdoPermissionInstances == null) {
            this.jdoPermissionInstances = new HashMap();
        }
        if ((v = xmlStreamReader.getAttributeValue(null, "modello.id")) != null) {
            this.jdoPermissionInstances.put(v, jdoPermission);
        }
        while (xmlStreamReader.nextTag() == 1) {
            HashMap<String, String> refs;
            String value;
            if (xmlStreamReader.getLocalName().equals("name")) {
                if (parsed.contains("name")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("name");
                jdoPermission.setName(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("description")) {
                if (parsed.contains("description")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("description");
                jdoPermission.setDescription(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("permanent")) {
                if (parsed.contains("permanent")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("permanent");
                jdoPermission.setPermanent(this.getBooleanValue(this.getTrimmedValue(xmlStreamReader.getElementText()), "permanent", xmlStreamReader));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("operation")) {
                if (parsed.contains("operation")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("operation");
                value = xmlStreamReader.getAttributeValue(null, "name");
                if (value != null) {
                    if (this.jdoOperationReferences == null) {
                        this.jdoOperationReferences = new HashMap();
                    }
                    if ((refs = (HashMap<String, String>)this.jdoOperationReferences.get(jdoPermission)) == null) {
                        refs = new HashMap<String, String>();
                        this.jdoOperationReferences.put(jdoPermission, refs);
                    }
                    refs.put("operation", value);
                }
                while (xmlStreamReader.getEventType() != 2) {
                    xmlStreamReader.next();
                }
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("resource")) {
                if (parsed.contains("resource")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("resource");
                value = xmlStreamReader.getAttributeValue(null, "identifier");
                if (value != null) {
                    if (this.jdoResourceReferences == null) {
                        this.jdoResourceReferences = new HashMap();
                    }
                    if ((refs = (Map)this.jdoResourceReferences.get(jdoPermission)) == null) {
                        refs = new HashMap();
                        this.jdoResourceReferences.put(jdoPermission, refs);
                    }
                    refs.put("resource", value);
                }
                while (xmlStreamReader.getEventType() != 2) {
                    xmlStreamReader.next();
                }
                continue;
            }
            if (!strict) continue;
            throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
        }
        this.jdoPermissionInstances.put(jdoPermission.getName(), jdoPermission);
        return jdoPermission;
    }

    private JdoResource parseJdoResource(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding) throws IOException, XMLStreamException {
        String v;
        JdoResource jdoResource = new JdoResource();
        jdoResource.setModelEncoding(encoding);
        HashSet<String> parsed = new HashSet<String>();
        if (this.jdoResourceInstances == null) {
            this.jdoResourceInstances = new HashMap();
        }
        if ((v = xmlStreamReader.getAttributeValue(null, "modello.id")) != null) {
            this.jdoResourceInstances.put(v, jdoResource);
        }
        while (xmlStreamReader.nextTag() == 1) {
            if (xmlStreamReader.getLocalName().equals("identifier")) {
                if (parsed.contains("identifier")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("identifier");
                jdoResource.setIdentifier(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("pattern")) {
                if (parsed.contains("pattern")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("pattern");
                jdoResource.setPattern(this.getBooleanValue(this.getTrimmedValue(xmlStreamReader.getElementText()), "pattern", xmlStreamReader));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("permanent")) {
                if (parsed.contains("permanent")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("permanent");
                jdoResource.setPermanent(this.getBooleanValue(this.getTrimmedValue(xmlStreamReader.getElementText()), "permanent", xmlStreamReader));
                continue;
            }
            if (!strict) continue;
            throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
        }
        this.jdoResourceInstances.put(jdoResource.getIdentifier(), jdoResource);
        return jdoResource;
    }

    private JdoRole parseJdoRole(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding) throws IOException, XMLStreamException {
        JdoRole jdoRole = new JdoRole();
        jdoRole.setModelEncoding(encoding);
        HashSet<String> parsed = new HashSet<String>();
        while (xmlStreamReader.nextTag() == 1) {
            if (xmlStreamReader.getLocalName().equals("name")) {
                if (parsed.contains("name")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("name");
                jdoRole.setName(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("description")) {
                if (parsed.contains("description")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("description");
                jdoRole.setDescription(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("assignable")) {
                if (parsed.contains("assignable")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("assignable");
                jdoRole.setAssignable(this.getBooleanValue(this.getTrimmedValue(xmlStreamReader.getElementText()), "assignable", xmlStreamReader));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("permanent")) {
                if (parsed.contains("permanent")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("permanent");
                jdoRole.setPermanent(this.getBooleanValue(this.getTrimmedValue(xmlStreamReader.getElementText()), "permanent", xmlStreamReader));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("childRoleNames")) {
                if (parsed.contains("childRoleNames")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("childRoleNames");
                ArrayList<String> childRoleNames = new ArrayList<String>();
                jdoRole.setChildRoleNames(childRoleNames);
                while (xmlStreamReader.nextTag() == 1) {
                    if (xmlStreamReader.getLocalName().equals("childRoleName")) {
                        childRoleNames.add(this.getTrimmedValue(xmlStreamReader.getElementText()));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("permissions")) {
                if (parsed.contains("permissions")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("permissions");
                ArrayList permissions = new ArrayList();
                jdoRole.setPermissions(permissions);
                while (xmlStreamReader.nextTag() == 1) {
                    if (xmlStreamReader.getLocalName().equals("permission")) {
                        String value = xmlStreamReader.getAttributeValue(null, "name");
                        if (value != null) {
                            HashMap<String, String> refs;
                            if (this.jdoPermissionReferences == null) {
                                this.jdoPermissionReferences = new HashMap();
                            }
                            if ((refs = (HashMap<String, String>)this.jdoPermissionReferences.get(jdoRole)) == null) {
                                refs = new HashMap<String, String>();
                                this.jdoPermissionReferences.put(jdoRole, refs);
                            }
                            refs.put("permissions." + permissions.size(), value);
                        }
                        jdoRole.addPermission(this.parseJdoPermission("permission", xmlStreamReader, strict, encoding));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (!strict) continue;
            throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
        }
        return jdoRole;
    }

    private JdoUserAssignment parseJdoUserAssignment(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding) throws IOException, XMLStreamException {
        JdoUserAssignment jdoUserAssignment = new JdoUserAssignment();
        jdoUserAssignment.setModelEncoding(encoding);
        HashSet<String> parsed = new HashSet<String>();
        while (xmlStreamReader.nextTag() == 1) {
            if (xmlStreamReader.getLocalName().equals("principal")) {
                if (parsed.contains("principal")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("principal");
                jdoUserAssignment.setPrincipal(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("timestamp")) {
                if (parsed.contains("timestamp")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("timestamp");
                String dateFormat = null;
                jdoUserAssignment.setTimestamp(this.getDateValue(this.getTrimmedValue(xmlStreamReader.getElementText()), "timestamp", dateFormat, xmlStreamReader));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("permanent")) {
                if (parsed.contains("permanent")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("permanent");
                jdoUserAssignment.setPermanent(this.getBooleanValue(this.getTrimmedValue(xmlStreamReader.getElementText()), "permanent", xmlStreamReader));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("roleNames")) {
                if (parsed.contains("roleNames")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("roleNames");
                ArrayList<String> roleNames = new ArrayList<String>();
                jdoUserAssignment.setRoleNames(roleNames);
                while (xmlStreamReader.nextTag() == 1) {
                    if (xmlStreamReader.getLocalName().equals("roleName")) {
                        roleNames.add(this.getTrimmedValue(xmlStreamReader.getElementText()));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (!strict) continue;
            throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
        }
        return jdoUserAssignment;
    }

    private RbacDatabase parseRbacDatabase(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding) throws IOException, XMLStreamException {
        RbacDatabase rbacDatabase = new RbacDatabase();
        rbacDatabase.setModelEncoding(encoding);
        HashSet<String> parsed = new HashSet<String>();
        boolean foundRoot = false;
        while (xmlStreamReader.hasNext()) {
            int eventType = xmlStreamReader.next();
            if (eventType != 1) continue;
            if (xmlStreamReader.getLocalName().equals(tagName)) {
                foundRoot = true;
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("roles")) {
                if (parsed.contains("roles")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("roles");
                ArrayList roles = new ArrayList();
                rbacDatabase.setRoles(roles);
                while (xmlStreamReader.nextTag() == 1) {
                    if (xmlStreamReader.getLocalName().equals("role")) {
                        rbacDatabase.addRole(this.parseJdoRole("role", xmlStreamReader, strict, encoding));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("permissions")) {
                if (parsed.contains("permissions")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("permissions");
                ArrayList permissions = new ArrayList();
                rbacDatabase.setPermissions(permissions);
                while (xmlStreamReader.nextTag() == 1) {
                    if (xmlStreamReader.getLocalName().equals("permission")) {
                        rbacDatabase.addPermission(this.parseJdoPermission("permission", xmlStreamReader, strict, encoding));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("operations")) {
                if (parsed.contains("operations")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("operations");
                ArrayList operations = new ArrayList();
                rbacDatabase.setOperations(operations);
                while (xmlStreamReader.nextTag() == 1) {
                    if (xmlStreamReader.getLocalName().equals("operation")) {
                        rbacDatabase.addOperation(this.parseJdoOperation("operation", xmlStreamReader, strict, encoding));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("resources")) {
                if (parsed.contains("resources")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("resources");
                ArrayList resources = new ArrayList();
                rbacDatabase.setResources(resources);
                while (xmlStreamReader.nextTag() == 1) {
                    if (xmlStreamReader.getLocalName().equals("resource")) {
                        rbacDatabase.addResource(this.parseJdoResource("resource", xmlStreamReader, strict, encoding));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("userAssignments")) {
                if (parsed.contains("userAssignments")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("userAssignments");
                ArrayList userAssignments = new ArrayList();
                rbacDatabase.setUserAssignments(userAssignments);
                while (xmlStreamReader.nextTag() == 1) {
                    if (xmlStreamReader.getLocalName().equals("userAssignment")) {
                        rbacDatabase.addUserAssignment(this.parseJdoUserAssignment("userAssignment", xmlStreamReader, strict, encoding));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (!foundRoot || !strict) continue;
            throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
        }
        return rbacDatabase;
    }

    public RbacDatabase read(Reader reader, boolean strict) throws IOException, XMLStreamException {
        XMLStreamReader xmlStreamReader = XMLInputFactory.newInstance().createXMLStreamReader(reader);
        String encoding = xmlStreamReader.getCharacterEncodingScheme();
        RbacDatabase value = this.parseRbacDatabase("rbacDatabase", xmlStreamReader, strict, encoding);
        this.resolveReferences(value);
        return value;
    }

    public RbacDatabase read(Reader reader) throws IOException, XMLStreamException {
        return this.read(reader, true);
    }

    public RbacDatabase read(String filePath, boolean strict) throws IOException, XMLStreamException {
        File file = new File(filePath);
        XMLStreamReader xmlStreamReader = XMLInputFactory.newInstance().createXMLStreamReader(file.toURL().toExternalForm(), new FileInputStream(file));
        String encoding = xmlStreamReader.getCharacterEncodingScheme();
        RbacDatabase value = this.parseRbacDatabase("rbacDatabase", xmlStreamReader, strict, encoding);
        this.resolveReferences(value);
        return value;
    }

    public RbacDatabase read(String filePath) throws IOException, XMLStreamException {
        return this.read(filePath, true);
    }

    private void resolveReferences(RbacDatabase value) {
        Iterator i = value.getRoles().iterator();
        while (i.hasNext()) {
            this.resolveReferences((JdoRole)i.next());
        }
        i = value.getPermissions().iterator();
        while (i.hasNext()) {
            this.resolveReferences((JdoPermission)i.next());
        }
    }

    private void resolveReferences(JdoRole value) {
        Map refs;
        if (this.jdoPermissionReferences != null && (refs = (Map)this.jdoPermissionReferences.get(value)) != null) {
            for (int i = 0; i < value.getPermissions().size(); ++i) {
                String id = (String)refs.get("permissions." + i);
                JdoPermission ref = (JdoPermission)this.jdoPermissionInstances.get(id);
                if (ref == null) continue;
                value.getPermissions().set(i, ref);
            }
        }
    }

    private void resolveReferences(JdoPermission value) {
        String id;
        PersistenceCapable ref;
        Map refs;
        if (this.jdoOperationReferences != null && (refs = (Map)this.jdoOperationReferences.get(value)) != null && (ref = (JdoOperation)this.jdoOperationInstances.get(id = (String)refs.get("operation"))) != null && !ref.equals(value.getOperation())) {
            value.setOperation((Operation)ref);
        }
        if (this.jdoResourceReferences != null && (refs = (Map)this.jdoResourceReferences.get(value)) != null && (ref = (JdoResource)this.jdoResourceInstances.get(id = (String)refs.get("resource"))) != null && !ref.equals(value.getResource())) {
            value.setResource((Resource)ref);
        }
    }
}

