/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.redback.rbac;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.codehaus.plexus.redback.rbac.Operation;
import org.codehaus.plexus.redback.rbac.Permission;
import org.codehaus.plexus.redback.rbac.RBACManager;
import org.codehaus.plexus.redback.rbac.RBACManagerListener;
import org.codehaus.plexus.redback.rbac.RbacManagerException;
import org.codehaus.plexus.redback.rbac.RbacObjectInvalidException;
import org.codehaus.plexus.redback.rbac.RbacObjectNotFoundException;
import org.codehaus.plexus.redback.rbac.Resource;
import org.codehaus.plexus.redback.rbac.Role;
import org.codehaus.plexus.redback.rbac.UserAssignment;
import org.codehaus.plexus.util.CollectionUtils;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractRBACManager
extends AbstractLogEnabled
implements RBACManager,
Initializable {
    private List listeners = new ArrayList();
    private Resource globalResource;

    public void addListener(RBACManagerListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(RBACManagerListener listener) {
        this.listeners.remove(listener);
    }

    public void fireRbacInit(boolean freshdb) {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            RBACManagerListener listener = (RBACManagerListener)it.next();
            try {
                listener.rbacInit(freshdb);
            }
            catch (Exception e) {
                this.getLogger().warn("Unable to trigger .rbacInit( boolean ) to " + listener.getClass().getName(), (Throwable)e);
            }
        }
    }

    public void fireRbacRoleSaved(Role role) {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            RBACManagerListener listener = (RBACManagerListener)it.next();
            try {
                listener.rbacRoleSaved(role);
            }
            catch (Exception e) {
                this.getLogger().warn("Unable to trigger .rbacRoleSaved( Role ) to " + listener.getClass().getName(), (Throwable)e);
            }
        }
    }

    public void fireRbacRoleRemoved(Role role) {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            RBACManagerListener listener = (RBACManagerListener)it.next();
            try {
                listener.rbacRoleRemoved(role);
            }
            catch (Exception e) {
                this.getLogger().warn("Unable to trigger .rbacRoleRemoved( Role ) to " + listener.getClass().getName(), (Throwable)e);
            }
        }
    }

    public void fireRbacPermissionSaved(Permission permission) {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            RBACManagerListener listener = (RBACManagerListener)it.next();
            try {
                listener.rbacPermissionSaved(permission);
            }
            catch (Exception e) {
                this.getLogger().warn("Unable to trigger .rbacPermissionSaved( Permission ) to " + listener.getClass().getName(), (Throwable)e);
            }
        }
    }

    public void fireRbacPermissionRemoved(Permission permission) {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            RBACManagerListener listener = (RBACManagerListener)it.next();
            try {
                listener.rbacPermissionRemoved(permission);
            }
            catch (Exception e) {
                this.getLogger().warn("Unable to trigger .rbacPermissionRemoved( Permission ) to " + listener.getClass().getName(), (Throwable)e);
            }
        }
    }

    public void fireRbacUserAssignmentSaved(UserAssignment userAssignment) {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            RBACManagerListener listener = (RBACManagerListener)it.next();
            try {
                listener.rbacUserAssignmentSaved(userAssignment);
            }
            catch (Exception e) {
                this.getLogger().warn("Unable to trigger .rbacUserAssignmentSaved( UserAssignment ) to " + listener.getClass().getName(), (Throwable)e);
            }
        }
    }

    public void fireRbacUserAssignmentRemoved(UserAssignment userAssignment) {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            RBACManagerListener listener = (RBACManagerListener)it.next();
            try {
                listener.rbacUserAssignmentRemoved(userAssignment);
            }
            catch (Exception e) {
                this.getLogger().warn("Unable to trigger .rbacUserAssignmentRemoved( UserAssignment ) to " + listener.getClass().getName(), (Throwable)e);
            }
        }
    }

    public void removeRole(String roleName) throws RbacObjectNotFoundException, RbacManagerException {
        this.removeRole(this.getRole(roleName));
    }

    public void removePermission(String permissionName) throws RbacObjectNotFoundException, RbacManagerException {
        this.removePermission(this.getPermission(permissionName));
    }

    public void removeOperation(String operationName) throws RbacObjectNotFoundException, RbacManagerException {
        this.removeOperation(this.getOperation(operationName));
    }

    public void removeResource(String resourceIdentifier) throws RbacObjectNotFoundException, RbacManagerException {
        this.removeResource(this.getResource(resourceIdentifier));
    }

    public void removeUserAssignment(String principal) throws RbacObjectNotFoundException, RbacManagerException {
        this.removeUserAssignment(this.getUserAssignment(principal));
    }

    public boolean resourceExists(Resource resource) {
        try {
            return this.getAllResources().contains(resource);
        }
        catch (RbacManagerException e) {
            return false;
        }
    }

    public boolean resourceExists(String identifier) {
        try {
            Iterator it = this.getAllResources().iterator();
            while (it.hasNext()) {
                Resource resource = (Resource)it.next();
                if (!StringUtils.equals((String)resource.getIdentifier(), (String)identifier)) continue;
                return true;
            }
        }
        catch (RbacManagerException e) {
            return false;
        }
        return false;
    }

    public boolean operationExists(Operation operation) {
        try {
            return this.getAllOperations().contains(operation);
        }
        catch (RbacManagerException e) {
            return false;
        }
    }

    public boolean operationExists(String name) {
        try {
            Iterator it = this.getAllOperations().iterator();
            while (it.hasNext()) {
                Operation operation = (Operation)it.next();
                if (!StringUtils.equals((String)operation.getName(), (String)name)) continue;
                return true;
            }
        }
        catch (RbacManagerException e) {
            return false;
        }
        return false;
    }

    public boolean permissionExists(Permission permission) {
        try {
            return this.getAllPermissions().contains(permission);
        }
        catch (RbacManagerException e) {
            return false;
        }
    }

    public boolean permissionExists(String name) {
        try {
            Iterator it = this.getAllPermissions().iterator();
            while (it.hasNext()) {
                Permission permission = (Permission)it.next();
                if (!StringUtils.equals((String)permission.getName(), (String)name)) continue;
                return true;
            }
        }
        catch (RbacManagerException e) {
            return false;
        }
        return false;
    }

    public boolean roleExists(Role role) {
        try {
            return this.getAllRoles().contains(role);
        }
        catch (RbacManagerException e) {
            return false;
        }
    }

    public boolean roleExists(String name) {
        try {
            Iterator it = this.getAllRoles().iterator();
            while (it.hasNext()) {
                Role role = (Role)it.next();
                if (!StringUtils.equals((String)role.getName(), (String)name)) continue;
                return true;
            }
        }
        catch (RbacManagerException e) {
            return false;
        }
        return false;
    }

    public boolean userAssignmentExists(String principal) {
        try {
            Iterator it = this.getAllUserAssignments().iterator();
            while (it.hasNext()) {
                UserAssignment assignment = (UserAssignment)it.next();
                if (!StringUtils.equals((String)assignment.getPrincipal(), (String)principal)) continue;
                return true;
            }
        }
        catch (RbacManagerException e) {
            return false;
        }
        return false;
    }

    public boolean userAssignmentExists(UserAssignment assignment) {
        try {
            return this.getAllUserAssignments().contains(assignment);
        }
        catch (RbacManagerException e) {
            return false;
        }
    }

    public Set getAssignedPermissions(String principal) throws RbacObjectNotFoundException, RbacManagerException {
        UserAssignment ua = this.getUserAssignment(principal);
        HashSet permissionSet = new HashSet();
        if (ua.getRoleNames() != null) {
            boolean childRoleNamesUpdated = false;
            ListIterator it = ua.getRoleNames().listIterator();
            while (it.hasNext()) {
                String roleName = (String)it.next();
                try {
                    Role role = this.getRole(roleName);
                    this.gatherUniquePermissions(role, permissionSet);
                }
                catch (RbacObjectNotFoundException e) {
                    it.remove();
                    childRoleNamesUpdated = true;
                }
            }
            if (childRoleNamesUpdated) {
                this.saveUserAssignment(ua);
            }
        }
        return permissionSet;
    }

    public Map getAssignedPermissionMap(String principal) throws RbacObjectNotFoundException, RbacManagerException {
        return this.getPermissionMapByOperation(this.getAssignedPermissions(principal));
    }

    private Map getPermissionMapByOperation(Collection permissions) {
        HashMap userPermMap = new HashMap();
        Iterator i = permissions.iterator();
        while (i.hasNext()) {
            Permission permission = (Permission)i.next();
            List permList = (List)userPermMap.get(permission.getOperation().getName());
            if (permList != null) {
                permList.add(permission);
                continue;
            }
            ArrayList<Permission> newPermList = new ArrayList<Permission>();
            newPermList.add(permission);
            userPermMap.put(permission.getOperation().getName(), newPermList);
        }
        return userPermMap;
    }

    private void gatherUniquePermissions(Role role, Collection coll) throws RbacManagerException {
        if (role.getPermissions() != null) {
            Iterator itperm = role.getPermissions().iterator();
            while (itperm.hasNext()) {
                Permission permission = (Permission)itperm.next();
                if (coll.contains(permission)) continue;
                coll.add(permission);
            }
        }
        if (role.hasChildRoles()) {
            Map childRoles = this.getChildRoles(role);
            Iterator it = childRoles.values().iterator();
            while (it.hasNext()) {
                Role child = (Role)it.next();
                this.gatherUniquePermissions(child, coll);
            }
        }
    }

    public List getAllAssignableRoles() throws RbacManagerException, RbacObjectNotFoundException {
        List allRoles = this.getAllRoles();
        ArrayList<Role> assignableRoles = new ArrayList<Role>();
        Iterator it = allRoles.iterator();
        while (it.hasNext()) {
            Role role = this.getRole(((Role)it.next()).getName());
            if (!role.isAssignable()) continue;
            assignableRoles.add(role);
        }
        return assignableRoles;
    }

    public Collection getAssignedRoles(String principal) throws RbacObjectNotFoundException, RbacManagerException {
        UserAssignment ua = this.getUserAssignment(principal);
        return this.getAssignedRoles(ua);
    }

    public Collection getAssignedRoles(UserAssignment ua) throws RbacObjectNotFoundException, RbacManagerException {
        HashSet<Role> roleSet = new HashSet<Role>();
        if (ua.getRoleNames() != null) {
            boolean childRoleNamesUpdated = false;
            ListIterator it = ua.getRoleNames().listIterator();
            while (it.hasNext()) {
                String roleName = (String)it.next();
                try {
                    Role role = this.getRole(roleName);
                    if (roleSet.contains(role)) continue;
                    roleSet.add(role);
                }
                catch (RbacObjectNotFoundException e) {
                    it.remove();
                    childRoleNamesUpdated = true;
                }
            }
            if (childRoleNamesUpdated) {
                this.saveUserAssignment(ua);
            }
        }
        return roleSet;
    }

    private void gatherEffectiveRoles(Role role, Set roleSet) throws RbacObjectNotFoundException, RbacManagerException {
        if (role.hasChildRoles()) {
            ListIterator it = role.getChildRoleNames().listIterator();
            while (it.hasNext()) {
                String roleName = (String)it.next();
                try {
                    Role crole = this.getRole(roleName);
                    if (roleSet.contains(crole)) continue;
                    this.gatherEffectiveRoles(crole, roleSet);
                }
                catch (RbacObjectNotFoundException e) {
                    this.getLogger().warn("dangling child role: " + roleName + " on " + role.getName());
                }
            }
        }
        if (!roleSet.contains(role)) {
            roleSet.add(role);
        }
    }

    public Collection getEffectivelyAssignedRoles(String principal) throws RbacObjectNotFoundException, RbacManagerException {
        UserAssignment ua = this.getUserAssignment(principal);
        return this.getEffectivelyAssignedRoles(ua);
    }

    public Collection getEffectivelyAssignedRoles(UserAssignment ua) throws RbacObjectNotFoundException, RbacManagerException {
        HashSet roleSet = new HashSet();
        if (ua != null && ua.getRoleNames() != null) {
            boolean childRoleNamesUpdated = false;
            ListIterator it = ua.getRoleNames().listIterator();
            while (it.hasNext()) {
                String roleName = (String)it.next();
                try {
                    Role role = this.getRole(roleName);
                    this.gatherEffectiveRoles(role, roleSet);
                }
                catch (RbacObjectNotFoundException e) {
                    it.remove();
                    childRoleNamesUpdated = true;
                }
            }
            if (childRoleNamesUpdated) {
                this.saveUserAssignment(ua);
            }
        }
        return roleSet;
    }

    public Collection getEffectivelyUnassignedRoles(String principal) throws RbacManagerException, RbacObjectNotFoundException {
        Collection assignedRoles = this.getEffectivelyAssignedRoles(principal);
        List allRoles = this.getAllAssignableRoles();
        this.getLogger().debug("UR: assigned " + assignedRoles.size());
        this.getLogger().debug("UR: available " + allRoles.size());
        return CollectionUtils.subtract((Collection)allRoles, (Collection)assignedRoles);
    }

    public Collection getUnassignedRoles(String principal) throws RbacManagerException, RbacObjectNotFoundException {
        Collection assignedRoles = this.getAssignedRoles(principal);
        List allRoles = this.getAllAssignableRoles();
        this.getLogger().debug("UR: assigned " + assignedRoles.size());
        this.getLogger().debug("UR: available " + allRoles.size());
        return CollectionUtils.subtract((Collection)allRoles, (Collection)assignedRoles);
    }

    public Resource getGlobalResource() throws RbacManagerException {
        if (this.globalResource == null) {
            this.globalResource = this.createResource("*");
            this.globalResource.setPermanent(true);
            this.globalResource = this.saveResource(this.globalResource);
        }
        return this.globalResource;
    }

    public void addChildRole(Role role, Role childRole) throws RbacObjectInvalidException, RbacManagerException {
        this.saveRole(childRole);
        role.addChildRoleName(childRole.getName());
    }

    public Map getChildRoles(Role role) throws RbacManagerException {
        List roleNames = role.getChildRoleNames();
        HashMap<String, Role> childRoles = new HashMap<String, Role>();
        boolean childRoleNamesUpdated = false;
        ListIterator it = roleNames.listIterator();
        while (it.hasNext()) {
            String roleName = (String)it.next();
            try {
                Role child = this.getRole(roleName);
                childRoles.put(child.getName(), child);
            }
            catch (RbacObjectNotFoundException e) {
                it.remove();
                childRoleNamesUpdated = true;
            }
        }
        if (childRoleNamesUpdated) {
            this.saveRole(role);
        }
        return childRoles;
    }

    public Set getEffectiveRoles(Role role) throws RbacObjectNotFoundException, RbacManagerException {
        HashSet roleSet = new HashSet();
        this.gatherEffectiveRoles(role, roleSet);
        return roleSet;
    }

    public Map getRoles(Collection roleNames) throws RbacObjectNotFoundException, RbacManagerException {
        HashMap<String, Role> roleMap = new HashMap<String, Role>();
        Iterator it = roleNames.iterator();
        while (it.hasNext()) {
            String roleName = (String)it.next();
            Role child = this.getRole(roleName);
            roleMap.put(child.getName(), child);
        }
        return roleMap;
    }

    public void initialize() throws InitializationException {
    }
}

