/*
 * $Id$
 */

package org.codehaus.plexus.redback.users.jdo;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * 
 *         @plexus.component
 * role="org.codehaus.plexus.redback.users.User"
 *         role-hint="jdo"
 *       
 * 
 * @version $Revision$ $Date$
 */
public class JdoUser 
implements org.codehaus.plexus.redback.users.User, java.io.Serializable
{


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field username
     */
    private String username;

    /**
     * Field password
     */
    private String password;

    /**
     * Field encodedPassword
     */
    private String encodedPassword;

    /**
     * Field fullName
     */
    private String fullName;

    /**
     * Field email
     */
    private String email;

    /**
     * Field lastPasswordChange
     */
    private java.util.Date lastPasswordChange;

    /**
     * Field lastLoginDate
     */
    private java.util.Date lastLoginDate;

    /**
     * Field countFailedLoginAttempts
     */
    private int countFailedLoginAttempts = 0;

    /**
     * Field locked
     */
    private boolean locked = false;

    /**
     * Field permanent
     */
    private boolean permanent = false;

    /**
     * Field validated
     */
    private boolean validated = false;

    /**
     * Field passwordChangeRequired
     */
    private boolean passwordChangeRequired = false;

    /**
     * Field previousEncodedPasswords
     */
    private java.util.List previousEncodedPasswords;

    /**
     * Field accountCreationDate
     */
    private java.util.Date accountCreationDate;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addPreviousEncodedPassword
     * 
     * @param string
     */
    public void addPreviousEncodedPassword(String string)
    {
        if ( !(string instanceof String) )
        {
            throw new ClassCastException( "JdoUser.addPreviousEncodedPasswords(string) parameter must be instanceof " + String.class.getName() );
        }
        getPreviousEncodedPasswords().add( string );
    } //-- void addPreviousEncodedPassword(String) 

    /**
     * Method equals
     * 
     * @param other
     */
    public boolean equals(Object other)
    {
        if ( this == other)
        {
            return true;
        }
        
        if ( !(other instanceof JdoUser) )
        {
            return false;
        }
        
        JdoUser that = (JdoUser) other;
        boolean result = true;
        result = result && ( getUsername() == null ? that.getUsername() == null : getUsername().equals( that.getUsername() ) );
        result = result && ( getPassword() == null ? that.getPassword() == null : getPassword().equals( that.getPassword() ) );
        result = result && ( getEncodedPassword() == null ? that.getEncodedPassword() == null : getEncodedPassword().equals( that.getEncodedPassword() ) );
        result = result && ( getFullName() == null ? that.getFullName() == null : getFullName().equals( that.getFullName() ) );
        result = result && ( getEmail() == null ? that.getEmail() == null : getEmail().equals( that.getEmail() ) );
        result = result && locked== that.locked;
        result = result && permanent== that.permanent;
        result = result && validated== that.validated;
        result = result && passwordChangeRequired== that.passwordChangeRequired;
        return result;
    } //-- boolean equals(Object) 

    /**
     * Get null
     */
    public java.util.Date getAccountCreationDate()
    {
        return this.accountCreationDate;
    } //-- java.util.Date getAccountCreationDate() 

    /**
     * Get null
     */
    public int getCountFailedLoginAttempts()
    {
        return this.countFailedLoginAttempts;
    } //-- int getCountFailedLoginAttempts() 

    /**
     * Get null
     */
    public String getEmail()
    {
        return this.email;
    } //-- String getEmail() 

    /**
     * Get null
     */
    public String getEncodedPassword()
    {
        return this.encodedPassword;
    } //-- String getEncodedPassword() 

    /**
     * Get null
     */
    public String getFullName()
    {
        return this.fullName;
    } //-- String getFullName() 

    /**
     * Get null
     */
    public java.util.Date getLastLoginDate()
    {
        return this.lastLoginDate;
    } //-- java.util.Date getLastLoginDate() 

    /**
     * Get null
     */
    public java.util.Date getLastPasswordChange()
    {
        return this.lastPasswordChange;
    } //-- java.util.Date getLastPasswordChange() 

    /**
     * Get null
     */
    public String getPassword()
    {
        return this.password;
    } //-- String getPassword() 

    /**
     * Method getPreviousEncodedPasswords
     */
    public java.util.List getPreviousEncodedPasswords()
    {
        if ( this.previousEncodedPasswords == null )
        {
            this.previousEncodedPasswords = new java.util.ArrayList();
        }
        
        return this.previousEncodedPasswords;
    } //-- java.util.List getPreviousEncodedPasswords() 

    /**
     * Get null
     */
    public String getUsername()
    {
        return this.username;
    } //-- String getUsername() 

    /**
     * Method hashCode
     */
    public int hashCode()
    {
        int result = 17;
        long tmp;
        result = 37 * result + ( username != null ? username.hashCode() : 0 );
        result = 37 * result + ( password != null ? password.hashCode() : 0 );
        result = 37 * result + ( encodedPassword != null ? encodedPassword.hashCode() : 0 );
        result = 37 * result + ( fullName != null ? fullName.hashCode() : 0 );
        result = 37 * result + ( email != null ? email.hashCode() : 0 );
        result = 37 * result + ( locked ? 0 : 1 );
        result = 37 * result + ( permanent ? 0 : 1 );
        result = 37 * result + ( validated ? 0 : 1 );
        result = 37 * result + ( passwordChangeRequired ? 0 : 1 );
        return result;
    } //-- int hashCode() 

    /**
     * Get null
     */
    public boolean isLocked()
    {
        return this.locked;
    } //-- boolean isLocked() 

    /**
     * Get null
     */
    public boolean isPasswordChangeRequired()
    {
        return this.passwordChangeRequired;
    } //-- boolean isPasswordChangeRequired() 

    /**
     * Get null
     */
    public boolean isPermanent()
    {
        return this.permanent;
    } //-- boolean isPermanent() 

    /**
     * Get null
     */
    public boolean isValidated()
    {
        return this.validated;
    } //-- boolean isValidated() 

    /**
     * Method removePreviousEncodedPassword
     * 
     * @param string
     */
    public void removePreviousEncodedPassword(String string)
    {
        if ( !(string instanceof String) )
        {
            throw new ClassCastException( "JdoUser.removePreviousEncodedPasswords(string) parameter must be instanceof " + String.class.getName() );
        }
        getPreviousEncodedPasswords().remove( string );
    } //-- void removePreviousEncodedPassword(String) 

    /**
     * Set null
     * 
     * @param accountCreationDate
     */
    public void setAccountCreationDate(java.util.Date accountCreationDate)
    {
        this.accountCreationDate = accountCreationDate;
    } //-- void setAccountCreationDate(java.util.Date) 

    /**
     * Set null
     * 
     * @param countFailedLoginAttempts
     */
    public void setCountFailedLoginAttempts(int countFailedLoginAttempts)
    {
        this.countFailedLoginAttempts = countFailedLoginAttempts;
    } //-- void setCountFailedLoginAttempts(int) 

    /**
     * Set null
     * 
     * @param email
     */
    public void setEmail(String email)
    {
        this.email = email;
    } //-- void setEmail(String) 

    /**
     * Set null
     * 
     * @param encodedPassword
     */
    public void setEncodedPassword(String encodedPassword)
    {
        this.encodedPassword = encodedPassword;
    } //-- void setEncodedPassword(String) 

    /**
     * Set null
     * 
     * @param fullName
     */
    public void setFullName(String fullName)
    {
        this.fullName = fullName;
    } //-- void setFullName(String) 

    /**
     * Set null
     * 
     * @param lastLoginDate
     */
    public void setLastLoginDate(java.util.Date lastLoginDate)
    {
        this.lastLoginDate = lastLoginDate;
    } //-- void setLastLoginDate(java.util.Date) 

    /**
     * Set null
     * 
     * @param lastPasswordChange
     */
    public void setLastPasswordChange(java.util.Date lastPasswordChange)
    {
        this.lastPasswordChange = lastPasswordChange;
    } //-- void setLastPasswordChange(java.util.Date) 

    /**
     * Set null
     * 
     * @param locked
     */
    public void setLocked(boolean locked)
    {
        this.locked = locked;
    } //-- void setLocked(boolean) 

    /**
     * Set null
     * 
     * @param password
     */
    public void setPassword(String password)
    {
        this.password = password;
    } //-- void setPassword(String) 

    /**
     * Set null
     * 
     * @param passwordChangeRequired
     */
    public void setPasswordChangeRequired(boolean passwordChangeRequired)
    {
        this.passwordChangeRequired = passwordChangeRequired;
    } //-- void setPasswordChangeRequired(boolean) 

    /**
     * Set null
     * 
     * @param permanent
     */
    public void setPermanent(boolean permanent)
    {
        this.permanent = permanent;
    } //-- void setPermanent(boolean) 

    /**
     * Set null
     * 
     * @param previousEncodedPasswords
     */
    public void setPreviousEncodedPasswords(java.util.List previousEncodedPasswords)
    {
        this.previousEncodedPasswords = previousEncodedPasswords;
    } //-- void setPreviousEncodedPasswords(java.util.List) 

    /**
     * Set null
     * 
     * @param username
     */
    public void setUsername(String username)
    {
        this.username = username;
    } //-- void setUsername(String) 

    /**
     * Set null
     * 
     * @param validated
     */
    public void setValidated(boolean validated)
    {
        this.validated = validated;
    } //-- void setValidated(boolean) 

    /**
     * Method toString
     */
    public java.lang.String toString()
    {
        StringBuffer buf = new StringBuffer();
        buf.append( "username = '" );
        buf.append( getUsername() + "'" );
        buf.append( "\n" ); 
        buf.append( "password = '" );
        buf.append( getPassword() + "'" );
        buf.append( "\n" ); 
        buf.append( "encodedPassword = '" );
        buf.append( getEncodedPassword() + "'" );
        buf.append( "\n" ); 
        buf.append( "fullName = '" );
        buf.append( getFullName() + "'" );
        buf.append( "\n" ); 
        buf.append( "email = '" );
        buf.append( getEmail() + "'" );
        buf.append( "\n" ); 
        buf.append( "locked = '" );
        buf.append( isLocked() + "'" );
        buf.append( "\n" ); 
        buf.append( "permanent = '" );
        buf.append( isPermanent() + "'" );
        buf.append( "\n" ); 
        buf.append( "validated = '" );
        buf.append( isValidated() + "'" );
        buf.append( "\n" ); 
        buf.append( "passwordChangeRequired = '" );
        buf.append( isPasswordChangeRequired() + "'" );
        return buf.toString();
    } //-- java.lang.String toString() 


              public JdoUser()
              {
                 // Intentionally initialize List to avoid JPOX NullPointerException Issues.
              	 previousEncodedPasswords = new java.util.ArrayList();
              }

              public Object getPrincipal()
              {
                 return username;
              }
          
    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
