/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.redback.example.web;

import java.util.List;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.redback.policy.UserSecurityPolicy;
import org.codehaus.plexus.redback.rbac.RBACManager;
import org.codehaus.plexus.redback.role.RoleManager;
import org.codehaus.plexus.redback.role.RoleManagerException;
import org.codehaus.plexus.redback.system.SecuritySystem;
import org.codehaus.plexus.redback.system.check.EnvironmentCheck;
import org.codehaus.plexus.redback.users.User;
import org.codehaus.plexus.redback.users.UserManager;
import org.codehaus.plexus.redback.users.UserNotFoundException;

public class TestUsersEnvironmentCheck
extends AbstractLogEnabled
implements EnvironmentCheck {
    private RoleManager roleManager;
    private RBACManager rbacManager;
    private SecuritySystem securitySystem;
    private boolean checked = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createUser(String username, String fullname, String email, String password, boolean locked, boolean validated) {
        User user;
        UserManager userManager = this.securitySystem.getUserManager();
        UserSecurityPolicy policy = this.securitySystem.getPolicy();
        try {
            user = userManager.findUser(username);
        }
        catch (UserNotFoundException e) {
            policy.setEnabled(false);
            user = userManager.createUser(username, fullname, email);
            user.setPassword(password);
            user.setLocked(locked);
            user.setValidated(validated);
            user = userManager.addUser(user);
        }
        finally {
            policy.setEnabled(true);
        }
        try {
            this.roleManager.assignRole("registered-user", user.getPrincipal().toString());
        }
        catch (RoleManagerException e) {
            this.getLogger().warn("Unable to set role: ", (Throwable)e);
        }
    }

    public void validateEnvironment(List violations) {
        if (!this.checked) {
            this.createUser("testuser1", "Test User 1", "test.user@gmail.com", "pass123", false, true);
            this.createUser("testuser2", "Test User 2", "test,user.2@gmail.com", "pass123", false, true);
            this.createUser("csvtest1", "CSV Test \"User\" 1", "csv.1@gmail.com", "pass123", false, false);
            this.createUser("csvtest2", "CSV Test \t'Pau 2", "csv.2@gmail.com", "pass123", false, true);
            this.createUser("csvtest3", "CSV Test User \next Generation 3", "csv.3@gmail.com", "pass123", true, true);
            this.createUser("amy", "Amy Wong", "amy@kapa.kapa.wong.mars", "guh!", false, true);
            this.createUser("bender", "Bender Bending Rodriguez", "bender@planetexpress.com", "elzarRox", false, true);
            this.createUser("leela", "Turanga Leela", "leela@planetexpress.com", "orphanarium", false, true);
            this.createUser("fry", "Philip J. Fry", "fry@planetexpress.com", "cool", false, true);
            this.createUser("kif", "Kif Krooker", "kif@nimbus.doop.mil", "sigh", false, true);
            this.createUser("zapp", "Zapp Brannigan", "zapp@nimbus.doop.mil", "leela", false, false);
            this.createUser("elzar", "Elzar", "elzar@elzarscuisine.com", "BAM!", false, true);
            this.createUser("mom", "Mom", "mom@momsfriendlyrobotcompany.com", "heartless", false, true);
            this.createUser("nibbler", "Lord Nibbler", "nibbler@planetexpress.com", "growl", false, false);
            this.createUser("hermes", "Hermes Conrad", "hermes@bureaucrat.planetexpress.com", "groovy", false, true);
            this.createUser("hubert", "Professor Hubert J. Farnsworth", "owner@planetexpress.com", "doomsday", false, true);
            this.createUser("zoidberg", "Dr. John Zoidberg", "doctor@planetexpress.com", "sayargh", true, false);
            this.checked = true;
        }
    }
}

