/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.redback.http.authentication;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.plexus.redback.authentication.AuthenticationDataSource;
import org.codehaus.plexus.redback.authentication.AuthenticationException;
import org.codehaus.plexus.redback.authentication.AuthenticationResult;
import org.codehaus.plexus.redback.http.authentication.HttpAuthenticationException;
import org.codehaus.plexus.redback.http.authentication.HttpAuthenticator;
import org.codehaus.plexus.redback.policy.AccountLockedException;
import org.codehaus.plexus.redback.policy.MustChangePasswordException;
import org.codehaus.plexus.redback.system.SecuritySession;
import org.codehaus.plexus.redback.system.SecuritySystem;
import org.codehaus.plexus.redback.users.User;
import org.codehaus.plexus.redback.users.UserNotFoundException;
import org.codehaus.plexus.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHttpAuthenticator
implements HttpAuthenticator {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String ROLE = AbstractHttpAuthenticator.class.getName();
    protected SecuritySystem securitySystem;

    protected AuthenticationResult authenticate(AuthenticationDataSource ds, Object session) throws AuthenticationException, AccountLockedException, MustChangePasswordException {
        try {
            SecuritySession securitySession = this.securitySystem.authenticate(ds);
            this.setSecuritySession(securitySession, session);
            return securitySession.getAuthenticationResult();
        }
        catch (AuthenticationException e) {
            String msg = "Unable to authenticate user: " + ds;
            this.log.info(msg, (Throwable)e);
            throw new HttpAuthenticationException(msg, e);
        }
        catch (UserNotFoundException e) {
            this.log.info("Login attempt against unknown user: " + ds);
            throw new HttpAuthenticationException("User name or password invalid.");
        }
    }

    public void authenticate(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException {
        try {
            AuthenticationResult result = this.getAuthenticationResult(request, response);
            if (result == null || !result.isAuthenticated()) {
                throw new HttpAuthenticationException("You are not authenticated.");
            }
        }
        catch (AccountLockedException e) {
            throw new HttpAuthenticationException("Your account is locked.");
        }
        catch (MustChangePasswordException e) {
            throw new HttpAuthenticationException("You must change your password.");
        }
    }

    protected abstract Object getSessionValue(Object var1, String var2);

    protected abstract void setSessionValue(Object var1, String var2, Object var3);

    protected User getSessionUser(Object session) {
        return (User)this.getSessionValue(session, "SecuritySessionUser");
    }

    protected boolean isAlreadyAuthenticated(Object session) {
        User user = this.getSessionUser(session);
        return user != null && !user.isLocked();
    }

    protected SecuritySession getSecuritySession(Object session) {
        return (SecuritySession)this.getSessionValue(session, SecuritySession.ROLE);
    }

    protected void setSecuritySession(SecuritySession session, Object sessionObj) {
        this.setSessionValue(sessionObj, SecuritySession.ROLE, session);
        this.setSessionValue(sessionObj, "SecuritySessionUser", session.getUser());
    }

    protected void setSessionUser(User user, Object session) {
        this.setSessionValue(session, SecuritySession.ROLE, null);
        this.setSessionValue(session, "SecuritySessionUser", user);
    }

    protected String storeDefaultUser(String principal, Object session) {
        this.setSessionValue(session, SecuritySession.ROLE, null);
        this.setSessionValue(session, "SecuritySessionUser", null);
        if (StringUtils.isEmpty((String)principal)) {
            return null;
        }
        try {
            User user = this.securitySystem.getUserManager().findUser(principal);
            this.setSessionValue(session, "SecuritySessionUser", user);
            return user.getPrincipal().toString();
        }
        catch (UserNotFoundException e) {
            this.log.warn("Default User '" + principal + "' not found.", (Throwable)e);
            return null;
        }
    }
}

