/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.redback.http.authentication.digest;

import java.io.IOException;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.codehaus.plexus.redback.authentication.AuthenticationDataSource;
import org.codehaus.plexus.redback.authentication.AuthenticationException;
import org.codehaus.plexus.redback.authentication.AuthenticationResult;
import org.codehaus.plexus.redback.authentication.TokenBasedAuthenticationDataSource;
import org.codehaus.plexus.redback.http.authentication.HttpAuthenticationException;
import org.codehaus.plexus.redback.http.authentication.SessionBasedHttpAuthenticator;
import org.codehaus.plexus.redback.http.authentication.digest.Digest;
import org.codehaus.plexus.redback.http.authentication.digest.HttpDigestHeader;
import org.codehaus.plexus.redback.http.authentication.digest.NonceExpirationException;
import org.codehaus.plexus.redback.policy.AccountLockedException;
import org.codehaus.plexus.redback.policy.MustChangePasswordException;
import org.codehaus.plexus.redback.users.User;
import org.codehaus.plexus.redback.users.UserManager;
import org.codehaus.plexus.redback.users.UserNotFoundException;
import org.codehaus.plexus.util.Base64;
import org.codehaus.plexus.util.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="attpAuthenticator#digest")
public class HttpDigestAuthentication
extends SessionBasedHttpAuthenticator {
    @Resource(name="userManager#configurable")
    private UserManager userManager;
    private int nonceLifetimeSeconds = 300;
    private String digestKey = "OrycteropusAfer";
    private String realm;

    public String getId() {
        return HttpDigestAuthentication.class.getName();
    }

    public AuthenticationResult getAuthenticationResult(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException, AccountLockedException, MustChangePasswordException {
        HttpSession session = request.getSession();
        if (this.isAlreadyAuthenticated(session)) {
            return this.getSecuritySession(session).getAuthenticationResult();
        }
        TokenBasedAuthenticationDataSource authDataSource = new TokenBasedAuthenticationDataSource();
        String authHeader = request.getHeader("Authorization");
        if (authHeader == null) {
            authHeader = request.getHeader("authorization");
        }
        if (authHeader != null && authHeader.startsWith("Digest ")) {
            String rawDigestHeader = authHeader.substring(7);
            HttpDigestHeader digestHeader = new HttpDigestHeader();
            digestHeader.parseClientHeader(rawDigestHeader, this.getRealm(), this.digestKey);
            User user = this.findUser(digestHeader.username);
            authDataSource.setPrincipal(user.getPrincipal().toString());
            String serverSideHash = this.generateDigestHash(digestHeader, user.getPassword(), request.getMethod());
            if (!StringUtils.equals((String)serverSideHash, (String)digestHeader.response)) {
                throw new HttpAuthenticationException("Digest response was invalid.");
            }
        }
        return super.authenticate((AuthenticationDataSource)authDataSource, session);
    }

    public User findUser(String username) throws HttpAuthenticationException {
        try {
            return this.userManager.findUser(username);
        }
        catch (UserNotFoundException e) {
            String msg = "Unable to find primary user '" + username + "'.";
            this.log.error(msg, (Throwable)e);
            throw new HttpAuthenticationException(msg, e);
        }
    }

    public void challenge(HttpServletRequest request, HttpServletResponse response, String realmName, AuthenticationException exception) throws IOException {
        StringBuffer authHeader = new StringBuffer();
        authHeader.append("Digest ");
        authHeader.append("realm=\"").append(realmName).append("\"");
        authHeader.append(", nonce=\"");
        long timestamp = System.currentTimeMillis() + (long)(this.nonceLifetimeSeconds * 1000);
        String hraw = String.valueOf(timestamp) + ":" + this.digestKey;
        String rawnonce = String.valueOf(timestamp) + ":" + Digest.md5Hex(hraw);
        authHeader.append(Base64.encodeBase64((byte[])rawnonce.getBytes()));
        authHeader.append("\"");
        authHeader.append(", qop=\"auth\"");
        if (exception instanceof NonceExpirationException) {
            authHeader.append(", stale=\"true\"");
        }
        response.addHeader("WWW-Authenticate", authHeader.toString());
        response.sendError(401, exception.getMessage());
    }

    private String generateDigestHash(HttpDigestHeader digestHeader, String password, String httpMethod) {
        String digest;
        String a1 = Digest.md5Hex(digestHeader.username + ":" + this.realm + ":" + password);
        String a2 = Digest.md5Hex(httpMethod + ":" + digestHeader.uri);
        if (StringUtils.isEmpty((String)digestHeader.qop)) {
            digest = a1 + ":" + digestHeader.nonce + ":" + a2;
        } else if (StringUtils.equals((String)"auth", (String)digestHeader.qop)) {
            digest = a1 + ":" + digestHeader.nonce + ":" + digestHeader.nc + ":" + digestHeader.cnonce + ":" + digestHeader.qop + ":" + a2;
        } else {
            throw new IllegalStateException("Http Digest Parameter [qop] with value of [" + digestHeader.qop + "] is unsupported.");
        }
        return Digest.md5Hex(digest);
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }
}

