/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.redback.http.authentication.digest;

import java.util.Properties;
import org.codehaus.plexus.redback.http.HttpUtils;
import org.codehaus.plexus.redback.http.authentication.HttpAuthenticationException;
import org.codehaus.plexus.redback.http.authentication.digest.Digest;
import org.codehaus.plexus.util.Base64;
import org.codehaus.plexus.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service(value="httpClientHeader")
@Scope(value="protype")
class HttpDigestHeader {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    public String username;
    public String realm;
    public String nonce;
    public String uri;
    public String response;
    public String qop;
    public String nc;
    public String cnonce;

    HttpDigestHeader() {
    }

    public void parseClientHeader(String rawHeader, String expectedRealm, String digestKey) throws HttpAuthenticationException {
        Properties authHeaderProps = HttpUtils.complexHeaderToProperties(rawHeader, ",", "=");
        this.username = authHeaderProps.getProperty("username");
        this.realm = authHeaderProps.getProperty("realm");
        this.nonce = authHeaderProps.getProperty("nonce");
        this.uri = authHeaderProps.getProperty("uri");
        this.response = authHeaderProps.getProperty("response");
        this.qop = authHeaderProps.getProperty("qop");
        this.nc = authHeaderProps.getProperty("nc");
        this.cnonce = authHeaderProps.getProperty("cnonce");
        if (StringUtils.isEmpty((String)this.username) || StringUtils.isEmpty((String)this.realm) || StringUtils.isEmpty((String)this.nonce) || StringUtils.isEmpty((String)this.uri) || StringUtils.isEmpty((String)this.response)) {
            this.log.debug("Missing mandatory fields: Raw Digest Header : [" + rawHeader + "]");
            throw new HttpAuthenticationException("Missing mandatory digest fields per RFC2069.");
        }
        if (!StringUtils.equals((String)expectedRealm, (String)this.realm)) {
            this.log.debug("Realm name is invalid: expected [" + expectedRealm + "] but got [" + this.realm + "]");
            throw new HttpAuthenticationException("Response realm does not match expected realm.");
        }
        if (StringUtils.equals((String)"auth", (String)this.qop) && (StringUtils.isEmpty((String)this.nc) || StringUtils.isEmpty((String)this.cnonce))) {
            this.log.debug("Missing mandatory qop fields: nc [" + this.nc + "] cnonce [" + this.cnonce + "]");
            throw new HttpAuthenticationException("Missing mandatory qop digest fields per RFC2617.");
        }
        if (!Base64.isArrayByteBase64((byte[])this.nonce.getBytes())) {
            this.log.debug("Nonce is not encoded in Base64: nonce [" + this.nonce + "]");
            throw new HttpAuthenticationException("Response nonce is not encoded in Base64.");
        }
        String decodedNonce = new String(Base64.decodeBase64((byte[])this.nonce.getBytes()));
        String[] nonceTokens = StringUtils.split((String)decodedNonce, (String)":");
        if (nonceTokens.length != 2) {
            this.log.debug("Nonce format expected [2] elements, but got [" + nonceTokens.length + "] instead.  Decoded nonce [" + decodedNonce + "]");
            throw new HttpAuthenticationException("Nonce format is invalid.  Received an unexpected number of sub elements.");
        }
        long nonceTimestamp = 0L;
        try {
            nonceTimestamp = Long.parseLong(nonceTokens[0]);
        }
        catch (NumberFormatException e) {
            throw new HttpAuthenticationException("Unexpected nonce timestamp.");
        }
        String expectedSignature = Digest.md5Hex(nonceTimestamp + ":" + digestKey);
        if (!StringUtils.equals((String)expectedSignature, (String)nonceTokens[1])) {
            this.log.error("Nonce parameter has been compromised.");
            throw new HttpAuthenticationException("Nonce parameter has been compromised.");
        }
    }
}

