/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.redback.rbac.cached;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.ehcache.Element;
import org.codehaus.plexus.ehcache.EhcacheComponent;
import org.codehaus.plexus.ehcache.EhcacheUtils;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.redback.rbac.Operation;
import org.codehaus.plexus.redback.rbac.Permission;
import org.codehaus.plexus.redback.rbac.RBACManager;
import org.codehaus.plexus.redback.rbac.RBACManagerListener;
import org.codehaus.plexus.redback.rbac.RbacManagerException;
import org.codehaus.plexus.redback.rbac.RbacObjectInvalidException;
import org.codehaus.plexus.redback.rbac.RbacObjectNotFoundException;
import org.codehaus.plexus.redback.rbac.Resource;
import org.codehaus.plexus.redback.rbac.Role;
import org.codehaus.plexus.redback.rbac.UserAssignment;

public class CachedRbacManager
extends AbstractLogEnabled
implements RBACManager,
RBACManagerListener {
    private RBACManager rbacImpl;
    private EhcacheComponent operationsCache;
    private EhcacheComponent permissionsCache;
    private EhcacheComponent resourcesCache;
    private EhcacheComponent rolesCache;
    private EhcacheComponent userAssignmentsCache;
    private EhcacheComponent userPermissionsCache;
    private EhcacheComponent effectiveRoleSetCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChildRole(Role role, Role childRole) throws RbacObjectInvalidException, RbacManagerException {
        try {
            this.rbacImpl.addChildRole(role, childRole);
        }
        finally {
            this.invalidateCachedRole(role);
            this.invalidateCachedRole(childRole);
        }
    }

    public void addListener(RBACManagerListener listener) {
        this.rbacImpl.addListener(listener);
    }

    public Operation createOperation(String name) throws RbacManagerException {
        this.operationsCache.invalidateKey((Object)name);
        return this.rbacImpl.createOperation(name);
    }

    public Permission createPermission(String name) throws RbacManagerException {
        this.permissionsCache.invalidateKey((Object)name);
        return this.rbacImpl.createPermission(name);
    }

    public Permission createPermission(String name, String operationName, String resourceIdentifier) throws RbacManagerException {
        this.permissionsCache.invalidateKey((Object)name);
        return this.rbacImpl.createPermission(name, operationName, resourceIdentifier);
    }

    public Resource createResource(String identifier) throws RbacManagerException {
        this.resourcesCache.invalidateKey((Object)identifier);
        return this.rbacImpl.createResource(identifier);
    }

    public Role createRole(String name) {
        this.rolesCache.invalidateKey((Object)name);
        return this.rbacImpl.createRole(name);
    }

    public UserAssignment createUserAssignment(String principal) throws RbacManagerException {
        this.invalidateCachedUserAssignment(principal);
        return this.rbacImpl.createUserAssignment(principal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eraseDatabase() {
        try {
            this.rbacImpl.eraseDatabase();
        }
        finally {
            EhcacheUtils.clearAllCaches((Logger)this.getLogger());
        }
    }

    public List getAllAssignableRoles() throws RbacManagerException, RbacObjectNotFoundException {
        this.getLogger().debug("NOT CACHED - .getAllAssignableRoles()");
        return this.rbacImpl.getAllAssignableRoles();
    }

    public List getAllOperations() throws RbacManagerException {
        this.getLogger().debug("NOT CACHED - .getAllOperations()");
        return this.rbacImpl.getAllOperations();
    }

    public List getAllPermissions() throws RbacManagerException {
        this.getLogger().debug("NOT CACHED - .getAllPermissions()");
        return this.rbacImpl.getAllPermissions();
    }

    public List getAllResources() throws RbacManagerException {
        this.getLogger().debug("NOT CACHED - .getAllResources()");
        return this.rbacImpl.getAllResources();
    }

    public List getAllRoles() throws RbacManagerException {
        this.getLogger().debug("NOT CACHED - .getAllRoles()");
        return this.rbacImpl.getAllRoles();
    }

    public List getAllUserAssignments() throws RbacManagerException {
        this.getLogger().debug("NOT CACHED - .getAllUserAssignments()");
        return this.rbacImpl.getAllUserAssignments();
    }

    public Map getAssignedPermissionMap(String principal) throws RbacObjectNotFoundException, RbacManagerException {
        Element el = this.userPermissionsCache.getElement((Object)principal);
        if (el != null) {
            return (Map)el.getObjectValue();
        }
        this.getLogger().debug("building user permission map");
        Map userPermMap = this.rbacImpl.getAssignedPermissionMap(principal);
        this.userPermissionsCache.putElement(new Element((Object)principal, (Object)userPermMap));
        return userPermMap;
    }

    public Set getAssignedPermissions(String principal) throws RbacObjectNotFoundException, RbacManagerException {
        this.getLogger().debug("NOT CACHED - .getAssignedPermissions(String)");
        return this.rbacImpl.getAssignedPermissions(principal);
    }

    public Collection getAssignedRoles(String principal) throws RbacObjectNotFoundException, RbacManagerException {
        this.getLogger().debug("NOT CACHED - .getAssignedRoles(String)");
        return this.rbacImpl.getAssignedRoles(principal);
    }

    public Collection getAssignedRoles(UserAssignment userAssignment) throws RbacObjectNotFoundException, RbacManagerException {
        this.getLogger().debug("NOT CACHED - .getAssignedRoles(UserAssignment)");
        return this.rbacImpl.getAssignedRoles(userAssignment);
    }

    public Map getChildRoles(Role role) throws RbacManagerException {
        this.getLogger().debug("NOT CACHED - .getChildRoles(Role)");
        return this.rbacImpl.getChildRoles(role);
    }

    public Map getParentRoles(Role role) throws RbacManagerException {
        this.getLogger().debug("NOT CACHED - .getParentRoles(Role)");
        return this.rbacImpl.getParentRoles(role);
    }

    public Collection getEffectivelyAssignedRoles(String principal) throws RbacObjectNotFoundException, RbacManagerException {
        this.getLogger().debug("NOT CACHED - .getEffectivelyAssignedRoles(String)");
        return this.rbacImpl.getEffectivelyAssignedRoles(principal);
    }

    public Collection getEffectivelyUnassignedRoles(String principal) throws RbacManagerException, RbacObjectNotFoundException {
        this.getLogger().debug("NOT CACHED - .getEffectivelyUnassignedRoles(String)");
        return this.rbacImpl.getEffectivelyUnassignedRoles(principal);
    }

    public Set getEffectiveRoles(Role role) throws RbacObjectNotFoundException, RbacManagerException {
        Element el = this.effectiveRoleSetCache.getElement((Object)role.getName());
        if (el != null) {
            this.getLogger().debug("using cached effective role set");
            return (Set)el.getObjectValue();
        }
        this.getLogger().debug("building effective role set");
        Set effectiveRoleSet = this.rbacImpl.getEffectiveRoles(role);
        this.effectiveRoleSetCache.putElement(new Element((Object)role.getName(), (Object)effectiveRoleSet));
        return effectiveRoleSet;
    }

    public Resource getGlobalResource() throws RbacManagerException {
        this.getLogger().debug("NOT CACHED - .getGlobalResource()");
        return this.rbacImpl.getGlobalResource();
    }

    public Operation getOperation(String operationName) throws RbacObjectNotFoundException, RbacManagerException {
        Element el = this.operationsCache.getElement((Object)operationName);
        if (el != null) {
            return (Operation)el.getObjectValue();
        }
        Operation operation = this.rbacImpl.getOperation(operationName);
        this.operationsCache.putElement(new Element((Object)operationName, (Object)operation));
        return operation;
    }

    public Permission getPermission(String permissionName) throws RbacObjectNotFoundException, RbacManagerException {
        Element el = this.permissionsCache.getElement((Object)permissionName);
        if (el != null) {
            return (Permission)el.getObjectValue();
        }
        Permission permission = this.rbacImpl.getPermission(permissionName);
        this.permissionsCache.putElement(new Element((Object)permissionName, (Object)permission));
        return permission;
    }

    public Resource getResource(String resourceIdentifier) throws RbacObjectNotFoundException, RbacManagerException {
        Element el = this.resourcesCache.getElement((Object)resourceIdentifier);
        if (el != null) {
            return (Resource)el.getObjectValue();
        }
        Resource resource = this.rbacImpl.getResource(resourceIdentifier);
        this.resourcesCache.putElement(new Element((Object)resourceIdentifier, (Object)resource));
        return resource;
    }

    public Role getRole(String roleName) throws RbacObjectNotFoundException, RbacManagerException {
        Element el = this.rolesCache.getElement((Object)roleName);
        if (el != null) {
            return (Role)el.getObjectValue();
        }
        Role role = this.rbacImpl.getRole(roleName);
        this.rolesCache.putElement(new Element((Object)roleName, (Object)role));
        return role;
    }

    public Map getRoles(Collection roleNames) throws RbacObjectNotFoundException, RbacManagerException {
        this.getLogger().debug("NOT CACHED - .getRoles(Collection)");
        return this.rbacImpl.getRoles(roleNames);
    }

    public Collection getUnassignedRoles(String principal) throws RbacManagerException, RbacObjectNotFoundException {
        this.getLogger().debug("NOT CACHED - .getUnassignedRoles(String)");
        return this.rbacImpl.getUnassignedRoles(principal);
    }

    public UserAssignment getUserAssignment(String principal) throws RbacObjectNotFoundException, RbacManagerException {
        Element el = this.userAssignmentsCache.getElement((Object)principal);
        if (el != null) {
            return (UserAssignment)el.getObjectValue();
        }
        UserAssignment userAssignment = this.rbacImpl.getUserAssignment(principal);
        this.userAssignmentsCache.putElement(new Element((Object)principal, (Object)userAssignment));
        return userAssignment;
    }

    public List getUserAssignmentsForRoles(Collection roleNames) throws RbacManagerException {
        this.getLogger().debug("NOT CACHED - .getUserAssignmentsForRoles(Collection)");
        return this.rbacImpl.getUserAssignmentsForRoles(roleNames);
    }

    public boolean operationExists(Operation operation) {
        if (operation == null) {
            return false;
        }
        if (this.operationsCache.hasKey((Object)operation.getName())) {
            return true;
        }
        return this.rbacImpl.operationExists(operation);
    }

    public boolean operationExists(String name) {
        if (this.operationsCache.hasKey((Object)name)) {
            return true;
        }
        return this.rbacImpl.operationExists(name);
    }

    public boolean permissionExists(Permission permission) {
        if (permission == null) {
            return false;
        }
        if (this.permissionsCache.hasKey((Object)permission.getName())) {
            return true;
        }
        return this.rbacImpl.permissionExists(permission);
    }

    public boolean permissionExists(String name) {
        if (this.permissionsCache.hasKey((Object)name)) {
            return true;
        }
        return this.rbacImpl.permissionExists(name);
    }

    public void rbacInit(boolean freshdb) {
        if (this.rbacImpl instanceof RBACManagerListener) {
            ((RBACManagerListener)this.rbacImpl).rbacInit(freshdb);
        }
        EhcacheUtils.clearAllCaches((Logger)this.getLogger());
    }

    public void rbacPermissionRemoved(Permission permission) {
        if (this.rbacImpl instanceof RBACManagerListener) {
            ((RBACManagerListener)this.rbacImpl).rbacPermissionRemoved(permission);
        }
        this.invalidateCachedPermission(permission);
    }

    public void rbacPermissionSaved(Permission permission) {
        if (this.rbacImpl instanceof RBACManagerListener) {
            ((RBACManagerListener)this.rbacImpl).rbacPermissionSaved(permission);
        }
        this.invalidateCachedPermission(permission);
    }

    public void rbacRoleRemoved(Role role) {
        if (this.rbacImpl instanceof RBACManagerListener) {
            ((RBACManagerListener)this.rbacImpl).rbacRoleRemoved(role);
        }
        this.invalidateCachedRole(role);
    }

    public void rbacRoleSaved(Role role) {
        if (this.rbacImpl instanceof RBACManagerListener) {
            ((RBACManagerListener)this.rbacImpl).rbacRoleSaved(role);
        }
        this.invalidateCachedRole(role);
    }

    public void rbacUserAssignmentRemoved(UserAssignment userAssignment) {
        if (this.rbacImpl instanceof RBACManagerListener) {
            ((RBACManagerListener)this.rbacImpl).rbacUserAssignmentRemoved(userAssignment);
        }
        this.invalidateCachedUserAssignment(userAssignment);
    }

    public void rbacUserAssignmentSaved(UserAssignment userAssignment) {
        if (this.rbacImpl instanceof RBACManagerListener) {
            ((RBACManagerListener)this.rbacImpl).rbacUserAssignmentSaved(userAssignment);
        }
        this.invalidateCachedUserAssignment(userAssignment);
    }

    public void removeListener(RBACManagerListener listener) {
        this.rbacImpl.removeListener(listener);
    }

    public void removeOperation(Operation operation) throws RbacObjectNotFoundException, RbacObjectInvalidException, RbacManagerException {
        this.invalidateCachedOperation(operation);
        this.rbacImpl.removeOperation(operation);
    }

    public void removeOperation(String operationName) throws RbacObjectNotFoundException, RbacObjectInvalidException, RbacManagerException {
        this.operationsCache.invalidateKey((Object)operationName);
        this.rbacImpl.removeOperation(operationName);
    }

    public void removePermission(Permission permission) throws RbacObjectNotFoundException, RbacObjectInvalidException, RbacManagerException {
        this.invalidateCachedPermission(permission);
        this.rbacImpl.removePermission(permission);
    }

    public void removePermission(String permissionName) throws RbacObjectNotFoundException, RbacObjectInvalidException, RbacManagerException {
        this.permissionsCache.invalidateKey((Object)permissionName);
        this.rbacImpl.removePermission(permissionName);
    }

    public void removeResource(Resource resource) throws RbacObjectNotFoundException, RbacObjectInvalidException, RbacManagerException {
        this.invalidateCachedResource(resource);
        this.rbacImpl.removeResource(resource);
    }

    public void removeResource(String resourceIdentifier) throws RbacObjectNotFoundException, RbacObjectInvalidException, RbacManagerException {
        this.resourcesCache.invalidateKey((Object)resourceIdentifier);
        this.rbacImpl.removeResource(resourceIdentifier);
    }

    public void removeRole(Role role) throws RbacObjectNotFoundException, RbacObjectInvalidException, RbacManagerException {
        this.invalidateCachedRole(role);
        this.rbacImpl.removeRole(role);
    }

    public void removeRole(String roleName) throws RbacObjectNotFoundException, RbacObjectInvalidException, RbacManagerException {
        this.rolesCache.invalidateKey((Object)roleName);
        this.rbacImpl.removeRole(roleName);
    }

    public void removeUserAssignment(String principal) throws RbacObjectNotFoundException, RbacObjectInvalidException, RbacManagerException {
        this.invalidateCachedUserAssignment(principal);
        this.rbacImpl.removeUserAssignment(principal);
    }

    public void removeUserAssignment(UserAssignment userAssignment) throws RbacObjectNotFoundException, RbacObjectInvalidException, RbacManagerException {
        this.invalidateCachedUserAssignment(userAssignment);
        this.rbacImpl.removeUserAssignment(userAssignment);
    }

    public boolean resourceExists(Resource resource) {
        if (this.resourcesCache.hasKey((Object)resource.getIdentifier())) {
            return true;
        }
        return this.rbacImpl.resourceExists(resource);
    }

    public boolean resourceExists(String identifier) {
        if (this.resourcesCache.hasKey((Object)identifier)) {
            return true;
        }
        return this.rbacImpl.resourceExists(identifier);
    }

    public boolean roleExists(Role role) {
        if (this.rolesCache.hasKey((Object)role.getName())) {
            return true;
        }
        return this.rbacImpl.roleExists(role);
    }

    public boolean roleExists(String name) {
        if (this.rolesCache.hasKey((Object)name)) {
            return true;
        }
        return this.rbacImpl.roleExists(name);
    }

    public Operation saveOperation(Operation operation) throws RbacObjectInvalidException, RbacManagerException {
        this.invalidateCachedOperation(operation);
        return this.rbacImpl.saveOperation(operation);
    }

    public Permission savePermission(Permission permission) throws RbacObjectInvalidException, RbacManagerException {
        this.invalidateCachedPermission(permission);
        return this.rbacImpl.savePermission(permission);
    }

    public Resource saveResource(Resource resource) throws RbacObjectInvalidException, RbacManagerException {
        this.invalidateCachedResource(resource);
        return this.rbacImpl.saveResource(resource);
    }

    public Role saveRole(Role role) throws RbacObjectInvalidException, RbacManagerException {
        this.invalidateAllCachedUserAssignments();
        this.invalidateCachedRole(role);
        return this.rbacImpl.saveRole(role);
    }

    public void saveRoles(Collection roles) throws RbacObjectInvalidException, RbacManagerException {
        for (Role role : roles) {
            this.invalidateCachedRole(role);
        }
        this.invalidateAllCachedUserAssignments();
        this.rbacImpl.saveRoles(roles);
    }

    public UserAssignment saveUserAssignment(UserAssignment userAssignment) throws RbacObjectInvalidException, RbacManagerException {
        this.invalidateCachedUserAssignment(userAssignment);
        return this.rbacImpl.saveUserAssignment(userAssignment);
    }

    public boolean userAssignmentExists(String principal) {
        if (this.userAssignmentsCache.hasKey((Object)principal)) {
            return true;
        }
        return this.rbacImpl.userAssignmentExists(principal);
    }

    public boolean userAssignmentExists(UserAssignment assignment) {
        if (this.userAssignmentsCache.hasKey((Object)assignment.getPrincipal())) {
            return true;
        }
        return this.rbacImpl.userAssignmentExists(assignment);
    }

    private void invalidateCachedRole(Role role) {
        if (role != null) {
            this.rolesCache.invalidateKey((Object)role.getName());
            this.effectiveRoleSetCache.getCache().removeAll();
        }
    }

    private void invalidateCachedOperation(Operation operation) {
        if (operation != null) {
            this.operationsCache.invalidateKey((Object)operation.getName());
        }
    }

    private void invalidateCachedPermission(Permission permission) {
        if (permission != null) {
            this.permissionsCache.invalidateKey((Object)permission.getName());
        }
    }

    private void invalidateCachedResource(Resource resource) {
        if (resource != null) {
            this.resourcesCache.invalidateKey((Object)resource.getIdentifier());
        }
    }

    private void invalidateCachedUserAssignment(UserAssignment userAssignment) {
        if (userAssignment != null) {
            this.userAssignmentsCache.invalidateKey((Object)userAssignment.getPrincipal());
            this.userPermissionsCache.invalidateKey((Object)userAssignment.getPrincipal());
        }
    }

    private void invalidateCachedUserAssignment(String principal) {
        this.userAssignmentsCache.invalidateKey((Object)principal);
        this.userPermissionsCache.invalidateKey((Object)principal);
    }

    private void invalidateAllCachedUserAssignments() {
        this.userAssignmentsCache.getCache().removeAll();
        this.userPermissionsCache.getCache().removeAll();
    }
}

