/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.redback.struts2.action.admin;

import java.util.Arrays;
import java.util.Date;
import org.apache.struts2.ServletActionContext;
import org.codehaus.plexus.redback.authentication.AuthenticationDataSource;
import org.codehaus.plexus.redback.authentication.AuthenticationException;
import org.codehaus.plexus.redback.authentication.AuthenticationResult;
import org.codehaus.plexus.redback.authentication.PasswordBasedAuthenticationDataSource;
import org.codehaus.plexus.redback.configuration.UserConfiguration;
import org.codehaus.plexus.redback.policy.AccountLockedException;
import org.codehaus.plexus.redback.policy.MustChangePasswordException;
import org.codehaus.plexus.redback.role.RoleManager;
import org.codehaus.plexus.redback.role.RoleManagerException;
import org.codehaus.plexus.redback.struts2.action.AuditEvent;
import org.codehaus.plexus.redback.struts2.action.admin.AbstractAdminUserCredentialsAction;
import org.codehaus.plexus.redback.system.SecuritySession;
import org.codehaus.plexus.redback.users.User;
import org.codehaus.plexus.redback.users.UserManager;
import org.codehaus.plexus.redback.users.UserNotFoundException;
import org.codehaus.redback.integration.interceptor.SecureActionBundle;
import org.codehaus.redback.integration.interceptor.SecureActionException;
import org.codehaus.redback.integration.model.EditUserCredentials;
import org.codehaus.redback.integration.util.AutoLoginCookies;

public class AddAdminUserAction
extends AbstractAdminUserCredentialsAction {
    private static final String LOGIN_ERROR = "login-error";
    private static final String LOGIN_SUCCESS = "security-login-success";
    private static final String PASSWORD_CHANGE = "security-must-change-password";
    private static final String ACCOUNT_LOCKED = "security-login-locked";
    private RoleManager roleManager;
    private UserConfiguration config;
    private EditUserCredentials user;
    private AutoLoginCookies autologinCookies;

    public String show() {
        if (this.user == null) {
            this.user = new EditUserCredentials(this.config.getString("redback.default.admin"));
        }
        return "input";
    }

    public String submit() {
        if (this.user == null) {
            this.user = new EditUserCredentials(this.config.getString("redback.default.admin"));
            this.addActionError(this.getText("invalid.admin.credentials"));
            return "error";
        }
        this.log.info("user = " + this.user);
        this.internalUser = this.user;
        this.validateCredentialsStrict();
        UserManager userManager = this.securitySystem.getUserManager();
        if (userManager.userExists((Object)this.config.getString("redback.default.admin"))) {
            this.addActionError(this.getText("admin.user.already.exists"));
            return "error";
        }
        if (this.hasActionErrors() || this.hasFieldErrors()) {
            return "error";
        }
        User u = userManager.createUser(this.config.getString("redback.default.admin"), this.user.getFullName(), this.user.getEmail());
        if (u == null) {
            this.addActionError(this.getText("cannot.operate.on.null.user"));
            return "error";
        }
        u.setPassword(this.user.getPassword());
        u.setLocked(false);
        u.setPasswordChangeRequired(false);
        u.setPermanent(true);
        userManager.addUser(u);
        AuditEvent event = new AuditEvent(this.getText("log.account.create"));
        event.setAffectedUser(u.getUsername());
        event.log();
        try {
            this.roleManager.assignRole("system-administrator", u.getPrincipal().toString());
            event = new AuditEvent(this.getText("log.assign.role"));
            event.setAffectedUser(u.getUsername());
            event.setRole("system-administrator");
            event.log();
        }
        catch (RoleManagerException rpe) {
            this.addActionError(this.getText("cannot.assign.admin.role"));
            return "error";
        }
        PasswordBasedAuthenticationDataSource authdatasource = new PasswordBasedAuthenticationDataSource();
        authdatasource.setPrincipal(this.user.getUsername());
        authdatasource.setPassword(this.user.getPassword());
        return this.webLogin((AuthenticationDataSource)authdatasource);
    }

    public EditUserCredentials getUser() {
        return this.user;
    }

    public void setUser(EditUserCredentials user) {
        this.user = user;
    }

    public SecureActionBundle initSecureActionBundle() throws SecureActionException {
        return SecureActionBundle.OPEN;
    }

    private String webLogin(AuthenticationDataSource authdatasource) {
        this.setAuthTokens(null);
        this.clearErrorsAndMessages();
        String principal = authdatasource.getPrincipal();
        try {
            SecuritySession securitySession = this.securitySystem.authenticate(authdatasource);
            if (securitySession.getAuthenticationResult().isAuthenticated()) {
                this.setAuthTokens(securitySession);
                this.setCookies(authdatasource);
                AuditEvent event = new AuditEvent(this.getText("log.login.success"));
                event.setAffectedUser(principal);
                event.log();
                User u = securitySession.getUser();
                u.setLastLoginDate(new Date());
                this.securitySystem.getUserManager().updateUser(u);
                return LOGIN_SUCCESS;
            }
            this.log.debug("Login Action failed against principal : " + securitySession.getAuthenticationResult().getPrincipal(), (Throwable)securitySession.getAuthenticationResult().getException());
            AuthenticationResult result = securitySession.getAuthenticationResult();
            if (result.getExceptionsMap() != null && !result.getExceptionsMap().isEmpty()) {
                if (result.getExceptionsMap().get("1") != null) {
                    this.addActionError(this.getText("incorrect.username.password"));
                } else {
                    this.addActionError(this.getText("authentication.failed"));
                }
            } else {
                this.addActionError(this.getText("authentication.failed"));
            }
            AuditEvent event = new AuditEvent(this.getText("log.login.fail"));
            event.setAffectedUser(principal);
            event.log();
            return LOGIN_ERROR;
        }
        catch (AuthenticationException ae) {
            this.addActionError(this.getText("authentication.exception", Arrays.asList(ae.getMessage())));
            return LOGIN_ERROR;
        }
        catch (UserNotFoundException ue) {
            this.addActionError(this.getText("user.not.found.exception", Arrays.asList(principal, ue.getMessage())));
            AuditEvent event = new AuditEvent(this.getText("log.login.fail"));
            event.setAffectedUser(principal);
            event.log();
            return LOGIN_ERROR;
        }
        catch (AccountLockedException e) {
            this.addActionError(this.getText("account.locked"));
            AuditEvent event = new AuditEvent(this.getText("log.login.fail.locked"));
            event.setAffectedUser(principal);
            event.log();
            return ACCOUNT_LOCKED;
        }
        catch (MustChangePasswordException e) {
            this.setCookies(authdatasource);
            AuditEvent event = new AuditEvent(this.getText("log.login.fail.locked"));
            event.setAffectedUser(principal);
            event.log();
            return PASSWORD_CHANGE;
        }
    }

    private void setCookies(AuthenticationDataSource authdatasource) {
        this.autologinCookies.setSignonCookie(authdatasource.getPrincipal(), ServletActionContext.getResponse(), ServletActionContext.getRequest());
    }
}

