/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.redback.struts2.action.admin;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.codehaus.plexus.redback.rbac.Operation;
import org.codehaus.plexus.redback.rbac.RBACManager;
import org.codehaus.plexus.redback.rbac.RbacManagerException;
import org.codehaus.plexus.redback.struts2.action.RedbackActionSupport;
import org.codehaus.redback.integration.interceptor.SecureActionBundle;
import org.codehaus.redback.integration.interceptor.SecureActionException;
import org.codehaus.redback.integration.util.OperationSorter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationsAction
extends RedbackActionSupport {
    private static final String LIST = "list";
    private RBACManager manager;
    private String operationName;
    private String description;
    private List<Operation> allOperations;

    public String list() {
        try {
            this.allOperations = this.manager.getAllOperations();
            if (this.allOperations == null) {
                this.allOperations = Collections.emptyList();
            }
            Collections.sort(this.allOperations, new OperationSorter());
        }
        catch (RbacManagerException e) {
            this.addActionError(this.getText("cannot.list.all.operations", Arrays.asList(e.getMessage())));
            this.log.error("System error:", (Throwable)e);
            this.allOperations = Collections.emptyList();
        }
        return LIST;
    }

    public String save() {
        try {
            Operation temp = this.manager.createOperation(this.operationName);
            temp.setDescription(this.description);
            this.manager.saveOperation(temp);
        }
        catch (RbacManagerException e) {
            this.addActionError(this.getText("cannot.save.operation", Arrays.asList(this.operationName)));
            this.log.error("System error:", (Throwable)e);
            this.allOperations = Collections.emptyList();
        }
        return LIST;
    }

    public String remove() {
        try {
            this.manager.removeOperation(this.manager.getOperation(this.operationName));
        }
        catch (RbacManagerException ne) {
            this.addActionError(this.getText("cannot.remove.operation", Arrays.asList(this.operationName)));
            return "error";
        }
        return LIST;
    }

    public List<Operation> getAllOperations() {
        return this.allOperations;
    }

    public void setAllOperations(List<Operation> allOperations) {
        this.allOperations = allOperations;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public void setOperationName(String operationName) {
        this.operationName = operationName;
    }

    public SecureActionBundle initSecureActionBundle() throws SecureActionException {
        SecureActionBundle bundle = new SecureActionBundle();
        bundle.setRequiresAuthentication(true);
        bundle.addRequiredAuthorization("user-management-rbac-admin", "*");
        return bundle;
    }
}

