/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.redback.struts2.action.admin;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.codehaus.plexus.redback.rbac.Operation;
import org.codehaus.plexus.redback.rbac.Permission;
import org.codehaus.plexus.redback.rbac.RBACManager;
import org.codehaus.plexus.redback.rbac.RbacManagerException;
import org.codehaus.plexus.redback.rbac.Resource;
import org.codehaus.plexus.redback.struts2.action.RedbackActionSupport;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.redback.integration.interceptor.SecureActionBundle;
import org.codehaus.redback.integration.interceptor.SecureActionException;
import org.codehaus.redback.integration.util.PermissionSorter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PermissionsAction
extends RedbackActionSupport {
    private static final String LIST = "list";
    private RBACManager manager;
    private String name;
    private String description;
    private String operationName;
    private String operationDescription;
    private String resourceIdentifier;
    private List<Permission> allPermissions;

    public String list() {
        try {
            this.allPermissions = this.manager.getAllPermissions();
            if (this.allPermissions == null) {
                this.allPermissions = Collections.emptyList();
            }
            Collections.sort(this.allPermissions, new PermissionSorter());
        }
        catch (RbacManagerException e) {
            this.addActionError(this.getText("cannot.list.all.permissions", Arrays.asList(e.getMessage())));
            this.log.error("System error:", (Throwable)e);
            this.allPermissions = Collections.emptyList();
        }
        return LIST;
    }

    public String input() {
        if (this.name == null) {
            this.addActionError(this.getText("cannot.edit.null.permission"));
            return "error";
        }
        if (StringUtils.isEmpty((String)this.name)) {
            this.addActionError(this.getText("cannot.edit.empty.permission"));
            return "error";
        }
        if (!this.manager.permissionExists(this.name)) {
            return LIST;
        }
        try {
            Resource resource;
            Permission permission = this.manager.getPermission(this.name);
            if (permission == null) {
                this.addActionError(this.getText("cannot.operate.null.permission"));
                return "error";
            }
            this.description = permission.getDescription();
            Operation operation = permission.getOperation();
            if (operation != null) {
                this.operationName = operation.getName();
                this.operationDescription = operation.getDescription();
            }
            if ((resource = permission.getResource()) != null) {
                this.resourceIdentifier = resource.getIdentifier();
            }
        }
        catch (RbacManagerException e) {
            this.addActionError(this.getText("cannot.get.permission", Arrays.asList(this.name, e.getMessage())));
            return "error";
        }
        return LIST;
    }

    public String submit() {
        if (this.name == null) {
            this.addActionError(this.getText("cannot.edit.null.permission"));
            return "error";
        }
        if (StringUtils.isEmpty((String)this.name)) {
            this.addActionError(this.getText("cannot.edit.empty.permission"));
            return "error";
        }
        try {
            Permission permission = this.manager.permissionExists(this.name) ? this.manager.getPermission(this.name) : this.manager.createPermission(this.name);
            permission.setDescription(this.description);
            Operation operation = this.manager.createOperation(this.operationName);
            if (StringUtils.isNotEmpty((String)this.operationDescription)) {
                operation.setDescription(this.operationDescription);
            }
            permission.setOperation(this.manager.saveOperation(operation));
            Resource resource = this.manager.createResource(this.resourceIdentifier);
            permission.setResource(this.manager.saveResource(resource));
            this.manager.savePermission(permission);
            this.addActionMessage(this.getText("save.permission.success", Arrays.asList(this.name)));
        }
        catch (RbacManagerException e) {
            this.addActionError(this.getText("cannot.get.permission", Arrays.asList(this.name, e.getMessage())));
            return "error";
        }
        return LIST;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getOperationDescription() {
        return this.operationDescription;
    }

    public void setOperationDescription(String operationDescription) {
        this.operationDescription = operationDescription;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public void setOperationName(String operationName) {
        this.operationName = operationName;
    }

    public String getResourceIdentifier() {
        return this.resourceIdentifier;
    }

    public void setResourceIdentifier(String resourceIdentifier) {
        this.resourceIdentifier = resourceIdentifier;
    }

    public List<Permission> getAllPermissions() {
        return this.allPermissions;
    }

    public void setAllPermissions(List<Permission> allPermissions) {
        this.allPermissions = allPermissions;
    }

    public SecureActionBundle initSecureActionBundle() throws SecureActionException {
        SecureActionBundle bundle = new SecureActionBundle();
        bundle.setRequiresAuthentication(true);
        bundle.addRequiredAuthorization("user-management-rbac-admin", "*");
        return bundle;
    }
}

