/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.redback.struts2.action.admin;

import java.util.Arrays;
import org.codehaus.plexus.redback.policy.UserSecurityPolicy;
import org.codehaus.plexus.redback.struts2.action.AbstractUserCredentialsAction;
import org.codehaus.plexus.redback.struts2.action.AuditEvent;
import org.codehaus.plexus.redback.users.User;
import org.codehaus.plexus.redback.users.UserManager;
import org.codehaus.redback.integration.interceptor.SecureActionBundle;
import org.codehaus.redback.integration.interceptor.SecureActionException;
import org.codehaus.redback.integration.model.CreateUserCredentials;

public class UserCreateAction
extends AbstractUserCredentialsAction {
    private CreateUserCredentials user;

    public String show() {
        if (this.user == null) {
            this.user = new CreateUserCredentials();
        }
        return "input";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String submit() {
        if (this.user == null) {
            this.user = new CreateUserCredentials();
            this.addActionError(this.getText("invalid.user.credentials"));
            return "error";
        }
        this.internalUser = this.user;
        this.validateCredentialsLoose();
        UserManager manager = this.securitySystem.getUserManager();
        if (manager.userExists((Object)this.user.getUsername())) {
            this.addActionError(this.getText("user.already.exists", Arrays.asList(this.user.getUsername())));
        }
        if (this.hasActionErrors() || this.hasFieldErrors()) {
            return "error";
        }
        User u = manager.createUser(this.user.getUsername(), this.user.getFullName(), this.user.getEmail());
        u.setPassword(this.user.getPassword());
        u.setPasswordChangeRequired(true);
        UserSecurityPolicy securityPolicy = this.securitySystem.getPolicy();
        try {
            securityPolicy.setEnabled(false);
            u.setValidated(true);
            manager.addUser(u);
            String currentUser = this.getCurrentUser();
            AuditEvent event = new AuditEvent(this.getText("log.account.create"));
            event.setAffectedUser(u.getUsername());
            event.setCurrentUser(currentUser);
            event.log();
        }
        finally {
            securityPolicy.setEnabled(true);
        }
        return "success";
    }

    public CreateUserCredentials getUser() {
        return this.user;
    }

    public void setUser(CreateUserCredentials user) {
        this.user = user;
    }

    public SecureActionBundle initSecureActionBundle() throws SecureActionException {
        SecureActionBundle bundle = new SecureActionBundle();
        bundle.setRequiresAuthentication(true);
        bundle.addRequiredAuthorization("user-management-user-create", "*");
        return bundle;
    }
}

