/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.redback.struts2.filter;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LruCache<T> {
    private final Map<T, T> cache;

    public LruCache(final int cacheSize) {
        this.cache = new LinkedHashMap<T, T>(){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<T, T> eldest) {
                return this.size() > cacheSize;
            }
        };
    }

    public void add(T key) {
        this.cache.put(key, null);
    }

    public boolean contains(T key) {
        return this.cache.containsKey(key);
    }

    public int getSize() {
        return this.cache.size();
    }

    public Set<T> getKeys() {
        return this.cache.keySet();
    }
}

