/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.redback.struts2.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.codehaus.plexus.redback.struts2.filter.LruCache;
import org.codehaus.plexus.redback.struts2.filter.RedbackCSRFResponseWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RedbackCSRFFilter
implements Filter {
    private Logger log = LoggerFactory.getLogger(RedbackCSRFFilter.class);
    private String randomClass;
    private Random randomizer;
    private int nonceCacheSize = 6;
    private List<String> excludedPaths = new ArrayList<String>();
    static final String CSRF_NONCE_SESSION_ATTR_NAME = "csrf_nonce_cache";
    static final String CSRF_NONCE_REQUEST_PARAM = "csrf_nonce";
    static final String PARAM_NONCE_CACHE_SIZE = "nonceCacheSize";
    static final String PARAM_RANDOM_CLASS = "randomClass";
    static final String PARAM_EXCLUDED_PATHS = "excludedPaths";
    static final String EXCLUDED_PATHS_SEPARATOR = ",";
    static final String HTTP_GET_METHOD = "GET";
    private static final Pattern extensionPattern = Pattern.compile("(\\.jpg$)|(\\.png$)|(\\.gif$)|(\\.css$)|(\\.js$)|(\\.ftl$)|(\\.ico$)", 2);

    public void init(FilterConfig filterConfig) throws ServletException {
        if (!StringUtils.isBlank((String)filterConfig.getInitParameter(PARAM_NONCE_CACHE_SIZE))) {
            this.nonceCacheSize = Integer.parseInt(filterConfig.getInitParameter(PARAM_NONCE_CACHE_SIZE));
        }
        if (!StringUtils.isBlank((String)filterConfig.getInitParameter(PARAM_EXCLUDED_PATHS))) {
            String[] urls = StringUtils.splitByWholeSeparator((String)filterConfig.getInitParameter(PARAM_EXCLUDED_PATHS), (String)EXCLUDED_PATHS_SEPARATOR);
            this.excludedPaths = new ArrayList<String>(Arrays.asList(urls));
        }
        this.randomClass = filterConfig.getInitParameter(PARAM_RANDOM_CLASS);
        if (StringUtils.isBlank((String)this.randomClass)) {
            this.randomClass = "java.security.SecureRandom";
        }
        try {
            this.randomizer = (Random)Class.forName(this.randomClass).newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new ServletException("Class '" + this.randomClass + "' for generating random tokens to prevent CSRF attacks not found.", (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new ServletException("Failed to instantiate class '" + this.randomClass + "' for generating random tokens to " + "prevent CSRF attacks.", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ServletException("Illegal access error encountered when instantiating class '" + this.randomClass + "' for generating " + "random token to prevent CSRF attacks.", (Throwable)e);
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        Object wResponse;
        if (servletRequest instanceof HttpServletRequest && servletResponse instanceof HttpServletResponse) {
            HttpServletRequest req = (HttpServletRequest)servletRequest;
            HttpServletResponse res = (HttpServletResponse)servletResponse;
            boolean skipNonceCheck = false;
            boolean storeInCache = true;
            if (HTTP_GET_METHOD.equals(req.getMethod())) {
                String path = req.getServletPath() + (req.getPathInfo() != null ? req.getPathInfo() : "");
                String[] paths = StringUtils.splitByWholeSeparator((String)path, (String)"/");
                String tmp = "";
                boolean alreadyFound = false;
                for (int i = 0; i < paths.length; ++i) {
                    if (this.excludedPaths.contains((tmp = tmp + "/" + paths[i]) + "/**")) {
                        String requestedFile = StringUtils.substring((String)path, (int)(path.lastIndexOf("/") + 1));
                        Matcher mat = extensionPattern.matcher(requestedFile);
                        if (mat.find()) {
                            this.log.debug("Found a match in extensionPattern.");
                            skipNonceCheck = true;
                            storeInCache = false;
                        }
                        alreadyFound = true;
                        break;
                    }
                    if (!this.excludedPaths.contains("/" + tmp + "/**")) continue;
                    alreadyFound = true;
                    skipNonceCheck = true;
                    storeInCache = false;
                    break;
                }
                if (!alreadyFound && this.excludedPaths.contains(path)) {
                    skipNonceCheck = true;
                }
            }
            this.log.debug("Skip nonceCheck :: " + skipNonceCheck);
            LruCache<String> nonceCache = (LruCache<String>)req.getSession(true).getAttribute(CSRF_NONCE_SESSION_ATTR_NAME);
            if (!skipNonceCheck) {
                String previousNonce = req.getParameter(CSRF_NONCE_REQUEST_PARAM);
                this.log.debug("Nonce found in request: " + previousNonce);
                String baseUrl = req.getScheme() + "://" + req.getServerName() + (req.getServerPort() > 0 ? ":" + req.getServerPort() : "") + "/" + StringUtils.stripStart((String)req.getContextPath(), (String)"/");
                this.log.debug("Calculated base URL :: " + baseUrl);
                String requestURL = req.getRequestURL().toString();
                this.log.debug("Request URL :: " + requestURL);
                if (baseUrl.equalsIgnoreCase(requestURL) || (baseUrl + "/").equalsIgnoreCase(requestURL)) {
                    this.log.debug("Requested URL is the base URL. Setting nonceCache to null to reset it.");
                    nonceCache = null;
                }
                if (nonceCache != null && !nonceCache.contains(this.decodeNonce(previousNonce))) {
                    this.log.error("Nonce not found in nonceCache! Request forbidden.");
                    this.log.debug("nonceCache keys:");
                    Set keys = nonceCache.getKeys();
                    for (String key : keys) {
                        this.log.debug(Base64.encodeBase64String((byte[])key.getBytes()));
                    }
                    res.sendError(403);
                    return;
                }
                if (nonceCache == null) {
                    nonceCache = new LruCache<String>(this.nonceCacheSize);
                    req.getSession().setAttribute(CSRF_NONCE_SESSION_ATTR_NAME, nonceCache);
                }
            }
            String newNonce = this.generateEncodedNonce();
            this.log.debug("Generated encoded nonce: " + newNonce);
            if (storeInCache) {
                nonceCache.add(this.decodeNonce(newNonce));
            }
            wResponse = new RedbackCSRFResponseWrapper(res, newNonce);
        } else {
            wResponse = servletResponse;
        }
        filterChain.doFilter(servletRequest, wResponse);
    }

    protected String generateEncodedNonce() {
        byte time;
        byte[] random = new byte[16];
        this.randomizer.nextBytes(random);
        byte[] all = new byte[17];
        for (int i = 0; i < random.length; ++i) {
            all[i] = random[i];
        }
        all[16] = time = (byte)System.currentTimeMillis();
        String encodedNonce = Base64.encodeBase64String((byte[])all);
        return encodedNonce;
    }

    protected String decodeNonce(String encodedNonce) {
        byte[] nonceInBytes = Base64.decodeBase64((String)encodedNonce);
        String decodedNonce = "";
        if (nonceInBytes != null) {
            decodedNonce = new String(nonceInBytes);
        }
        return decodedNonce;
    }

    public void destroy() {
    }

    public String getRandomClass() {
        return this.randomClass;
    }

    public void setRandomClass(String randomClass) {
        this.randomClass = randomClass;
    }

    public int getNonceCacheSize() {
        return this.nonceCacheSize;
    }

    public void setNonceCacheSize(int nonceCacheSize) {
        this.nonceCacheSize = nonceCacheSize;
    }

    public List<String> getExcludedPaths() {
        return this.excludedPaths;
    }

    public void setExcludedPaths(List<String> excludedPaths) {
        this.excludedPaths = excludedPaths;
    }

    public void setRandomizer(Random randomizer) {
        this.randomizer = randomizer;
    }
}

