/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.redback.struts2.filter;

import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedbackCSRFResponseWrapper
extends HttpServletResponseWrapper {
    protected String nonce;
    private Logger log = LoggerFactory.getLogger(RedbackCSRFResponseWrapper.class);

    public RedbackCSRFResponseWrapper(HttpServletResponse response) {
        super(response);
    }

    public RedbackCSRFResponseWrapper(HttpServletResponse response, String nonce) {
        super(response);
        this.nonce = nonce;
    }

    @Deprecated
    public String encodeRedirectUrl(String url) {
        return this.encodeRedirectURL(url);
    }

    public String encodeRedirectURL(String url) {
        return this.addNonce(super.encodeRedirectURL(url));
    }

    @Deprecated
    public String encodeUrl(String url) {
        return this.encodeURL(url);
    }

    public String encodeURL(String url) {
        return this.addNonce(super.encodeURL(url));
    }

    protected String addNonce(String url) {
        int question;
        while (StringUtils.contains((String)url, (String)"csrf_nonce")) {
            int start = StringUtils.indexOf((String)url, (String)"csrf_nonce");
            int end = StringUtils.indexOf((String)url, (char)'&', (int)start);
            String csrfParam = "";
            if (end == -1) {
                csrfParam = StringUtils.substring((String)url, (int)start);
                if (url.charAt(start - 1) == '?') {
                    csrfParam = "?" + csrfParam;
                } else if (url.charAt(start - 1) == '&') {
                    csrfParam = "&" + csrfParam;
                }
            } else {
                csrfParam = StringUtils.substring((String)url, (int)start, (int)(end + 1));
            }
            url = StringUtils.replace((String)url, (String)csrfParam, (String)"");
        }
        this.log.debug("'csrf_nonce' stripped URL :: " + url);
        if (url == null || this.nonce == null) {
            return url;
        }
        String path = url;
        String query = "";
        String anchor = "";
        int pound = path.indexOf(35);
        if (pound >= 0) {
            anchor = path.substring(pound);
            path = path.substring(0, pound);
        }
        if ((question = path.indexOf(63)) >= 0) {
            query = path.substring(question);
            path = path.substring(0, question);
        }
        StringBuilder sb = new StringBuilder(path);
        if (query.length() > 0) {
            sb.append(query);
            sb.append('&');
        } else {
            sb.append('?');
        }
        sb.append("csrf_nonce");
        sb.append('=');
        sb.append(this.escapeNonce(this.nonce));
        sb.append(anchor);
        this.log.debug("URL with nonce : " + sb.toString());
        return sb.toString();
    }

    private String escapeNonce(String nonce) {
        String escapedNonce = "";
        escapedNonce = StringUtils.replace((String)nonce, (String)"+", (String)"%2B");
        escapedNonce = StringUtils.replace((String)escapedNonce, (String)"?", (String)"%3F");
        escapedNonce = StringUtils.replace((String)escapedNonce, (String)"&", (String)"%26");
        escapedNonce = StringUtils.replace((String)escapedNonce, (String)"=", (String)"%3D");
        escapedNonce = StringUtils.replace((String)escapedNonce, (String)",", (String)"%2C");
        return escapedNonce;
    }
}

