/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.redback.struts2.interceptor;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import java.util.Map;
import org.apache.struts2.StrutsException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.redback.struts2.interceptor.ActionInvocationTracker;
import org.codehaus.plexus.spring.PlexusToSpringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.WebApplicationContext;

public abstract class AbstractHttpRequestTrackerInterceptor
extends AbstractInterceptor {
    public static final String TRACKER_NAME = ActionInvocationTracker.ROLE + ":name";
    protected Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    protected abstract String getTrackerName();

    public void init() {
        super.init();
        this.logger.info(((Object)((Object)this)).getClass().getName() + " initialized!");
    }

    protected synchronized ActionInvocationTracker addActionInvocation(ActionInvocation invocation) throws ComponentLookupException {
        Map sessionMap = invocation.getInvocationContext().getSession();
        ApplicationContext applicationContext = (ApplicationContext)ActionContext.getContext().getApplication().get(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        if (applicationContext == null) {
            throw new StrutsException("Could not locate ApplicationContext");
        }
        ActionInvocationTracker tracker = (ActionInvocationTracker)sessionMap.get(ActionInvocationTracker.ROLE);
        if (tracker == null) {
            String beanName = PlexusToSpringUtils.buildSpringId((String)ActionInvocationTracker.ROLE, (String)this.getTrackerName());
            tracker = (ActionInvocationTracker)applicationContext.getBean(beanName);
            sessionMap.put(ActionInvocationTracker.ROLE, tracker);
        }
        tracker.addActionInvocation(invocation);
        return tracker;
    }
}

