/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.redback.struts2.interceptor;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.Interceptor;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.plexus.redback.system.check.EnvironmentCheck;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvironmentCheckInterceptor
implements Interceptor {
    private static boolean checked = false;
    private Logger log = LoggerFactory.getLogger(EnvironmentCheckInterceptor.class);
    private List<EnvironmentCheck> checkers;

    public void destroy() {
    }

    public void init() {
        if (checked) {
            return;
        }
        if (this.checkers != null) {
            ArrayList violations = new ArrayList();
            for (EnvironmentCheck check : this.checkers) {
                check.validateEnvironment(violations);
            }
            if (!violations.isEmpty()) {
                StringBuffer msg = new StringBuffer();
                msg.append("EnvironmentCheck Failure.\n");
                msg.append("======================================================================\n");
                msg.append(" ENVIRONMENT FAILURE !! \n");
                msg.append("\n");
                for (String v : violations) {
                    msg.append(v).append("\n");
                }
                msg.append("\n");
                msg.append("======================================================================");
                this.log.error(msg.toString());
            }
        }
        checked = true;
    }

    public String intercept(ActionInvocation invocation) throws Exception {
        return invocation.invoke();
    }
}

