/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.redback.struts2.interceptor;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.Interceptor;
import java.util.Calendar;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts2.ServletActionContext;
import org.codehaus.plexus.redback.configuration.UserConfiguration;
import org.codehaus.plexus.redback.policy.UserSecurityPolicy;
import org.codehaus.plexus.redback.system.DefaultSecuritySession;
import org.codehaus.plexus.redback.system.SecuritySession;
import org.codehaus.plexus.redback.system.SecuritySystem;
import org.codehaus.plexus.redback.users.User;
import org.codehaus.plexus.redback.users.UserManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyEnforcementInterceptor
implements Interceptor {
    private Logger log = LoggerFactory.getLogger(PolicyEnforcementInterceptor.class);
    private static final String SECURITY_USER_MUST_CHANGE_PASSWORD = "security-must-change-password";
    private UserConfiguration config;
    protected SecuritySystem securitySystem;

    public void destroy() {
    }

    public void init() {
    }

    public String intercept(ActionInvocation actionInvocation) throws Exception {
        if (this.config.getBoolean("security.policy.strict.enforcement.enabled")) {
            this.log.debug("Enforcement: enforcing per click security policies.");
            ActionContext context = ActionContext.getContext();
            SecuritySession securitySession = null;
            try {
                securitySession = (SecuritySession)context.getSession().get("securitySession");
            }
            catch (IllegalStateException e) {
                this.log.debug("Could not get security session as the session was invalid", (Throwable)e);
            }
            UserSecurityPolicy policy = this.securitySystem.getPolicy();
            if (securitySession == null) {
                this.log.debug("Enforcement: no user security session detected, skipping enforcement");
                return actionInvocation.invoke();
            }
            UserManager userManager = this.securitySystem.getUserManager();
            User user = userManager.findUser(securitySession.getUser().getPrincipal());
            securitySession = new DefaultSecuritySession(securitySession.getAuthenticationResult(), user);
            context.getSession().put("securitySession", securitySession);
            if (this.checkForcePasswordChange(securitySession, actionInvocation)) {
                Map session = ServletActionContext.getContext().getSession();
                HttpServletRequest request = ServletActionContext.getRequest();
                String queryString = request.getQueryString();
                String targetUrl = request.getRequestURL() + (queryString == null ? "" : "?" + queryString);
                session.put("targetUrl", targetUrl);
                this.log.info("storing targetUrl : " + targetUrl);
                return SECURITY_USER_MUST_CHANGE_PASSWORD;
            }
            if (this.config.getBoolean("security.policy.password.expiration.enabled")) {
                this.log.debug("checking password expiration notification");
                userManager = this.securitySystem.getUserManager();
                user = userManager.findUser(securitySession.getUser().getPrincipal());
                Calendar expirationNotifyDate = Calendar.getInstance();
                expirationNotifyDate.setTime(user.getLastPasswordChange());
                expirationNotifyDate.add(5, policy.getPasswordExpirationDays() - this.config.getInt("security.policy.password.expiration.notify.days"));
                Calendar now = Calendar.getInstance();
                if (now.after(expirationNotifyDate)) {
                    this.log.debug("setting password expiration notification");
                    Calendar expirationDate = Calendar.getInstance();
                    expirationDate.setTime(user.getLastPasswordChange());
                    expirationDate.add(5, policy.getPasswordExpirationDays());
                    Map session = ServletActionContext.getContext().getSession();
                    session.put("passwordExpirationNotification", expirationDate.getTime().toString());
                }
            }
            return actionInvocation.invoke();
        }
        this.log.debug("Enforcement: not processing per click security policies.");
        return actionInvocation.invoke();
    }

    private boolean checkForcePasswordChange(SecuritySession securitySession, ActionInvocation actionInvocation) {
        if ("org.codehaus.plexus.redback.struts2.action.PasswordAction".equals(actionInvocation.getAction().getClass().getName())) {
            this.log.debug("Enforcement: skipping force password check on password action");
            return false;
        }
        if ("org.codehaus.plexus.redback.struts2.action.LoginAction".equals(actionInvocation.getAction().getClass().getName())) {
            this.log.debug("Enforcement: skipping force password check on login action");
            return false;
        }
        if ("org.codehaus.plexus.redback.struts2.action.LogoutAction".equals(actionInvocation.getAction().getClass().getName())) {
            this.log.debug("Enforcement: skipping force password check on logout action");
            return false;
        }
        if (this.config.getBoolean("security.policy.strict.force.password.change.enabled")) {
            this.log.debug("Enforcement: checking active user password change enabled");
            if (securitySession.getUser().isPasswordChangeRequired()) {
                this.log.info("Enforcement: User must change password - forwarding to change password page.");
                return true;
            }
            this.log.debug("Enforcement: User doesn't need to change password.");
        }
        return false;
    }
}

