/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.redback.struts2.interceptor;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.Interceptor;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XSSParameterCheckInterceptor
implements Interceptor {
    private Logger log = LoggerFactory.getLogger(XSSParameterCheckInterceptor.class);
    private static final String SCRIPT_KEYWORD = "<script>";
    private static final String POSSIBLE_XSS_ATTACK = "possible-xss-attack";

    public void destroy() {
    }

    public void init() {
    }

    public String intercept(ActionInvocation actionInvocation) throws Exception {
        Map params = actionInvocation.getInvocationContext().getParameters();
        for (String key : params.keySet()) {
            Object value = params.get(key);
            if (value == null) continue;
            if (value instanceof String) {
                if (!StringUtils.containsIgnoreCase((String)((String)value), (String)SCRIPT_KEYWORD)) continue;
                this.log.warn("Possible XSS attack detected! A '<script>' tag was found in the request parameter '" + key + "' of your action.");
                return POSSIBLE_XSS_ATTACK;
            }
            if (!(value instanceof String[])) continue;
            String[] val = (String[])value;
            for (int i = 0; i < val.length; ++i) {
                if (!StringUtils.containsIgnoreCase((String)val[i], (String)SCRIPT_KEYWORD)) continue;
                this.log.warn("Possible XSS attack detected! A '<script>' tag was found in the request parameter '" + key + "' of your action.");
                return POSSIBLE_XSS_ATTACK;
            }
        }
        return actionInvocation.invoke();
    }
}

