package org.codehaus.plexus.redback.struts2.result;

import com.opensymphony.xwork2.ActionInvocation;

/*
 * Copyright 2005-2006 The Codehaus.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * SecurityExternalResult
 *
 * @author <a href="mailto:joakim@erdfelt.com">Joakim Erdfelt</a>
 * @version $Id: SecurityExternalResult.java 592 2008-09-26 04:41:56Z james.w.dumay $
 * @plexus.component role="com.opensymphony.xwork2.Result"
 * role-hint="securityExternalResult"
 * instantiation-strategy="per-lookup"
 */
public class SecurityExternalResult
    extends AbstractBackTrackingResult
{
    /**
     * @plexus.configuration default-value="redbackRedirect"
     */
    private String externalActionName;

    private String externalResult;

    @Override
    public void execute( ActionInvocation invocation )
        throws Exception
    {
        // the login redirection is not captured by the http request
        // tracker, so we backtrack to the current request
        if ( !setupBackTrackCurrent( invocation ))
        {
            setNamespace( "/" );
            setActionName( externalActionName );
        }
        
        super.execute( invocation );        
    }

    public String getExternalResult()
    {
        return externalResult;
    }

    public void setExternalResult( String externalResult )
    {
        this.externalResult = externalResult;
    }    
    
}
