/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.redback.struts2.action.admin;

import org.codehaus.plexus.redback.configuration.UserConfiguration;
import org.codehaus.plexus.redback.role.RoleManager;
import org.codehaus.plexus.redback.role.RoleManagerException;
import org.codehaus.plexus.redback.struts2.action.AuditEvent;
import org.codehaus.plexus.redback.struts2.action.admin.AbstractAdminUserCredentialsAction;
import org.codehaus.plexus.redback.users.User;
import org.codehaus.plexus.redback.users.UserManager;
import org.codehaus.redback.integration.interceptor.SecureActionBundle;
import org.codehaus.redback.integration.interceptor.SecureActionException;
import org.codehaus.redback.integration.model.EditUserCredentials;

public class AddAdminUserAction
extends AbstractAdminUserCredentialsAction {
    private RoleManager roleManager;
    private UserConfiguration config;
    private EditUserCredentials user;

    public String show() {
        if (this.user == null) {
            this.user = new EditUserCredentials(this.config.getString("redback.default.admin"));
        }
        return "input";
    }

    public String submit() {
        if (this.user == null) {
            this.user = new EditUserCredentials(this.config.getString("redback.default.admin"));
            this.addActionError(this.getText("invalid.admin.credentials"));
            return "error";
        }
        this.log.info("user = " + this.user);
        this.internalUser = this.user;
        this.validateCredentialsStrict();
        UserManager userManager = this.securitySystem.getUserManager();
        if (userManager.userExists((Object)this.config.getString("redback.default.admin"))) {
            this.addActionError(this.getText("admin.user.already.exists"));
            return "error";
        }
        if (this.hasActionErrors() || this.hasFieldErrors()) {
            return "error";
        }
        User u = userManager.createUser(this.config.getString("redback.default.admin"), this.user.getFullName(), this.user.getEmail());
        if (u == null) {
            this.addActionError(this.getText("cannot.operate.on.null.user"));
            return "error";
        }
        u.setPassword(this.user.getPassword());
        u.setLocked(false);
        u.setPasswordChangeRequired(false);
        u.setPermanent(true);
        userManager.addUser(u);
        AuditEvent event = new AuditEvent(this.getText("log.account.create"));
        event.setAffectedUser(u.getUsername());
        event.log();
        try {
            this.roleManager.assignRole("system-administrator", u.getPrincipal().toString());
            event = new AuditEvent(this.getText("log.assign.role"));
            event.setAffectedUser(u.getUsername());
            event.setRole("system-administrator");
            event.log();
        }
        catch (RoleManagerException rpe) {
            this.addActionError(this.getText("cannot.assign.admin.role"));
            return "error";
        }
        return "security-admin-user-created";
    }

    public EditUserCredentials getUser() {
        return this.user;
    }

    public void setUser(EditUserCredentials user) {
        this.user = user;
    }

    public SecureActionBundle initSecureActionBundle() throws SecureActionException {
        return SecureActionBundle.OPEN;
    }
}

