/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.redback.struts2.action.admin;

import edu.emory.mathcs.backport.java.util.Collections;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.codehaus.plexus.redback.rbac.RbacManagerException;
import org.codehaus.plexus.redback.rbac.RbacObjectNotFoundException;
import org.codehaus.plexus.redback.rbac.Role;
import org.codehaus.plexus.redback.rbac.UserAssignment;
import org.codehaus.plexus.redback.role.RoleManager;
import org.codehaus.plexus.redback.role.model.ModelApplication;
import org.codehaus.plexus.redback.struts2.action.AbstractUserCredentialsAction;
import org.codehaus.plexus.redback.struts2.action.AuditEvent;
import org.codehaus.plexus.redback.struts2.model.ApplicationRoleDetails;
import org.codehaus.plexus.redback.users.User;
import org.codehaus.plexus.redback.users.UserManager;
import org.codehaus.plexus.redback.users.UserNotFoundException;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.redback.integration.interceptor.SecureActionBundle;
import org.codehaus.redback.integration.interceptor.SecureActionException;
import org.codehaus.redback.integration.model.AdminEditUserCredentials;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssignmentsAction
extends AbstractUserCredentialsAction {
    private RoleManager rmanager;
    private String principal;
    private AdminEditUserCredentials user;
    private List<Role> assignedRoles;
    private List<Role> availableRoles;
    private List<Role> effectivelyAssignedRoles;
    private List<String> addDSelectedRoles;
    private List<String> addNDSelectedRoles;
    private List<Role> nondynamicroles;
    private List<Role> dynamicroles;
    private List<String> NDRoles;
    private List<String> DRoles;
    private List<ApplicationRoleDetails> applicationRoleDetails = new ArrayList<ApplicationRoleDetails>();

    public List<ApplicationRoleDetails> getApplicationRoleDetails() {
        return this.applicationRoleDetails;
    }

    public String show() throws RbacObjectNotFoundException, RbacManagerException {
        this.addNDSelectedRoles = new ArrayList<String>();
        this.addDSelectedRoles = new ArrayList<String>();
        if (StringUtils.isEmpty((String)this.principal)) {
            this.addActionError(this.getText("rbac.edit.user.empty.principal"));
            return "error";
        }
        UserManager userManager = this.securitySystem.getUserManager();
        if (!userManager.userExists((Object)this.principal)) {
            this.addActionError(this.getText("user.does.not.exist", Collections.singletonList((Object)this.principal)));
            return "error";
        }
        try {
            User u = userManager.findUser(this.principal);
            if (u == null) {
                this.addActionError(this.getText("cannot.operate.on.null.user"));
                return "error";
            }
            this.user = new AdminEditUserCredentials(u);
        }
        catch (UserNotFoundException e) {
            this.addActionError(this.getText("user.not.found.exception", Arrays.asList(this.principal, e.getMessage())));
            return "error";
        }
        if (!this.getManager().userAssignmentExists(this.principal)) {
            UserAssignment assignment = this.getManager().createUserAssignment(this.principal);
            this.getManager().saveUserAssignment(assignment);
        }
        List<Role> assignableRoles = this.getFilteredRolesForCurrentUserAccess();
        for (ModelApplication application : this.rmanager.getModel().getApplications()) {
            ApplicationRoleDetails details = new ApplicationRoleDetails(application, this.getManager().getEffectivelyAssignedRoles(this.principal), this.getManager().getAssignedRoles(this.principal), assignableRoles);
            this.applicationRoleDetails.add(details);
        }
        return "success";
    }

    public String edituser() {
        try {
            Collection assignedRoles = this.getManager().getAssignedRoles(this.principal);
            List<Role> assignableRoles = this.getFilteredRolesForCurrentUserAccess();
            HashSet<Role> availableRoles = new HashSet<Role>(assignedRoles);
            availableRoles.addAll(assignableRoles);
            ArrayList<String> roles = new ArrayList<String>();
            this.addSelectedRoles(availableRoles, roles, this.addNDSelectedRoles);
            this.addSelectedRoles(availableRoles, roles, this.addDSelectedRoles);
            ArrayList<String> newRoles = new ArrayList<String>(roles);
            String currentUser = this.getCurrentUser();
            for (Role assignedRole : assignedRoles) {
                if (!roles.contains(assignedRole.getName())) {
                    if (!this.checkRoleName(assignableRoles, assignedRole.getName())) {
                        roles.add(assignedRole.getName());
                        continue;
                    }
                    String role = assignedRole.getName();
                    AuditEvent event = new AuditEvent(this.getText("log.revoke.role"));
                    event.setAffectedUser(this.principal);
                    event.setRole(role);
                    event.setCurrentUser(currentUser);
                    event.log();
                    continue;
                }
                newRoles.remove(assignedRole.getName());
            }
            for (String r : newRoles) {
                AuditEvent event = new AuditEvent(this.getText("log.assign.role"));
                event.setAffectedUser(this.principal);
                event.setRole(r);
                event.setCurrentUser(currentUser);
                event.log();
            }
            UserAssignment assignment = this.getManager().userAssignmentExists(this.principal) ? this.getManager().getUserAssignment(this.principal) : this.getManager().createUserAssignment(this.principal);
            assignment.setRoleNames(roles);
            assignment = this.getManager().saveUserAssignment(assignment);
        }
        catch (RbacManagerException ne) {
            this.addActionError(this.getText("error.removing.selected.roles", Arrays.asList(ne.getMessage())));
            return "error";
        }
        return "success";
    }

    private void addSelectedRoles(Collection<Role> assignableRoles, List<String> roles, List<String> selectedRoles) {
        if (selectedRoles != null) {
            for (String r : selectedRoles) {
                if (!this.checkRoleName(assignableRoles, r)) continue;
                roles.add(r);
            }
        }
    }

    private boolean checkRoleName(Collection<Role> assignableRoles, String r) {
        for (Role role : assignableRoles) {
            if (!role.getName().equals(r)) continue;
            return true;
        }
        return false;
    }

    public List<Role> getAssignedRoles() {
        return this.assignedRoles;
    }

    public void setAssignedRoles(List<Role> assignedRoles) {
        this.assignedRoles = assignedRoles;
    }

    public List<Role> getAvailableRoles() {
        return this.availableRoles;
    }

    public void setAvailableRoles(List<Role> availableRoles) {
        this.availableRoles = availableRoles;
    }

    public List<Role> getEffectivelyAssignedRoles() {
        return this.effectivelyAssignedRoles;
    }

    public void setEffectivelyAssignedRoles(List<Role> effectivelyAssignedRoles) {
        this.effectivelyAssignedRoles = effectivelyAssignedRoles;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(String principal) {
        this.principal = principal;
    }

    public void setUsername(String username) {
        this.principal = username;
    }

    public AdminEditUserCredentials getUser() {
        return this.user;
    }

    @Override
    public SecureActionBundle initSecureActionBundle() throws SecureActionException {
        SecureActionBundle bundle = new SecureActionBundle();
        bundle.setRequiresAuthentication(true);
        bundle.addRequiredAuthorization("user-management-user-edit", "*");
        bundle.addRequiredAuthorization("user-management-rbac-admin", "*");
        bundle.addRequiredAuthorization("user-management-role-grant", "*");
        bundle.addRequiredAuthorization("user-management-role-drop", "*");
        bundle.addRequiredAuthorization("user-management-user-role", "*");
        return bundle;
    }

    public List<Role> getNondynamicroles() {
        return this.nondynamicroles;
    }

    public void setNondynamicroles(List<Role> nondynamicroles) {
        this.nondynamicroles = nondynamicroles;
    }

    public List<Role> getDynamicroles() {
        return this.dynamicroles;
    }

    public void setDynamicroles(List<Role> dynamicroles) {
        this.dynamicroles = dynamicroles;
    }

    public List<String> getNDRoles() {
        return this.NDRoles;
    }

    public void setNDRoles(List<String> roles) {
        this.NDRoles = roles;
    }

    public List<String> getDRoles() {
        return this.DRoles;
    }

    public void setDRoles(List<String> roles) {
        this.DRoles = roles;
    }

    public List<String> getAddDSelectedRoles() {
        return this.addDSelectedRoles;
    }

    public void setAddDSelectedRoles(List<String> addDSelectedRoles) {
        this.addDSelectedRoles = addDSelectedRoles;
    }

    public List<String> getAddNDSelectedRoles() {
        return this.addNDSelectedRoles;
    }

    public void setAddNDSelectedRoles(List<String> addNDSelectedRoles) {
        this.addNDSelectedRoles = addNDSelectedRoles;
    }
}

