/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.redback.struts2.action.admin;

import com.opensymphony.xwork2.Preparable;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.codehaus.plexus.redback.keys.KeyManager;
import org.codehaus.plexus.redback.management.DataManagementTool;
import org.codehaus.plexus.redback.rbac.RBACManager;
import org.codehaus.plexus.redback.struts2.action.AbstractSecurityAction;
import org.codehaus.plexus.redback.struts2.action.admin.BackupRecord;
import org.codehaus.plexus.redback.users.UserManager;
import org.codehaus.redback.integration.interceptor.SecureAction;
import org.codehaus.redback.integration.interceptor.SecureActionBundle;
import org.codehaus.redback.integration.interceptor.SecureActionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BackupRestoreAction
extends AbstractSecurityAction
implements SecureAction,
Preparable {
    public static final String CUSTOM_ERROR = "custom_error";
    private File applicationHome;
    private DataManagementTool dataManagementTool;
    private RBACManager rbacManager;
    private UserManager userManager;
    private KeyManager keyManager;
    private File backupDirectory;
    private String restoreDirectory;
    private List<BackupRecord> previousBackups;
    private boolean confirmed;
    public static final String BACKUP_DIRECTORY = "user-backup-directory";

    public String view() throws Exception {
        this.retrievePreviousBackups();
        return "success";
    }

    public String backup() throws Exception {
        File backupDirectory = this.getTimestampedBackupDirectory();
        backupDirectory.mkdirs();
        this.log.info("Backing up security database to " + backupDirectory);
        this.backupDatabase(backupDirectory);
        this.log.info("Done backing up security database");
        return "success";
    }

    public String restore() throws Exception {
        if (StringUtils.isEmpty((String)this.restoreDirectory)) {
            this.addActionError(this.getText("backupRestore.backup.empty.error"));
            return CUSTOM_ERROR;
        }
        File restoreDirectory = new File(this.restoreDirectory);
        boolean fileExists = restoreDirectory.exists() && restoreDirectory.isDirectory();
        boolean isValidBackup = false;
        if (fileExists) {
            BackupRecord record = new BackupRecord(restoreDirectory);
            isValidBackup = record.isValidBackup();
        }
        if (!fileExists) {
            this.log.warn("Backup: " + this.restoreDirectory + " not found.");
            this.addActionError(this.getText("backupRestore.backup.error"));
            this.retrievePreviousBackups();
            return CUSTOM_ERROR;
        }
        if (!isValidBackup) {
            this.log.warn("Backup: " + this.restoreDirectory + " is not a valid backup directory.");
            this.addActionError(this.getText("backupRestore.backup.error"));
            this.retrievePreviousBackups();
            return CUSTOM_ERROR;
        }
        this.log.info("Restoring security database from " + this.restoreDirectory);
        this.eraseDatabase();
        this.restoreDatabase(restoreDirectory);
        this.log.info("Done restoring security database");
        return "success";
    }

    private void backupDatabase(File backupDirectory) throws Exception {
        this.dataManagementTool.backupKeyDatabase(this.keyManager, backupDirectory);
        this.dataManagementTool.backupRBACDatabase(this.rbacManager, backupDirectory);
        this.dataManagementTool.backupUserDatabase(this.userManager, backupDirectory);
    }

    private void eraseDatabase() {
        this.dataManagementTool.eraseKeysDatabase(this.keyManager);
        this.dataManagementTool.eraseRBACDatabase(this.rbacManager);
        this.dataManagementTool.eraseUsersDatabase(this.userManager);
    }

    private void restoreDatabase(File backupDirectory) throws Exception {
        this.dataManagementTool.restoreKeysDatabase(this.keyManager, backupDirectory);
        this.dataManagementTool.restoreRBACDatabase(this.rbacManager, backupDirectory);
        this.dataManagementTool.restoreUsersDatabase(this.userManager, backupDirectory);
    }

    public String getRestoreDirectory() {
        return this.restoreDirectory;
    }

    public void setRestoreDirectory(String restoreDirectory) {
        this.restoreDirectory = restoreDirectory;
    }

    private File getTimestampedBackupDirectory() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd.HHmmss", Locale.US);
        return new File(this.backupDirectory, dateFormat.format(new Date()));
    }

    public File getBackupDirectory() {
        return this.backupDirectory;
    }

    public List<BackupRecord> getPreviousBackups() {
        return this.previousBackups;
    }

    public void prepare() {
        this.backupDirectory = this.getFile(BACKUP_DIRECTORY);
        this.retrievePreviousBackups();
    }

    private void retrievePreviousBackups() {
        this.previousBackups = new ArrayList<BackupRecord>();
        File[] files = this.backupDirectory.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                BackupRecord record;
                File f = files[i];
                if (!f.isDirectory() || f.getName().startsWith(".") || !(record = new BackupRecord(f)).isValidBackup()) continue;
                this.previousBackups.add(record);
            }
        }
        Collections.sort(this.previousBackups);
    }

    public boolean isConfirmed() {
        return this.confirmed;
    }

    public void setConfirmed(boolean confirmed) {
        this.confirmed = confirmed;
    }

    @Override
    public SecureActionBundle initSecureActionBundle() throws SecureActionException {
        SecureActionBundle bundle = new SecureActionBundle();
        bundle.setRequiresAuthentication(true);
        bundle.addRequiredAuthorization("user-management-manage-data", "*");
        return bundle;
    }

    public File getFile(String filename) {
        if (filename == null) {
            return null;
        }
        File f = null;
        if (filename != null && filename.length() != 0 && !(f = new File(filename)).isAbsolute()) {
            f = new File(this.applicationHome, filename);
        }
        try {
            return f.getCanonicalFile();
        }
        catch (IOException e) {
            return f;
        }
    }
}

