/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.redback.struts2.action.admin;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.redback.rbac.Permission;
import org.codehaus.plexus.redback.rbac.RbacManagerException;
import org.codehaus.plexus.redback.rbac.Role;
import org.codehaus.plexus.redback.rbac.UserAssignment;
import org.codehaus.plexus.redback.struts2.action.AbstractUserCredentialsAction;
import org.codehaus.plexus.redback.struts2.action.AuditEvent;
import org.codehaus.plexus.redback.users.User;
import org.codehaus.plexus.redback.users.UserManager;
import org.codehaus.plexus.redback.users.UserNotFoundException;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.redback.integration.interceptor.SecureActionBundle;
import org.codehaus.redback.integration.interceptor.SecureActionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditRoleAction
extends AbstractUserCredentialsAction {
    private String name;
    private String description;
    private String newDescription;
    private List<String> childRoleNames = new ArrayList<String>();
    private List<String> parentRoleNames = new ArrayList<String>();
    private List<Permission> permissions = new ArrayList<Permission>();
    private List<User> users = new ArrayList<User>();
    private List<User> parentUsers = new ArrayList<User>();
    private List<User> allUsers = new ArrayList<User>();
    private List<String> usersList = new ArrayList<String>();
    private List<String> availableUsers = new ArrayList<String>();
    private List<String> currentUsers = new ArrayList<String>();

    public String input() {
        if (this.name == null) {
            this.addActionError(this.getText("cannot.edit.null.role"));
            return "error";
        }
        if (StringUtils.isEmpty((String)this.name)) {
            this.addActionError(this.getText("cannot.edit.empty.role"));
            return "error";
        }
        if (!this.getManager().roleExists(this.name)) {
            return "input";
        }
        try {
            List userParentAssignments;
            if (!this.isAuthorized()) {
                this.log.warn(this.getCurrentUser() + " isn't authorized to access to the role '" + this.name + "'");
                this.addActionError(this.getText("alert.message"));
                return "error";
            }
            Role role = this.getManager().getRole(this.name);
            if (role == null) {
                this.addActionError(this.getText("cannot.operate.null.role"));
                return "error";
            }
            this.description = role.getDescription();
            this.childRoleNames = role.getChildRoleNames();
            Map parentRoles = this.getManager().getParentRoles(role);
            for (String roleName : parentRoles.keySet()) {
                this.parentRoleNames.add(roleName);
            }
            this.permissions = role.getPermissions();
            ArrayList<String> roles = new ArrayList<String>();
            roles.add(this.name);
            List userAssignments = this.getManager().getUserAssignmentsForRoles(roles);
            this.users = new ArrayList<User>();
            if (userAssignments != null) {
                for (UserAssignment userAssignment : userAssignments) {
                    try {
                        User user = this.getUserManager().findUser(userAssignment.getPrincipal());
                        this.users.add(user);
                    }
                    catch (UserNotFoundException e) {
                        this.log.warn("User '" + userAssignment.getPrincipal() + "' doesn't exist.", (Throwable)e);
                    }
                }
            }
            this.parentUsers = new ArrayList<User>();
            if (!parentRoles.isEmpty() && (userParentAssignments = this.getManager().getUserAssignmentsForRoles(parentRoles.keySet())) != null) {
                for (UserAssignment userAssignment : userParentAssignments) {
                    try {
                        User user = this.getUserManager().findUser(userAssignment.getPrincipal());
                        this.parentUsers.add(user);
                    }
                    catch (UserNotFoundException e) {
                        this.log.warn("User '" + userAssignment.getPrincipal() + "' doesn't exist.", (Throwable)e);
                    }
                }
            }
        }
        catch (RbacManagerException e) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(this.name);
            list.add(e.getMessage());
            this.addActionError(this.getText("cannot.get.role", list));
            return "error";
        }
        return "input";
    }

    private boolean isAuthorized() throws RbacManagerException {
        List<Role> assignableRoles = this.getFilteredRolesForCurrentUserAccess();
        boolean updatableRole = false;
        for (Role r : assignableRoles) {
            if (!r.getName().equalsIgnoreCase(this.name)) continue;
            updatableRole = true;
        }
        return updatableRole;
    }

    public String edit() {
        String result = this.input();
        if ("error".equals(result)) {
            return result;
        }
        this.newDescription = this.description;
        this.allUsers = this.getUserManager().getUsers();
        for (User user : this.users) {
            if (!this.allUsers.contains(user)) continue;
            this.allUsers.remove(user);
        }
        for (User user : this.parentUsers) {
            if (!this.allUsers.contains(user)) continue;
            this.allUsers.remove(user);
        }
        return result;
    }

    public String save() {
        String result = this.input();
        if ("error".equals(result)) {
            return result;
        }
        if (this.name == null) {
            this.addActionError(this.getText("cannot.edit.null.role"));
            return "error";
        }
        if (StringUtils.isEmpty((String)this.name)) {
            this.addActionError(this.getText("cannot.edit.empty.role"));
            return "error";
        }
        try {
            Role role = this.getManager().roleExists(this.name) ? this.getManager().getRole(this.name) : this.getManager().createRole(this.name);
            role.setDescription(this.newDescription);
            this.getManager().saveRole(role);
            ArrayList<String> list = new ArrayList<String>();
            list.add(this.name);
            String currentUser = this.getCurrentUser();
            AuditEvent event = new AuditEvent(this.getText("log.role.edit"));
            event.setRole(this.name);
            event.setCurrentUser(currentUser);
            event.log();
            this.addActionMessage(this.getText("save.role.success", list));
        }
        catch (RbacManagerException e) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(this.name);
            list.add(e.getMessage());
            this.addActionError(this.getText("cannot.get.role", list));
            return "error";
        }
        return "success";
    }

    public String addUsers() {
        if (this.availableUsers == null || this.availableUsers.isEmpty()) {
            return "input";
        }
        for (String principal : this.availableUsers) {
            if (!this.getUserManager().userExists((Object)principal)) {
                ArrayList<String> list = new ArrayList<String>();
                list.add(principal);
                this.addActionError(this.getText("user.does.not.exist", list));
                return "error";
            }
            try {
                UserAssignment assignment = this.getManager().userAssignmentExists(principal) ? this.getManager().getUserAssignment(principal) : this.getManager().createUserAssignment(principal);
                assignment.addRoleName(this.name);
                assignment = this.getManager().saveUserAssignment(assignment);
                this.log.info(this.name + " role assigned to " + principal);
            }
            catch (RbacManagerException e) {
                ArrayList<String> list = new ArrayList<String>();
                list.add(principal);
                list.add(e.getMessage());
                this.addActionError(this.getText("cannot.assign.role", list));
                return "error";
            }
        }
        this.edit();
        return "success";
    }

    public String removeUsers() {
        if (this.currentUsers == null || this.currentUsers.isEmpty()) {
            return "input";
        }
        for (String principal : this.currentUsers) {
            if (!this.getUserManager().userExists((Object)principal)) {
                ArrayList<String> list = new ArrayList<String>();
                list.add(principal);
                this.addActionError(this.getText("user.does.not.exist", list));
                return "error";
            }
            try {
                UserAssignment assignment = this.getManager().userAssignmentExists(principal) ? this.getManager().getUserAssignment(principal) : this.getManager().createUserAssignment(principal);
                assignment.removeRoleName(this.name);
                assignment = this.getManager().saveUserAssignment(assignment);
                this.log.info(this.name + " role unassigned to " + principal);
            }
            catch (RbacManagerException e) {
                ArrayList<String> list = new ArrayList<String>();
                list.add(principal);
                list.add(e.getMessage());
                this.addActionError(this.getText("cannot.assign.role", list));
                return "error";
            }
        }
        this.edit();
        return "success";
    }

    private UserManager getUserManager() {
        return this.securitySystem.getUserManager();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String roleName) {
        this.name = roleName;
    }

    public List<String> getChildRoleNames() {
        return this.childRoleNames;
    }

    public void setChildRoleNames(List<String> childRoleNames) {
        this.childRoleNames = childRoleNames;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getNewDescription() {
        return this.newDescription;
    }

    public void setNewDescription(String newDescription) {
        this.newDescription = newDescription;
    }

    public List<Permission> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(List<Permission> permissions) {
        this.permissions = permissions;
    }

    public List<User> getUsers() {
        return this.users;
    }

    public void setUsers(List<User> users) {
        this.users = users;
    }

    public List<User> getAllUsers() {
        return this.allUsers;
    }

    public void setAllUsers(List<User> allUsers) {
        this.allUsers = allUsers;
    }

    public List<String> getUsersList() {
        return this.usersList;
    }

    public void setUsersList(List<String> usersList) {
        this.usersList = usersList;
    }

    public List<String> getAvailableUsers() {
        return this.availableUsers;
    }

    public void setAvailableUsers(List<String> availableUsers) {
        this.availableUsers = availableUsers;
    }

    public List<String> getCurrentUsers() {
        return this.currentUsers;
    }

    public void setCurrentUsers(List<String> currentUsers) {
        this.currentUsers = currentUsers;
    }

    public List<String> getParentRoleNames() {
        return this.parentRoleNames;
    }

    public void setParentRoleNames(List<String> parentRoleNames) {
        this.parentRoleNames = parentRoleNames;
    }

    public List<User> getParentUsers() {
        return this.parentUsers;
    }

    public void setParentUsers(List<User> parentUsers) {
        this.parentUsers = parentUsers;
    }

    @Override
    public SecureActionBundle initSecureActionBundle() throws SecureActionException {
        SecureActionBundle bundle = new SecureActionBundle();
        bundle.setRequiresAuthentication(true);
        bundle.addRequiredAuthorization("user-management-user-edit", "*");
        bundle.addRequiredAuthorization("user-management-rbac-admin", "*");
        bundle.addRequiredAuthorization("user-management-role-grant", "*");
        bundle.addRequiredAuthorization("user-management-role-drop", "*");
        bundle.addRequiredAuthorization("user-management-user-role", "*");
        return bundle;
    }
}

