/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.redback.struts2.action.admin;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.codehaus.plexus.redback.rbac.RBACManager;
import org.codehaus.plexus.redback.rbac.RbacManagerException;
import org.codehaus.plexus.redback.rbac.Resource;
import org.codehaus.plexus.redback.struts2.action.AbstractSecurityAction;
import org.codehaus.redback.integration.interceptor.SecureActionBundle;
import org.codehaus.redback.integration.interceptor.SecureActionException;
import org.codehaus.redback.integration.util.ResourceSorter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourcesAction
extends AbstractSecurityAction {
    private static final String LIST = "list";
    private RBACManager manager;
    private String resourceIdentifier;
    private boolean isPattern;
    private List<Resource> allResources;

    public String list() {
        try {
            this.allResources = this.manager.getAllResources();
            if (this.allResources == null) {
                this.allResources = Collections.emptyList();
            }
            Collections.sort(this.allResources, new ResourceSorter());
        }
        catch (RbacManagerException e) {
            this.addActionError(this.getText("cannot.list.all.resources", Arrays.asList(e.getMessage())));
            this.log.error("System error:", (Throwable)e);
            this.allResources = Collections.emptyList();
        }
        return LIST;
    }

    public String save() {
        try {
            Resource temp = this.manager.createResource(this.resourceIdentifier);
            temp.setIdentifier(this.resourceIdentifier);
            temp.setPattern(this.isPattern);
            this.manager.saveResource(temp);
        }
        catch (RbacManagerException e) {
            this.addActionError(this.getText("cannot.save.resource", Arrays.asList(e.getMessage())));
            this.log.error("System error:", (Throwable)e);
            this.allResources = Collections.emptyList();
        }
        return LIST;
    }

    public String remove() {
        try {
            this.manager.removeResource(this.manager.getResource(this.resourceIdentifier));
        }
        catch (RbacManagerException ne) {
            this.addActionError(this.getText("cannot.remove.resource", Arrays.asList(this.resourceIdentifier)));
            return "error";
        }
        return LIST;
    }

    public List<Resource> getAllResources() {
        return this.allResources;
    }

    public void setAllResources(List<Resource> allResources) {
        this.allResources = allResources;
    }

    public String getResourceIdentifier() {
        return this.resourceIdentifier;
    }

    public void setResourceIdentifier(String resourceIdentifier) {
        this.resourceIdentifier = resourceIdentifier;
    }

    public boolean isPattern() {
        return this.isPattern;
    }

    public void setPattern(boolean isPattern) {
        this.isPattern = isPattern;
    }

    @Override
    public SecureActionBundle initSecureActionBundle() throws SecureActionException {
        SecureActionBundle bundle = new SecureActionBundle();
        bundle.setRequiresAuthentication(true);
        bundle.addRequiredAuthorization("user-management-rbac-admin", "*");
        return bundle;
    }
}

