/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.redback.struts2.action.admin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.codehaus.plexus.redback.rbac.Permission;
import org.codehaus.plexus.redback.rbac.RBACManager;
import org.codehaus.plexus.redback.rbac.RbacManagerException;
import org.codehaus.plexus.redback.rbac.Role;
import org.codehaus.plexus.redback.struts2.action.AbstractSecurityAction;
import org.codehaus.plexus.redback.struts2.action.AuditEvent;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.redback.integration.interceptor.SecureActionBundle;
import org.codehaus.redback.integration.interceptor.SecureActionException;
import org.codehaus.redback.integration.model.SimplePermission;

public class RoleCreateAction
extends AbstractSecurityAction {
    private RBACManager manager;
    private String principal;
    private String roleName;
    private String description;
    private List<SimplePermission> permissions;
    private List<String> childRoles;
    private SimplePermission addpermission;
    private String submitMode;

    public String show() {
        if (this.permissions == null) {
            this.permissions = new ArrayList<SimplePermission>();
        }
        if (this.childRoles == null) {
            this.childRoles = new ArrayList<String>();
        }
        if (this.addpermission == null) {
            this.addpermission = new SimplePermission();
        }
        return "input";
    }

    public String addpermission() {
        if (this.addpermission == null) {
            this.addActionError(this.getText("cannot.add.null.permission"));
            return "error";
        }
        if (this.permissions == null) {
            this.permissions = new ArrayList<SimplePermission>();
        }
        this.permissions.add(this.addpermission);
        this.addpermission = new SimplePermission();
        return "input";
    }

    public String submit() {
        if (StringUtils.equals((String)this.getSubmitMode(), (String)"addPermission")) {
            return this.addpermission();
        }
        if (StringUtils.isEmpty((String)this.roleName)) {
            this.addActionError(this.getText("cannot.add.empty.role"));
            return "error";
        }
        try {
            Role _role = this.manager.roleExists(this.roleName) ? this.manager.getRole(this.roleName) : this.manager.createRole(this.roleName);
            _role.setDescription(this.description);
            _role.setChildRoleNames(this.childRoles);
            ArrayList<Permission> _permissionList = new ArrayList<Permission>();
            for (SimplePermission perm : this.permissions) {
                _permissionList.add(this.manager.createPermission(perm.getName(), perm.getOperationName(), perm.getResourceIdentifier()));
            }
            _role.setPermissions(_permissionList);
            this.manager.saveRole(_role);
            this.addActionMessage(this.getText("save.role.success", Arrays.asList(this.roleName)));
            String currentUser = this.getCurrentUser();
            AuditEvent event = new AuditEvent(this.getText("log.role.create"));
            event.setRole(this.roleName);
            event.setCurrentUser(currentUser);
            event.log();
        }
        catch (RbacManagerException e) {
            this.addActionError(this.getText("cannot.get.role", Arrays.asList(this.roleName, e.getMessage())));
            return "error";
        }
        return "success";
    }

    public String getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(String principal) {
        this.principal = principal;
    }

    public SimplePermission getAddpermission() {
        return this.addpermission;
    }

    public void setAddpermission(SimplePermission addpermission) {
        this.addpermission = addpermission;
    }

    public String getSubmitMode() {
        return this.submitMode;
    }

    public void setSubmitMode(String submitMode) {
        this.submitMode = submitMode;
    }

    public SecureActionBundle initSecureActionBundle() throws SecureActionException {
        SecureActionBundle bundle = new SecureActionBundle();
        bundle.setRequiresAuthentication(true);
        bundle.addRequiredAuthorization("user-management-rbac-admin", "*");
        return bundle;
    }
}

