/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.redback.struts2.action.admin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.codehaus.plexus.redback.rbac.RBACManager;
import org.codehaus.plexus.redback.struts2.action.AbstractSecurityAction;
import org.codehaus.plexus.redback.system.SecuritySystem;
import org.codehaus.plexus.registry.Registry;
import org.codehaus.redback.integration.interceptor.SecureActionBundle;
import org.codehaus.redback.integration.interceptor.SecureActionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemInfoAction
extends AbstractSecurityAction {
    private SecuritySystem securitySystem;
    private Registry registry;
    private RBACManager rbacManager;
    private static final List<String> ignoredReaders = Arrays.asList("class", "copy");
    private static final String NULL = "&lt;null&gt;";
    private static final char LN = '\r';
    private static final String INDENT = "  ";
    private static final int MAXDEPTH = 10;
    private StringBuffer details;

    public String show() {
        this.details = new StringBuffer();
        this.details.append("Configuration: ");
        this.dumpObject(this.details, this.registry, INDENT);
        this.details.append(this.registry.dump());
        this.details.append('\r');
        this.details.append('\r').append("<hr/>").append('\r');
        this.details.append("RBAC Manager: ");
        this.dumpObject(this.details, this.rbacManager, INDENT);
        this.details.append('\r').append("<hr/>").append('\r');
        this.details.append("SecuritySystem: ");
        this.dumpObject(this.details, this.securitySystem, INDENT);
        return "success";
    }

    private void dumpObject(StringBuffer sb, Object obj, String indent) {
        this.dumpObjectSwitchboard(new ArrayList<Object>(), sb, obj, indent, 0);
    }

    private void dumpObjectSwitchboard(List<Object> seenObjects, StringBuffer sb, Object obj, String indent, int depth) {
        if (obj == null) {
            sb.append(NULL).append('\r');
            return;
        }
        if (depth > 10) {
            sb.append(StringEscapeUtils.escapeHtml((String)"<MAX DEPTH>"));
            sb.append('\r');
            return;
        }
        ++depth;
        String className = obj.getClass().getName();
        sb.append('(').append(className).append(") ");
        if (obj instanceof List) {
            this.dumpIterator(seenObjects, sb, ((List)obj).iterator(), indent, depth);
        } else if (obj instanceof Set) {
            this.dumpIterator(seenObjects, sb, ((Set)obj).iterator(), indent, depth);
        } else if (obj instanceof Map) {
            this.dumpIterator(seenObjects, sb, ((Map)obj).entrySet().iterator(), indent, depth);
        } else if (obj instanceof Iterator) {
            this.dumpIterator(seenObjects, sb, (Iterator)obj, indent, depth);
        } else {
            if (className.startsWith("java.") || className.startsWith("javax.")) {
                sb.append(StringEscapeUtils.escapeHtml((String)obj.toString())).append('\r');
                return;
            }
            if (seenObjects.contains(obj)) {
                sb.append(StringEscapeUtils.escapeHtml((String)"<seen already preventing cycle in dump> "));
                sb.append('\r');
                return;
            }
            seenObjects.add(obj);
            this.dumpObjectReaders(seenObjects, sb, obj, indent, depth);
        }
        --depth;
    }

    private void dumpObjectReaders(List<Object> seenObjects, StringBuffer sb, Object obj, String indent, int depth) {
        sb.append(obj.toString()).append('\r');
        String name = null;
        try {
            Map readers = PropertyUtils.describe((Object)obj);
            for (Map.Entry readerEntry : readers.entrySet()) {
                name = (String)readerEntry.getKey();
                if (ignoredReaders.contains(name)) continue;
                sb.append(indent);
                sb.append(name).append(':');
                Object value = readerEntry.getValue();
                if (value == null) {
                    sb.append(NULL).append('\r');
                    continue;
                }
                this.dumpObjectSwitchboard(seenObjects, sb, value, INDENT + indent, depth);
            }
        }
        catch (Throwable e) {
            sb.append('\r').append(indent);
            sb.append("Unable to read bean [").append(obj.getClass().getName());
            if (StringUtils.isNotBlank((String)name)) {
                sb.append(".get").append(StringUtils.capitalize((String)name)).append("()");
            }
            sb.append("]: ").append('(').append(e.getClass().getName()).append(") ");
            sb.append(e.getMessage()).append('\r');
        }
    }

    private void dumpIterator(List<Object> seenObjects, StringBuffer sb, Iterator<?> iterator, String indent, int depth) {
        sb.append('\r');
        while (iterator.hasNext()) {
            Object entry = iterator.next();
            sb.append(indent);
            this.dumpObjectSwitchboard(seenObjects, sb, entry, indent + " | ", depth);
        }
    }

    public String getDetails() {
        return this.details.toString();
    }

    @Override
    public SecureActionBundle initSecureActionBundle() throws SecureActionException {
        SecureActionBundle bundle = new SecureActionBundle();
        bundle.setRequiresAuthentication(true);
        bundle.addRequiredAuthorization("configuration-edit", "*");
        return bundle;
    }
}

