/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.redback.struts2.action.admin;

import java.util.Arrays;
import org.codehaus.plexus.redback.rbac.RBACManager;
import org.codehaus.plexus.redback.rbac.RbacManagerException;
import org.codehaus.plexus.redback.rbac.RbacObjectInvalidException;
import org.codehaus.plexus.redback.rbac.RbacObjectNotFoundException;
import org.codehaus.plexus.redback.struts2.action.AbstractSecurityAction;
import org.codehaus.plexus.redback.struts2.action.AuditEvent;
import org.codehaus.plexus.redback.struts2.action.CancellableAction;
import org.codehaus.plexus.redback.users.User;
import org.codehaus.plexus.redback.users.UserManager;
import org.codehaus.plexus.redback.users.UserNotFoundException;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.redback.integration.interceptor.SecureActionBundle;
import org.codehaus.redback.integration.interceptor.SecureActionException;

public class UserDeleteAction
extends AbstractSecurityAction
implements CancellableAction {
    private UserManager userManager;
    private RBACManager rbacManager;
    private String username;
    private User user;

    public String confirm() {
        if (this.username == null) {
            this.addActionError(this.getText("cannot.remove.user.null.username"));
            return "success";
        }
        try {
            this.user = this.userManager.findUser(this.username);
        }
        catch (UserNotFoundException e) {
            this.addActionError(this.getText("cannot.remove.user.not.found", Arrays.asList(this.username)));
            return "success";
        }
        return "input";
    }

    public String submit() {
        if (this.username == null) {
            this.addActionError(this.getText("invalid.user.credentials"));
            return "success";
        }
        if (StringUtils.isEmpty((String)this.username)) {
            this.addActionError(this.getText("cannot.remove.user.empty.username"));
            return "success";
        }
        try {
            this.rbacManager.removeUserAssignment(this.username);
        }
        catch (RbacObjectNotFoundException e) {
        }
        catch (RbacObjectInvalidException e) {
            this.addActionError(this.getText("cannot.remove.user.role", Arrays.asList(this.username, e.getMessage())));
        }
        catch (RbacManagerException e) {
            this.addActionError(this.getText("cannot.remove.user.role", Arrays.asList(this.username, e.getMessage())));
        }
        if (this.getActionErrors().isEmpty()) {
            try {
                this.userManager.deleteUser(this.username);
            }
            catch (UserNotFoundException e) {
                this.addActionError(this.getText("cannot.remove.user.non.existent", Arrays.asList(this.username)));
            }
        }
        String currentUser = this.getCurrentUser();
        AuditEvent event = new AuditEvent(this.getText("log.account.delete"));
        event.setAffectedUser(this.username);
        event.setCurrentUser(currentUser);
        event.log();
        return "success";
    }

    public String cancel() {
        return "cancel";
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public SecureActionBundle initSecureActionBundle() throws SecureActionException {
        SecureActionBundle bundle = new SecureActionBundle();
        bundle.setRequiresAuthentication(true);
        bundle.addRequiredAuthorization("user-management-user-delete", "*");
        return bundle;
    }
}

