/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.redback.struts2.action.admin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.struts2.ServletActionContext;
import org.codehaus.plexus.redback.rbac.RBACManager;
import org.codehaus.plexus.redback.rbac.RbacManagerException;
import org.codehaus.plexus.redback.rbac.RbacObjectNotFoundException;
import org.codehaus.plexus.redback.rbac.Role;
import org.codehaus.plexus.redback.rbac.UserAssignment;
import org.codehaus.plexus.redback.struts2.action.AbstractSecurityAction;
import org.codehaus.plexus.redback.system.SecuritySystem;
import org.codehaus.plexus.redback.users.User;
import org.codehaus.plexus.redback.users.UserManager;
import org.codehaus.plexus.redback.users.UserQuery;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.redback.integration.interceptor.SecureActionBundle;
import org.codehaus.redback.integration.interceptor.SecureActionException;
import org.codehaus.redback.integration.reports.Report;
import org.codehaus.redback.integration.reports.ReportManager;
import org.extremecomponents.table.context.Context;
import org.extremecomponents.table.context.HttpServletRequestContext;
import org.extremecomponents.table.limit.FilterSet;
import org.extremecomponents.table.limit.LimitFactory;
import org.extremecomponents.table.limit.TableLimit;
import org.extremecomponents.table.limit.TableLimitFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserListAction
extends AbstractSecurityAction {
    private SecuritySystem securitySystem;
    private RBACManager rbac;
    private ReportManager reportManager;
    private List<User> users;
    private List<Role> roles;
    private String roleName;

    public String show() {
        try {
            this.roles = this.rbac.getAllRoles();
        }
        catch (RbacManagerException e) {
            this.roles = Collections.emptyList();
        }
        if (StringUtils.isEmpty((String)this.roleName)) {
            this.users = this.findUsersWithFilter();
        } else {
            try {
                Role target = this.rbac.getRole(this.roleName);
                HashSet<String> targetRoleNames = new HashSet<String>();
                for (int i = 0; i < this.roles.size(); ++i) {
                    Role r = this.roles.get(i);
                    if (!this.rbac.getEffectiveRoles(r).contains(target)) continue;
                    targetRoleNames.add(r.getName());
                }
                this.users = this.findUsers(targetRoleNames);
            }
            catch (RbacObjectNotFoundException e) {
                this.users = Collections.emptyList();
            }
            catch (RbacManagerException e) {
                this.users = Collections.emptyList();
            }
        }
        if (this.users == null) {
            this.users = Collections.emptyList();
        }
        return "input";
    }

    @Override
    public SecureActionBundle initSecureActionBundle() throws SecureActionException {
        SecureActionBundle bundle = new SecureActionBundle();
        bundle.setRequiresAuthentication(true);
        bundle.addRequiredAuthorization("user-management-user-list", "*");
        bundle.addRequiredAuthorization("user-management-user-role", "*");
        return bundle;
    }

    private List<User> findUsers(Collection<String> roleNames) {
        List<String> usernames = this.getUsernamesForRoles(roleNames);
        ArrayList<User> filteredUsers = new ArrayList<User>();
        for (User user : this.findUsersWithFilter()) {
            if (!usernames.contains(user.getUsername())) continue;
            filteredUsers.add(user);
        }
        return filteredUsers;
    }

    private List<User> findUsersWithFilter() {
        HttpServletRequestContext context = new HttpServletRequestContext(ServletActionContext.getRequest());
        TableLimitFactory limitFactory = new TableLimitFactory((Context)context);
        TableLimit limit = new TableLimit((LimitFactory)limitFactory);
        FilterSet filterSet = limit.getFilterSet();
        UserQuery query = this.getUserManager().createUserQuery();
        if (filterSet.getFilter("username") != null) {
            query.setUsername(filterSet.getFilter("username").getValue());
        }
        if (filterSet.getFilter("fullName") != null) {
            query.setFullName(filterSet.getFilter("fullName").getValue());
        }
        if (filterSet.getFilter("email") != null) {
            query.setEmail(filterSet.getFilter("email").getValue());
        }
        return this.getUserManager().findUsersByQuery(query);
    }

    private List<String> getUsernamesForRoles(Collection<String> roleNames) {
        HashSet<String> usernames = new HashSet<String>();
        try {
            List userAssignments = this.rbac.getUserAssignmentsForRoles(roleNames);
            if (userAssignments != null) {
                for (UserAssignment a : userAssignments) {
                    usernames.add(a.getPrincipal());
                }
            }
        }
        catch (RbacManagerException e) {
            this.log.warn("Unable to get user assignments for roles " + roleNames, (Throwable)e);
        }
        return new ArrayList<String>(usernames);
    }

    private UserManager getUserManager() {
        return this.securitySystem.getUserManager();
    }

    public List<User> getUsers() {
        return this.users;
    }

    public void setUsers(List<User> users) {
        this.users = users;
    }

    public String getRoleName() {
        if (StringUtils.isEmpty((String)this.roleName)) {
            return "Any";
        }
        return this.roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public List<Role> getRoles() {
        return this.roles;
    }

    public Map<String, Map<String, Report>> getReportMap() {
        return this.reportManager.getReportMap();
    }
}

