/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.redback.struts2.checks;

import com.opensymphony.xwork2.config.Configuration;
import com.opensymphony.xwork2.config.ConfigurationManager;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.plexus.redback.struts2.checks.AbstractXworkConfigurationCheck;
import org.codehaus.plexus.redback.system.check.EnvironmentCheck;
import org.codehaus.redback.integration.checks.xwork.XworkPackageConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpectedXworkConfiguration
extends AbstractXworkConfigurationCheck
implements EnvironmentCheck {
    public void validateEnvironment(List<String> violations) {
        Configuration xworkConfig = new ConfigurationManager().getConfiguration();
        if (xworkConfig != null) {
            ArrayList<String> internalViolations = new ArrayList<String>();
            XworkPackageConfig expectedPackage = new XworkPackageConfig("/security");
            expectedPackage.addAction("account", "redback-account", "show").addResult("input").addResult("error").addResult("success");
            expectedPackage.addAction("login", "redback-login", "show").addResult("input").addResult("error").addResult("success");
            expectedPackage.addAction("logout", "redback-logout", "show").addResult("input").addResult("error").addResult("success");
            expectedPackage.addAction("register", "redback-register", "show").addResult("input").addResult("error").addResult("success");
            expectedPackage.addAction("password", "redback-password", "show").addResult("input").addResult("error").addResult("success");
            expectedPackage.addAction("systeminfo", "redback-sysinfo", "show");
            expectedPackage.addAction("adminConsole", "redback-admin-console", "show");
            expectedPackage.addAction("userlist", "redback-admin-user-list", "show").addResult("input").addResult("success");
            expectedPackage.addAction("useredit", "redback-admin-user-edit", "edit").addResult("input").addResult("error").addResult("success");
            expectedPackage.addAction("usercreate", "redback-admin-user-create", "edit").addResult("input").addResult("error").addResult("success");
            expectedPackage.addAction("userdelete", "redback-admin-user-delete", "confirm").addResult("input").addResult("error").addResult("success");
            expectedPackage.addAction("assignments", "redback-assignments", "show").addResult("input").addResult("error").addResult("success");
            expectedPackage.addAction("roles", "redback-roles", "show").addResult("input").addResult("error").addResult("success");
            expectedPackage.addAction("permissions", "redback-permissions", "show").addResult("input").addResult("error").addResult("success");
            this.checkPackage(internalViolations, expectedPackage, xworkConfig);
            if (internalViolations.size() > 0) {
                violations.addAll(internalViolations);
                violations.add("Missing [" + internalViolations.size() + "] xwork.xml configuration elements.");
            }
        } else {
            violations.add("Missing xwork.xml configuration.");
        }
    }
}

